/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.bds.Bds;
import com.oracle.bmc.bds.model.AutoScalingConfiguration;
import com.oracle.bmc.bds.model.BdsInstance;
import com.oracle.bmc.bds.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.GetBdsInstanceRequest;
import com.oracle.bmc.bds.requests.GetWorkRequestRequest;
import com.oracle.bmc.bds.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.GetBdsInstanceResponse;
import com.oracle.bmc.bds.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class BdsWaiters {
    private final ExecutorService executorService;
    private final Bds client;

    public Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, AutoScalingConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAutoScalingConfiguration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, AutoScalingConfiguration.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAutoScalingConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AutoScalingConfiguration.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAutoScalingConfiguration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> forAutoScalingConfiguration(BmcGenericWaiter waiter, GetAutoScalingConfigurationRequest request, AutoScalingConfiguration.LifecycleState ... targetStates) {
        final HashSet<AutoScalingConfiguration.LifecycleState> targetStatesSet = new HashSet<AutoScalingConfiguration.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse>(){

            public GetAutoScalingConfigurationResponse apply(GetAutoScalingConfigurationRequest request) {
                return BdsWaiters.this.client.getAutoScalingConfiguration(request);
            }
        }, (Predicate)new Predicate<GetAutoScalingConfigurationResponse>(){

            public boolean apply(GetAutoScalingConfigurationResponse response) {
                return targetStatesSet.contains((Object)response.getAutoScalingConfiguration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AutoScalingConfiguration.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(GetBdsInstanceRequest request, BdsInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forBdsInstance(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(GetBdsInstanceRequest request, BdsInstance.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forBdsInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(GetBdsInstanceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, BdsInstance.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forBdsInstance(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetBdsInstanceRequest, GetBdsInstanceResponse> forBdsInstance(BmcGenericWaiter waiter, GetBdsInstanceRequest request, BdsInstance.LifecycleState ... targetStates) {
        final HashSet<BdsInstance.LifecycleState> targetStatesSet = new HashSet<BdsInstance.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetBdsInstanceRequest, GetBdsInstanceResponse>(){

            public GetBdsInstanceResponse apply(GetBdsInstanceRequest request) {
                return BdsWaiters.this.client.getBdsInstance(request);
            }
        }, (Predicate)new Predicate<GetBdsInstanceResponse>(){

            public boolean apply(GetBdsInstanceResponse response) {
                return targetStatesSet.contains((Object)response.getBdsInstance().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)BdsInstance.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return BdsWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public BdsWaiters(ExecutorService executorService, Bds client) {
        this.executorService = executorService;
        this.client = client;
    }
}

