/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.bds.Bds;
import com.oracle.bmc.bds.model.AutoScalingConfigurationSummary;
import com.oracle.bmc.bds.model.BdsInstanceSummary;
import com.oracle.bmc.bds.model.WorkRequest;
import com.oracle.bmc.bds.model.WorkRequestError;
import com.oracle.bmc.bds.model.WorkRequestLogEntry;
import com.oracle.bmc.bds.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.bds.requests.ListBdsInstancesRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestsRequest;
import com.oracle.bmc.bds.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.bds.responses.ListBdsInstancesResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class BdsPaginators {
    private final Bds client;

    public Iterable<ListAutoScalingConfigurationsResponse> listAutoScalingConfigurationsResponseIterator(final ListAutoScalingConfigurationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAutoScalingConfigurationsRequest.Builder>(){

            public ListAutoScalingConfigurationsRequest.Builder get() {
                return ListAutoScalingConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutoScalingConfigurationsResponse, String>(){

            public String apply(ListAutoScalingConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder>, ListAutoScalingConfigurationsRequest>(){

            public ListAutoScalingConfigurationsRequest apply(RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAutoScalingConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutoScalingConfigurationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>(){

            public ListAutoScalingConfigurationsResponse apply(ListAutoScalingConfigurationsRequest request) {
                return BdsPaginators.this.client.listAutoScalingConfigurations(request);
            }
        });
    }

    public Iterable<AutoScalingConfigurationSummary> listAutoScalingConfigurationsRecordIterator(final ListAutoScalingConfigurationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAutoScalingConfigurationsRequest.Builder>(){

            public ListAutoScalingConfigurationsRequest.Builder get() {
                return ListAutoScalingConfigurationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAutoScalingConfigurationsResponse, String>(){

            public String apply(ListAutoScalingConfigurationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder>, ListAutoScalingConfigurationsRequest>(){

            public ListAutoScalingConfigurationsRequest apply(RequestBuilderAndToken<ListAutoScalingConfigurationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListAutoScalingConfigurationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAutoScalingConfigurationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>(){

            public ListAutoScalingConfigurationsResponse apply(ListAutoScalingConfigurationsRequest request) {
                return BdsPaginators.this.client.listAutoScalingConfigurations(request);
            }
        }, (Function)new Function<ListAutoScalingConfigurationsResponse, List<AutoScalingConfigurationSummary>>(){

            public List<AutoScalingConfigurationSummary> apply(ListAutoScalingConfigurationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListBdsInstancesResponse> listBdsInstancesResponseIterator(final ListBdsInstancesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListBdsInstancesRequest.Builder>(){

            public ListBdsInstancesRequest.Builder get() {
                return ListBdsInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBdsInstancesResponse, String>(){

            public String apply(ListBdsInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBdsInstancesRequest.Builder>, ListBdsInstancesRequest>(){

            public ListBdsInstancesRequest apply(RequestBuilderAndToken<ListBdsInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListBdsInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBdsInstancesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListBdsInstancesRequest, ListBdsInstancesResponse>(){

            public ListBdsInstancesResponse apply(ListBdsInstancesRequest request) {
                return BdsPaginators.this.client.listBdsInstances(request);
            }
        });
    }

    public Iterable<BdsInstanceSummary> listBdsInstancesRecordIterator(final ListBdsInstancesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListBdsInstancesRequest.Builder>(){

            public ListBdsInstancesRequest.Builder get() {
                return ListBdsInstancesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListBdsInstancesResponse, String>(){

            public String apply(ListBdsInstancesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListBdsInstancesRequest.Builder>, ListBdsInstancesRequest>(){

            public ListBdsInstancesRequest apply(RequestBuilderAndToken<ListBdsInstancesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListBdsInstancesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListBdsInstancesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListBdsInstancesRequest, ListBdsInstancesResponse>(){

            public ListBdsInstancesResponse apply(ListBdsInstancesRequest request) {
                return BdsPaginators.this.client.listBdsInstances(request);
            }
        }, (Function)new Function<ListBdsInstancesResponse, List<BdsInstanceSummary>>(){

            public List<BdsInstanceSummary> apply(ListBdsInstancesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return BdsPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return BdsPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return BdsPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return BdsPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return BdsPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return BdsPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public BdsPaginators(Bds client) {
        this.client = client;
    }
}

