/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.bds.Bds;
import com.oracle.bmc.bds.BdsPaginators;
import com.oracle.bmc.bds.BdsWaiters;
import com.oracle.bmc.bds.internal.http.AddAutoScalingConfigurationConverter;
import com.oracle.bmc.bds.internal.http.AddBlockStorageConverter;
import com.oracle.bmc.bds.internal.http.AddCloudSqlConverter;
import com.oracle.bmc.bds.internal.http.AddWorkerNodesConverter;
import com.oracle.bmc.bds.internal.http.ChangeBdsInstanceCompartmentConverter;
import com.oracle.bmc.bds.internal.http.ChangeShapeConverter;
import com.oracle.bmc.bds.internal.http.CreateBdsInstanceConverter;
import com.oracle.bmc.bds.internal.http.DeleteBdsInstanceConverter;
import com.oracle.bmc.bds.internal.http.GetAutoScalingConfigurationConverter;
import com.oracle.bmc.bds.internal.http.GetBdsInstanceConverter;
import com.oracle.bmc.bds.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.bds.internal.http.ListAutoScalingConfigurationsConverter;
import com.oracle.bmc.bds.internal.http.ListBdsInstancesConverter;
import com.oracle.bmc.bds.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.bds.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.bds.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.bds.internal.http.RemoveAutoScalingConfigurationConverter;
import com.oracle.bmc.bds.internal.http.RemoveCloudSqlConverter;
import com.oracle.bmc.bds.internal.http.RestartNodeConverter;
import com.oracle.bmc.bds.internal.http.UpdateAutoScalingConfigurationConverter;
import com.oracle.bmc.bds.internal.http.UpdateBdsInstanceConverter;
import com.oracle.bmc.bds.requests.AddAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.AddBlockStorageRequest;
import com.oracle.bmc.bds.requests.AddCloudSqlRequest;
import com.oracle.bmc.bds.requests.AddWorkerNodesRequest;
import com.oracle.bmc.bds.requests.ChangeBdsInstanceCompartmentRequest;
import com.oracle.bmc.bds.requests.ChangeShapeRequest;
import com.oracle.bmc.bds.requests.CreateBdsInstanceRequest;
import com.oracle.bmc.bds.requests.DeleteBdsInstanceRequest;
import com.oracle.bmc.bds.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.GetBdsInstanceRequest;
import com.oracle.bmc.bds.requests.GetWorkRequestRequest;
import com.oracle.bmc.bds.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.bds.requests.ListBdsInstancesRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestsRequest;
import com.oracle.bmc.bds.requests.RemoveAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.RemoveCloudSqlRequest;
import com.oracle.bmc.bds.requests.RestartNodeRequest;
import com.oracle.bmc.bds.requests.UpdateAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.UpdateBdsInstanceRequest;
import com.oracle.bmc.bds.responses.AddAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.AddBlockStorageResponse;
import com.oracle.bmc.bds.responses.AddCloudSqlResponse;
import com.oracle.bmc.bds.responses.AddWorkerNodesResponse;
import com.oracle.bmc.bds.responses.ChangeBdsInstanceCompartmentResponse;
import com.oracle.bmc.bds.responses.ChangeShapeResponse;
import com.oracle.bmc.bds.responses.CreateBdsInstanceResponse;
import com.oracle.bmc.bds.responses.DeleteBdsInstanceResponse;
import com.oracle.bmc.bds.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.GetBdsInstanceResponse;
import com.oracle.bmc.bds.responses.GetWorkRequestResponse;
import com.oracle.bmc.bds.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.bds.responses.ListBdsInstancesResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestsResponse;
import com.oracle.bmc.bds.responses.RemoveAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.RemoveCloudSqlResponse;
import com.oracle.bmc.bds.responses.RestartNodeResponse;
import com.oracle.bmc.bds.responses.UpdateAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.UpdateBdsInstanceResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdsClient
implements Bds {
    private static final Logger LOG = LoggerFactory.getLogger(BdsClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BDS").serviceEndpointPrefix("").serviceEndpointTemplate("https://bigdataservice.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final BdsWaiters waiters;
    private final BdsPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public BdsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public BdsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public BdsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected BdsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Bds-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new BdsWaiters(executorService, this);
        this.paginators = new BdsPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AddAutoScalingConfigurationResponse addAutoScalingConfiguration(AddAutoScalingConfigurationRequest request) {
        LOG.trace("Called addAutoScalingConfiguration");
        AddAutoScalingConfigurationRequest interceptedRequest = AddAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddAutoScalingConfigurationResponse> transformer = AddAutoScalingConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AddAutoScalingConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddAutoScalingConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddAutoScalingConfigurationDetails(), (BmcRequest)retriedRequest);
                return (AddAutoScalingConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AddBlockStorageResponse addBlockStorage(AddBlockStorageRequest request) {
        LOG.trace("Called addBlockStorage");
        AddBlockStorageRequest interceptedRequest = AddBlockStorageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddBlockStorageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddBlockStorageResponse> transformer = AddBlockStorageConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AddBlockStorageResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddBlockStorageResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddBlockStorageDetails(), (BmcRequest)retriedRequest);
                return (AddBlockStorageResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AddCloudSqlResponse addCloudSql(AddCloudSqlRequest request) {
        LOG.trace("Called addCloudSql");
        AddCloudSqlRequest interceptedRequest = AddCloudSqlConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddCloudSqlConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddCloudSqlResponse> transformer = AddCloudSqlConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AddCloudSqlResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddCloudSqlResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddCloudSqlDetails(), (BmcRequest)retriedRequest);
                return (AddCloudSqlResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public AddWorkerNodesResponse addWorkerNodes(AddWorkerNodesRequest request) {
        LOG.trace("Called addWorkerNodes");
        AddWorkerNodesRequest interceptedRequest = AddWorkerNodesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddWorkerNodesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddWorkerNodesResponse> transformer = AddWorkerNodesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AddWorkerNodesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddWorkerNodesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddWorkerNodesDetails(), (BmcRequest)retriedRequest);
                return (AddWorkerNodesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeBdsInstanceCompartmentResponse changeBdsInstanceCompartment(ChangeBdsInstanceCompartmentRequest request) {
        LOG.trace("Called changeBdsInstanceCompartment");
        ChangeBdsInstanceCompartmentRequest interceptedRequest = ChangeBdsInstanceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeBdsInstanceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeBdsInstanceCompartmentResponse> transformer = ChangeBdsInstanceCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeBdsInstanceCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeBdsInstanceCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeBdsInstanceCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeBdsInstanceCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeShapeResponse changeShape(ChangeShapeRequest request) {
        LOG.trace("Called changeShape");
        ChangeShapeRequest interceptedRequest = ChangeShapeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeShapeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeShapeResponse> transformer = ChangeShapeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeShapeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeShapeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeShapeDetails(), (BmcRequest)retriedRequest);
                return (ChangeShapeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateBdsInstanceResponse createBdsInstance(CreateBdsInstanceRequest request) {
        LOG.trace("Called createBdsInstance");
        CreateBdsInstanceRequest interceptedRequest = CreateBdsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBdsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBdsInstanceResponse> transformer = CreateBdsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateBdsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateBdsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateBdsInstanceDetails(), (BmcRequest)retriedRequest);
                return (CreateBdsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteBdsInstanceResponse deleteBdsInstance(DeleteBdsInstanceRequest request) {
        LOG.trace("Called deleteBdsInstance");
        DeleteBdsInstanceRequest interceptedRequest = DeleteBdsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBdsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBdsInstanceResponse> transformer = DeleteBdsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteBdsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteBdsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteBdsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetAutoScalingConfigurationResponse getAutoScalingConfiguration(GetAutoScalingConfigurationRequest request) {
        LOG.trace("Called getAutoScalingConfiguration");
        GetAutoScalingConfigurationRequest interceptedRequest = GetAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutoScalingConfigurationResponse> transformer = GetAutoScalingConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetAutoScalingConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetAutoScalingConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetAutoScalingConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetBdsInstanceResponse getBdsInstance(GetBdsInstanceRequest request) {
        LOG.trace("Called getBdsInstance");
        GetBdsInstanceRequest interceptedRequest = GetBdsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBdsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBdsInstanceResponse> transformer = GetBdsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetBdsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetBdsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetBdsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListAutoScalingConfigurationsResponse listAutoScalingConfigurations(ListAutoScalingConfigurationsRequest request) {
        LOG.trace("Called listAutoScalingConfigurations");
        ListAutoScalingConfigurationsRequest interceptedRequest = ListAutoScalingConfigurationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutoScalingConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutoScalingConfigurationsResponse> transformer = ListAutoScalingConfigurationsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListAutoScalingConfigurationsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListAutoScalingConfigurationsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListAutoScalingConfigurationsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListBdsInstancesResponse listBdsInstances(ListBdsInstancesRequest request) {
        LOG.trace("Called listBdsInstances");
        ListBdsInstancesRequest interceptedRequest = ListBdsInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBdsInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBdsInstancesResponse> transformer = ListBdsInstancesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListBdsInstancesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListBdsInstancesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListBdsInstancesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RemoveAutoScalingConfigurationResponse removeAutoScalingConfiguration(RemoveAutoScalingConfigurationRequest request) {
        LOG.trace("Called removeAutoScalingConfiguration");
        RemoveAutoScalingConfigurationRequest interceptedRequest = RemoveAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveAutoScalingConfigurationResponse> transformer = RemoveAutoScalingConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RemoveAutoScalingConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemoveAutoScalingConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRemoveAutoScalingConfigurationDetails(), (BmcRequest)retriedRequest);
                return (RemoveAutoScalingConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RemoveCloudSqlResponse removeCloudSql(RemoveCloudSqlRequest request) {
        LOG.trace("Called removeCloudSql");
        RemoveCloudSqlRequest interceptedRequest = RemoveCloudSqlConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveCloudSqlConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveCloudSqlResponse> transformer = RemoveCloudSqlConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RemoveCloudSqlResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemoveCloudSqlResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRemoveCloudSqlDetails(), (BmcRequest)retriedRequest);
                return (RemoveCloudSqlResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RestartNodeResponse restartNode(RestartNodeRequest request) {
        LOG.trace("Called restartNode");
        RestartNodeRequest interceptedRequest = RestartNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestartNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestartNodeResponse> transformer = RestartNodeConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RestartNodeResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RestartNodeResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRestartNodeDetails(), (BmcRequest)retriedRequest);
                return (RestartNodeResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateAutoScalingConfigurationResponse updateAutoScalingConfiguration(UpdateAutoScalingConfigurationRequest request) {
        LOG.trace("Called updateAutoScalingConfiguration");
        UpdateAutoScalingConfigurationRequest interceptedRequest = UpdateAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAutoScalingConfigurationResponse> transformer = UpdateAutoScalingConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateAutoScalingConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateAutoScalingConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateAutoScalingConfigurationDetails(), (BmcRequest)retriedRequest);
                return (UpdateAutoScalingConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateBdsInstanceResponse updateBdsInstance(UpdateBdsInstanceRequest request) {
        LOG.trace("Called updateBdsInstance");
        UpdateBdsInstanceRequest interceptedRequest = UpdateBdsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBdsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBdsInstanceResponse> transformer = UpdateBdsInstanceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateBdsInstanceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateBdsInstanceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateBdsInstanceDetails(), (BmcRequest)retriedRequest);
                return (UpdateBdsInstanceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public BdsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public BdsPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BdsClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public BdsClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new BdsClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

