/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bds;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.bds.BdsAsync;
import com.oracle.bmc.bds.internal.http.AddAutoScalingConfigurationConverter;
import com.oracle.bmc.bds.internal.http.AddBlockStorageConverter;
import com.oracle.bmc.bds.internal.http.AddCloudSqlConverter;
import com.oracle.bmc.bds.internal.http.AddWorkerNodesConverter;
import com.oracle.bmc.bds.internal.http.ChangeBdsInstanceCompartmentConverter;
import com.oracle.bmc.bds.internal.http.ChangeShapeConverter;
import com.oracle.bmc.bds.internal.http.CreateBdsInstanceConverter;
import com.oracle.bmc.bds.internal.http.DeleteBdsInstanceConverter;
import com.oracle.bmc.bds.internal.http.GetAutoScalingConfigurationConverter;
import com.oracle.bmc.bds.internal.http.GetBdsInstanceConverter;
import com.oracle.bmc.bds.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.bds.internal.http.ListAutoScalingConfigurationsConverter;
import com.oracle.bmc.bds.internal.http.ListBdsInstancesConverter;
import com.oracle.bmc.bds.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.bds.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.bds.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.bds.internal.http.RemoveAutoScalingConfigurationConverter;
import com.oracle.bmc.bds.internal.http.RemoveCloudSqlConverter;
import com.oracle.bmc.bds.internal.http.RestartNodeConverter;
import com.oracle.bmc.bds.internal.http.UpdateAutoScalingConfigurationConverter;
import com.oracle.bmc.bds.internal.http.UpdateBdsInstanceConverter;
import com.oracle.bmc.bds.requests.AddAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.AddBlockStorageRequest;
import com.oracle.bmc.bds.requests.AddCloudSqlRequest;
import com.oracle.bmc.bds.requests.AddWorkerNodesRequest;
import com.oracle.bmc.bds.requests.ChangeBdsInstanceCompartmentRequest;
import com.oracle.bmc.bds.requests.ChangeShapeRequest;
import com.oracle.bmc.bds.requests.CreateBdsInstanceRequest;
import com.oracle.bmc.bds.requests.DeleteBdsInstanceRequest;
import com.oracle.bmc.bds.requests.GetAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.GetBdsInstanceRequest;
import com.oracle.bmc.bds.requests.GetWorkRequestRequest;
import com.oracle.bmc.bds.requests.ListAutoScalingConfigurationsRequest;
import com.oracle.bmc.bds.requests.ListBdsInstancesRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.bds.requests.ListWorkRequestsRequest;
import com.oracle.bmc.bds.requests.RemoveAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.RemoveCloudSqlRequest;
import com.oracle.bmc.bds.requests.RestartNodeRequest;
import com.oracle.bmc.bds.requests.UpdateAutoScalingConfigurationRequest;
import com.oracle.bmc.bds.requests.UpdateBdsInstanceRequest;
import com.oracle.bmc.bds.responses.AddAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.AddBlockStorageResponse;
import com.oracle.bmc.bds.responses.AddCloudSqlResponse;
import com.oracle.bmc.bds.responses.AddWorkerNodesResponse;
import com.oracle.bmc.bds.responses.ChangeBdsInstanceCompartmentResponse;
import com.oracle.bmc.bds.responses.ChangeShapeResponse;
import com.oracle.bmc.bds.responses.CreateBdsInstanceResponse;
import com.oracle.bmc.bds.responses.DeleteBdsInstanceResponse;
import com.oracle.bmc.bds.responses.GetAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.GetBdsInstanceResponse;
import com.oracle.bmc.bds.responses.GetWorkRequestResponse;
import com.oracle.bmc.bds.responses.ListAutoScalingConfigurationsResponse;
import com.oracle.bmc.bds.responses.ListBdsInstancesResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.bds.responses.ListWorkRequestsResponse;
import com.oracle.bmc.bds.responses.RemoveAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.RemoveCloudSqlResponse;
import com.oracle.bmc.bds.responses.RestartNodeResponse;
import com.oracle.bmc.bds.responses.UpdateAutoScalingConfigurationResponse;
import com.oracle.bmc.bds.responses.UpdateBdsInstanceResponse;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BdsAsyncClient
implements BdsAsync {
    private static final Logger LOG = LoggerFactory.getLogger(BdsAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("BDS").serviceEndpointPrefix("").serviceEndpointTemplate("https://bigdataservice.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public BdsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public BdsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public BdsAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public BdsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public BdsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public BdsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public BdsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public BdsAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AddAutoScalingConfigurationResponse> addAutoScalingConfiguration(AddAutoScalingConfigurationRequest request, AsyncHandler<AddAutoScalingConfigurationRequest, AddAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async addAutoScalingConfiguration");
        AddAutoScalingConfigurationRequest interceptedRequest = AddAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddAutoScalingConfigurationResponse> transformer = AddAutoScalingConfigurationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AddAutoScalingConfigurationRequest, AddAutoScalingConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddAutoScalingConfigurationRequest, AddAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AddBlockStorageResponse> addBlockStorage(AddBlockStorageRequest request, AsyncHandler<AddBlockStorageRequest, AddBlockStorageResponse> handler) {
        LOG.trace("Called async addBlockStorage");
        AddBlockStorageRequest interceptedRequest = AddBlockStorageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddBlockStorageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddBlockStorageResponse> transformer = AddBlockStorageConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AddBlockStorageRequest, AddBlockStorageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddBlockStorageRequest, AddBlockStorageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AddCloudSqlResponse> addCloudSql(AddCloudSqlRequest request, AsyncHandler<AddCloudSqlRequest, AddCloudSqlResponse> handler) {
        LOG.trace("Called async addCloudSql");
        AddCloudSqlRequest interceptedRequest = AddCloudSqlConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddCloudSqlConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddCloudSqlResponse> transformer = AddCloudSqlConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AddCloudSqlRequest, AddCloudSqlResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddCloudSqlRequest, AddCloudSqlResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<AddWorkerNodesResponse> addWorkerNodes(AddWorkerNodesRequest request, AsyncHandler<AddWorkerNodesRequest, AddWorkerNodesResponse> handler) {
        LOG.trace("Called async addWorkerNodes");
        AddWorkerNodesRequest interceptedRequest = AddWorkerNodesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddWorkerNodesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddWorkerNodesResponse> transformer = AddWorkerNodesConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AddWorkerNodesRequest, AddWorkerNodesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddWorkerNodesRequest, AddWorkerNodesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeBdsInstanceCompartmentResponse> changeBdsInstanceCompartment(ChangeBdsInstanceCompartmentRequest request, AsyncHandler<ChangeBdsInstanceCompartmentRequest, ChangeBdsInstanceCompartmentResponse> handler) {
        LOG.trace("Called async changeBdsInstanceCompartment");
        ChangeBdsInstanceCompartmentRequest interceptedRequest = ChangeBdsInstanceCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeBdsInstanceCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeBdsInstanceCompartmentResponse> transformer = ChangeBdsInstanceCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeBdsInstanceCompartmentRequest, ChangeBdsInstanceCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeBdsInstanceCompartmentRequest, ChangeBdsInstanceCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeShapeResponse> changeShape(ChangeShapeRequest request, AsyncHandler<ChangeShapeRequest, ChangeShapeResponse> handler) {
        LOG.trace("Called async changeShape");
        ChangeShapeRequest interceptedRequest = ChangeShapeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeShapeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeShapeResponse> transformer = ChangeShapeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeShapeRequest, ChangeShapeResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeShapeRequest, ChangeShapeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateBdsInstanceResponse> createBdsInstance(CreateBdsInstanceRequest request, AsyncHandler<CreateBdsInstanceRequest, CreateBdsInstanceResponse> handler) {
        LOG.trace("Called async createBdsInstance");
        CreateBdsInstanceRequest interceptedRequest = CreateBdsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateBdsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateBdsInstanceResponse> transformer = CreateBdsInstanceConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateBdsInstanceRequest, CreateBdsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateBdsInstanceRequest, CreateBdsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteBdsInstanceResponse> deleteBdsInstance(DeleteBdsInstanceRequest request, AsyncHandler<DeleteBdsInstanceRequest, DeleteBdsInstanceResponse> handler) {
        LOG.trace("Called async deleteBdsInstance");
        DeleteBdsInstanceRequest interceptedRequest = DeleteBdsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteBdsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteBdsInstanceResponse> transformer = DeleteBdsInstanceConverter.fromResponse();
        AsyncHandler<DeleteBdsInstanceRequest, DeleteBdsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteBdsInstanceRequest, DeleteBdsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetAutoScalingConfigurationResponse> getAutoScalingConfiguration(GetAutoScalingConfigurationRequest request, AsyncHandler<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async getAutoScalingConfiguration");
        GetAutoScalingConfigurationRequest interceptedRequest = GetAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetAutoScalingConfigurationResponse> transformer = GetAutoScalingConfigurationConverter.fromResponse();
        AsyncHandler<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetAutoScalingConfigurationRequest, GetAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetBdsInstanceResponse> getBdsInstance(GetBdsInstanceRequest request, AsyncHandler<GetBdsInstanceRequest, GetBdsInstanceResponse> handler) {
        LOG.trace("Called async getBdsInstance");
        GetBdsInstanceRequest interceptedRequest = GetBdsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetBdsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetBdsInstanceResponse> transformer = GetBdsInstanceConverter.fromResponse();
        AsyncHandler<GetBdsInstanceRequest, GetBdsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetBdsInstanceRequest, GetBdsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListAutoScalingConfigurationsResponse> listAutoScalingConfigurations(ListAutoScalingConfigurationsRequest request, AsyncHandler<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse> handler) {
        LOG.trace("Called async listAutoScalingConfigurations");
        ListAutoScalingConfigurationsRequest interceptedRequest = ListAutoScalingConfigurationsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListAutoScalingConfigurationsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListAutoScalingConfigurationsResponse> transformer = ListAutoScalingConfigurationsConverter.fromResponse();
        AsyncHandler<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListAutoScalingConfigurationsRequest, ListAutoScalingConfigurationsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListBdsInstancesResponse> listBdsInstances(ListBdsInstancesRequest request, AsyncHandler<ListBdsInstancesRequest, ListBdsInstancesResponse> handler) {
        LOG.trace("Called async listBdsInstances");
        ListBdsInstancesRequest interceptedRequest = ListBdsInstancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListBdsInstancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListBdsInstancesResponse> transformer = ListBdsInstancesConverter.fromResponse();
        AsyncHandler<ListBdsInstancesRequest, ListBdsInstancesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListBdsInstancesRequest, ListBdsInstancesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemoveAutoScalingConfigurationResponse> removeAutoScalingConfiguration(RemoveAutoScalingConfigurationRequest request, AsyncHandler<RemoveAutoScalingConfigurationRequest, RemoveAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async removeAutoScalingConfiguration");
        RemoveAutoScalingConfigurationRequest interceptedRequest = RemoveAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveAutoScalingConfigurationResponse> transformer = RemoveAutoScalingConfigurationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RemoveAutoScalingConfigurationRequest, RemoveAutoScalingConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemoveAutoScalingConfigurationRequest, RemoveAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemoveCloudSqlResponse> removeCloudSql(RemoveCloudSqlRequest request, AsyncHandler<RemoveCloudSqlRequest, RemoveCloudSqlResponse> handler) {
        LOG.trace("Called async removeCloudSql");
        RemoveCloudSqlRequest interceptedRequest = RemoveCloudSqlConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveCloudSqlConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveCloudSqlResponse> transformer = RemoveCloudSqlConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RemoveCloudSqlRequest, RemoveCloudSqlResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemoveCloudSqlRequest, RemoveCloudSqlResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestartNodeResponse> restartNode(RestartNodeRequest request, AsyncHandler<RestartNodeRequest, RestartNodeResponse> handler) {
        LOG.trace("Called async restartNode");
        RestartNodeRequest interceptedRequest = RestartNodeConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestartNodeConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestartNodeResponse> transformer = RestartNodeConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RestartNodeRequest, RestartNodeResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestartNodeRequest, RestartNodeResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateAutoScalingConfigurationResponse> updateAutoScalingConfiguration(UpdateAutoScalingConfigurationRequest request, AsyncHandler<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse> handler) {
        LOG.trace("Called async updateAutoScalingConfiguration");
        UpdateAutoScalingConfigurationRequest interceptedRequest = UpdateAutoScalingConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateAutoScalingConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateAutoScalingConfigurationResponse> transformer = UpdateAutoScalingConfigurationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateAutoScalingConfigurationRequest, UpdateAutoScalingConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateBdsInstanceResponse> updateBdsInstance(UpdateBdsInstanceRequest request, AsyncHandler<UpdateBdsInstanceRequest, UpdateBdsInstanceResponse> handler) {
        LOG.trace("Called async updateBdsInstance");
        UpdateBdsInstanceRequest interceptedRequest = UpdateBdsInstanceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateBdsInstanceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateBdsInstanceResponse> transformer = UpdateBdsInstanceConverter.fromResponse();
        AsyncHandler<UpdateBdsInstanceRequest, UpdateBdsInstanceResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateBdsInstanceRequest, UpdateBdsInstanceResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, BdsAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public BdsAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked @NonNull but is null");
            }
            return new BdsAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

