/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Nullability;
import io.r2dbc.spi.OutParameterMetadata;
import io.r2dbc.spi.R2dbcType;
import io.r2dbc.spi.ReadableMetadata;
import io.r2dbc.spi.Type;
import java.sql.ResultSetMetaData;
import java.sql.SQLType;
import java.util.Objects;
import oracle.jdbc.StructMetaData;
import oracle.r2dbc.OracleR2dbcTypes;
import oracle.r2dbc.impl.OracleR2dbcExceptions;
import oracle.r2dbc.impl.SqlTypeMap;

class OracleReadableMetadataImpl
implements ReadableMetadata {
    private static final int OFFSET_DATE_TIME_PRECISION = 35;
    private static final int LOCAL_DATE_TIME_PRECISION = 29;
    private static final int LOCAL_DATE_PRECISION = 10;
    private final Type type;
    private final String name;
    private final Nullability nullability;
    private final Integer precision;
    private final Integer scale;

    private OracleReadableMetadataImpl(Type type, String name, Nullability nullability, Integer precision, Integer scale) {
        this.type = type;
        this.name = name;
        this.nullability = nullability;
        this.precision = precision;
        this.scale = scale;
    }

    public Class<?> getJavaType() {
        return this.type.getJavaType();
    }

    public String getName() {
        return this.name;
    }

    public SQLType getNativeTypeMetadata() {
        return SqlTypeMap.toJdbcType(this.type);
    }

    public Nullability getNullability() {
        return this.nullability;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ReadableMetadata)) {
            return false;
        }
        ReadableMetadata otherMetadata = (ReadableMetadata)other;
        return Objects.equals(this.type, otherMetadata.getType()) && Objects.equals(this.name, otherMetadata.getName()) && Objects.equals(this.nullability, otherMetadata.getNullability()) && Objects.equals(this.precision, otherMetadata.getPrecision()) && Objects.equals(this.scale, otherMetadata.getScale());
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.nullability, this.precision, this.scale);
    }

    static OutParameterMetadata createParameterMetadata(String name, Type type) {
        return new OracleOutParameterMetadataImpl(type, name, Nullability.NULLABLE, null, null);
    }

    static ColumnMetadata createColumnMetadata(ResultSetMetaData resultSetMetaData, int index) {
        int jdbcIndex = index + 1;
        Type type = OracleReadableMetadataImpl.getR2dbcType(jdbcIndex, resultSetMetaData);
        String name = OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getColumnName(jdbcIndex));
        Nullability nullability = OracleReadableMetadataImpl.getNullability(OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.isNullable(jdbcIndex)));
        if (type == R2dbcType.NUMERIC) {
            return new OracleColumnMetadataImpl(type, name, nullability, OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getPrecision(jdbcIndex)), OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getScale(jdbcIndex)));
        }
        if (type == R2dbcType.BLOB || type == R2dbcType.CLOB || type == R2dbcType.NCLOB || type == OracleR2dbcTypes.JSON) {
            return new OracleColumnMetadataImpl(type, name, nullability, null, null);
        }
        if (type == R2dbcType.DATE) {
            return new OracleColumnMetadataImpl(type, name, nullability, 10, null);
        }
        if (type == R2dbcType.TIMESTAMP || type == OracleR2dbcTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return new OracleColumnMetadataImpl(type, name, nullability, 29, resultSetMetaData instanceof StructMetaData ? null : OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getScale(jdbcIndex)));
        }
        if (type == R2dbcType.TIMESTAMP_WITH_TIME_ZONE) {
            return new OracleColumnMetadataImpl(type, name, nullability, 35, resultSetMetaData instanceof StructMetaData ? null : OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getScale(jdbcIndex)));
        }
        if (type == R2dbcType.VARBINARY) {
            return new OracleColumnMetadataImpl(type, name, nullability, OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getColumnDisplaySize(jdbcIndex)), null);
        }
        int precision = OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getPrecision(jdbcIndex));
        int scale = OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getScale(jdbcIndex));
        if (type == null) {
            type = OracleR2dbcExceptions.fromJdbc(() -> new TypeImpl(resultSetMetaData.getColumnTypeName(jdbcIndex), OracleReadableMetadataImpl.tryGetClass(resultSetMetaData.getColumnClassName(jdbcIndex))));
        }
        return new OracleColumnMetadataImpl(type, name, nullability, precision == 0 ? null : Integer.valueOf(precision), scale == 0 ? null : Integer.valueOf(scale));
    }

    private static Type getR2dbcType(int index, ResultSetMetaData resultSetMetaData) {
        int jdbcType = OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getColumnType(index));
        switch (jdbcType) {
            case 2003: {
                return OracleR2dbcTypes.arrayType(OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getColumnTypeName(index)));
            }
            case 2002: {
                return OracleR2dbcTypes.objectType(OracleR2dbcExceptions.fromJdbc(() -> resultSetMetaData.getColumnTypeName(index)));
            }
            case -2: {
                return R2dbcType.VARBINARY;
            }
            case 91: {
                return R2dbcType.TIMESTAMP;
            }
            case -101: {
                return R2dbcType.TIMESTAMP_WITH_TIME_ZONE;
            }
        }
        return SqlTypeMap.toR2dbcType(jdbcType);
    }

    private static Nullability getNullability(int jdbcNullability) {
        switch (jdbcNullability) {
            case 0: {
                return Nullability.NON_NULL;
            }
            case 1: {
                return Nullability.NULLABLE;
            }
        }
        return Nullability.UNKNOWN;
    }

    private static Class<?> tryGetClass(String className) {
        try {
            return className == null ? Object.class : Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Object.class;
        }
    }

    private static final class TypeImpl
    implements Type {
        private final String name;
        private final Class<?> javaType;

        private TypeImpl(String name, Class<?> javaType) {
            this.name = name;
            this.javaType = javaType;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof TypeImpl) {
                TypeImpl typeImpl = (TypeImpl)object;
                return typeImpl.name.equals(this.name) && typeImpl.javaType.equals(this.javaType);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.javaType);
        }
    }

    private static final class OracleOutParameterMetadataImpl
    extends OracleReadableMetadataImpl
    implements OutParameterMetadata {
        private OracleOutParameterMetadataImpl(Type type, String name, Nullability nullability, Integer precision, Integer scale) {
            super(type, name, nullability, precision, scale);
        }
    }

    private static final class OracleColumnMetadataImpl
    extends OracleReadableMetadataImpl
    implements ColumnMetadata {
        private OracleColumnMetadataImpl(Type type, String name, Nullability nullability, Integer precision, Integer scale) {
            super(type, name, nullability, precision, scale);
        }
    }
}

