/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc.impl;

import io.r2dbc.spi.Clob;
import io.r2dbc.spi.R2dbcType;
import io.r2dbc.spi.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.util.Calendar;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.jdbc.OracleType;
import oracle.r2dbc.OracleR2dbcTypes;
import oracle.sql.json.OracleJsonObject;

final class SqlTypeMap {
    private static final Map<SQLType, Type> JDBC_TO_R2DBC_TYPE_MAP = Map.ofEntries(Map.entry(JDBCType.ARRAY, R2dbcType.COLLECTION), Map.entry(JDBCType.BIGINT, R2dbcType.BIGINT), Map.entry(JDBCType.BINARY, R2dbcType.BINARY), Map.entry(OracleType.BINARY_DOUBLE, OracleR2dbcTypes.BINARY_DOUBLE), Map.entry(OracleType.BINARY_FLOAT, OracleR2dbcTypes.BINARY_FLOAT), Map.entry(JDBCType.BLOB, R2dbcType.BLOB), Map.entry(JDBCType.BOOLEAN, R2dbcType.BOOLEAN), Map.entry(JDBCType.CHAR, R2dbcType.CHAR), Map.entry(JDBCType.CLOB, R2dbcType.CLOB), Map.entry(JDBCType.DATE, R2dbcType.DATE), Map.entry(JDBCType.DECIMAL, R2dbcType.DECIMAL), Map.entry(JDBCType.DOUBLE, R2dbcType.DOUBLE), Map.entry(JDBCType.FLOAT, R2dbcType.FLOAT), Map.entry(JDBCType.INTEGER, R2dbcType.INTEGER), Map.entry(OracleType.INTERVAL_DAY_TO_SECOND, OracleR2dbcTypes.INTERVAL_DAY_TO_SECOND), Map.entry(OracleType.INTERVAL_YEAR_TO_MONTH, OracleR2dbcTypes.INTERVAL_YEAR_TO_MONTH), Map.entry(OracleType.JSON, OracleR2dbcTypes.JSON), Map.entry(JDBCType.LONGVARBINARY, OracleR2dbcTypes.LONG_RAW), Map.entry(JDBCType.LONGVARCHAR, OracleR2dbcTypes.LONG), Map.entry(JDBCType.NCHAR, R2dbcType.NCHAR), Map.entry(JDBCType.NCLOB, R2dbcType.NCLOB), Map.entry(JDBCType.NUMERIC, R2dbcType.NUMERIC), Map.entry(JDBCType.NVARCHAR, R2dbcType.NVARCHAR), Map.entry(JDBCType.REAL, R2dbcType.REAL), Map.entry(JDBCType.ROWID, OracleR2dbcTypes.ROWID), Map.entry(JDBCType.SMALLINT, R2dbcType.SMALLINT), Map.entry(JDBCType.TIME, R2dbcType.TIME), Map.entry(JDBCType.TIME_WITH_TIMEZONE, R2dbcType.TIME_WITH_TIME_ZONE), Map.entry(JDBCType.TIMESTAMP, R2dbcType.TIMESTAMP), Map.entry(OracleType.TIMESTAMP_WITH_LOCAL_TIME_ZONE, OracleR2dbcTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE), Map.entry(OracleType.TIMESTAMP_WITH_TIME_ZONE, R2dbcType.TIMESTAMP_WITH_TIME_ZONE), Map.entry(JDBCType.TINYINT, R2dbcType.TINYINT), Map.entry(JDBCType.VARBINARY, R2dbcType.VARBINARY), Map.entry(JDBCType.VARCHAR, R2dbcType.VARCHAR));
    private static final Map<Type, SQLType> R2DBC_TO_JDBC_TYPE_MAP = JDBC_TO_R2DBC_TYPE_MAP.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    private static final Map<Class<?>, SQLType> JAVA_TO_SQL_TYPE_MAP = Map.ofEntries(Map.entry(String.class, JDBCType.VARCHAR), Map.entry(Boolean.class, JDBCType.BOOLEAN), Map.entry(ByteBuffer.class, JDBCType.VARBINARY), Map.entry(Integer.class, JDBCType.INTEGER), Map.entry(Byte.class, JDBCType.TINYINT), Map.entry(Short.class, JDBCType.SMALLINT), Map.entry(Long.class, JDBCType.BIGINT), Map.entry(BigDecimal.class, JDBCType.NUMERIC), Map.entry(Float.class, JDBCType.REAL), Map.entry(Double.class, JDBCType.DOUBLE), Map.entry(LocalDate.class, JDBCType.DATE), Map.entry(LocalTime.class, JDBCType.TIME), Map.entry(OffsetTime.class, JDBCType.TIME_WITH_TIMEZONE), Map.entry(LocalDateTime.class, JDBCType.TIMESTAMP), Map.entry(OffsetDateTime.class, JDBCType.TIMESTAMP_WITH_TIMEZONE), Map.entry(io.r2dbc.spi.Blob.class, JDBCType.BLOB), Map.entry(Clob.class, JDBCType.CLOB), Map.entry(byte[].class, JDBCType.VARBINARY), Map.entry(BigInteger.class, JDBCType.BIGINT), Map.entry(Date.class, JDBCType.DATE), Map.entry(Time.class, JDBCType.TIME), Map.entry(Timestamp.class, JDBCType.TIMESTAMP), Map.entry(Array.class, JDBCType.ARRAY), Map.entry(Blob.class, JDBCType.BLOB), Map.entry(java.sql.Clob.class, JDBCType.CLOB), Map.entry(Struct.class, JDBCType.STRUCT), Map.entry(Ref.class, JDBCType.REF), Map.entry(URL.class, JDBCType.DATALINK), Map.entry(RowId.class, JDBCType.ROWID), Map.entry(NClob.class, JDBCType.NCLOB), Map.entry(SQLXML.class, JDBCType.SQLXML), Map.entry(Calendar.class, JDBCType.TIMESTAMP), Map.entry(java.util.Date.class, JDBCType.TIMESTAMP), Map.entry(Duration.class, OracleType.INTERVAL_DAY_TO_SECOND), Map.entry(Period.class, OracleType.INTERVAL_YEAR_TO_MONTH), Map.entry(OracleJsonObject.class, OracleType.JSON));

    SqlTypeMap() {
    }

    static Type toR2dbcType(SQLType jdbcType) {
        return JDBC_TO_R2DBC_TYPE_MAP.get(jdbcType);
    }

    static Type toR2dbcType(int jdbcTypeNumber) {
        for (JDBCType jdbcType : JDBCType.values()) {
            Integer vendorTypeNumber = jdbcType.getVendorTypeNumber();
            if (vendorTypeNumber == null || vendorTypeNumber != jdbcTypeNumber) continue;
            return SqlTypeMap.toR2dbcType(jdbcType);
        }
        try {
            OracleType oracleType = OracleType.toOracleType((int)jdbcTypeNumber);
            if (oracleType != null) {
                return SqlTypeMap.toR2dbcType((SQLType)oracleType);
            }
            return null;
        }
        catch (SQLException typeNotFound) {
            return null;
        }
    }

    static SQLType toJdbcType(Type r2dbcType) {
        return r2dbcType instanceof Type.InferredType ? SqlTypeMap.toJdbcType(r2dbcType.getJavaType()) : R2DBC_TO_JDBC_TYPE_MAP.get(r2dbcType);
    }

    static SQLType toJdbcType(Class<?> javaType) {
        SQLType sqlType = JAVA_TO_SQL_TYPE_MAP.get(javaType);
        if (sqlType != null) {
            return sqlType;
        }
        return JAVA_TO_SQL_TYPE_MAP.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(javaType)).map(Map.Entry::getValue).findFirst().orElse(null);
    }
}

