/*
 * Decompiled with CFR 0.152.
 */
package oracle.r2dbc;

import io.r2dbc.spi.Type;
import java.nio.ByteBuffer;
import java.sql.RowId;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import oracle.sql.json.OracleJsonObject;

public final class OracleR2dbcTypes {
    public static final Type BINARY_DOUBLE = new TypeImpl(Double.class, "BINARY_DOUBLE");
    public static final Type BINARY_FLOAT = new TypeImpl(Float.class, "BINARY_FLOAT");
    public static final Type INTERVAL_DAY_TO_SECOND = new TypeImpl(Duration.class, "INTERVAL DAY TO SECOND");
    public static final Type INTERVAL_YEAR_TO_MONTH = new TypeImpl(Period.class, "INTERVAL YEAR TO MONTH");
    public static final Type JSON = new TypeImpl(OracleJsonObject.class, "JSON");
    public static final Type LONG = new TypeImpl(String.class, "LONG");
    public static final Type LONG_RAW = new TypeImpl(ByteBuffer.class, "LONG RAW");
    public static final Type ROWID = new TypeImpl(RowId.class, "ROWID");
    public static final Type TIMESTAMP_WITH_LOCAL_TIME_ZONE = new TypeImpl(LocalDateTime.class, "TIMESTAMP WITH LOCAL TIME ZONE");

    private OracleR2dbcTypes() {
    }

    private static final class TypeImpl
    implements Type {
        private final Class<?> javaType;
        private final String sqlName;

        TypeImpl(Class<?> javaType, String sqlName) {
            this.javaType = javaType;
            this.sqlName = sqlName;
        }

        public Class<?> getJavaType() {
            return this.javaType;
        }

        public String getName() {
            return this.sqlName;
        }

        public String toString() {
            return this.getName();
        }
    }
}

