/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli;

public class Option {
    protected final String longName;
    protected final String shortName;
    protected final String description;
    protected final boolean mandatory;
    protected final int maxRepetitions;

    public Option(String longName, String shortName, String description, boolean mandatory, int maxRepetitions) {
        this.longName = longName;
        this.shortName = shortName;
        this.description = description;
        this.mandatory = mandatory;
        this.maxRepetitions = maxRepetitions;
    }

    Option(String longName, String description, boolean mandatory, int maxRepetitions) {
        this.longName = longName;
        this.shortName = null;
        this.description = description;
        this.mandatory = mandatory;
        this.maxRepetitions = maxRepetitions;
    }

    protected String getLongName() {
        return this.longName;
    }

    protected String getShortName() {
        return this.shortName;
    }

    protected String getDescription() {
        return this.description;
    }

    protected boolean isMandatory() {
        return this.mandatory;
    }

    protected int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Option option = (Option)obj;
        return this.longName.equals(option.longName) && (this.shortName != null ? this.shortName.equals(option.shortName) : option.shortName == null);
    }

    public int hashCode() {
        int result = this.longName.hashCode();
        result = 31 * result + (this.shortName != null ? this.shortName.hashCode() : 0);
        return result;
    }
}

