/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.jdbc.internal.Monitor;
import oracle.sql.ANYDATA;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class OracleCallableStatement
extends OraclePreparedStatement
implements oracle.jdbc.internal.OracleCallableStatement {
    private static final String CLASS_NAME = OracleCallableStatement.class.getName();
    boolean atLeastOneOrdinalParameter = false;
    boolean atLeastOneNamedParameter = false;
    String[] namedParameters = new String[8];
    int parameterCount = 0;
    static final String errMsgMixedBind = "Ordinal binding and Named binding cannot be combined!";
    static final int INITREMAININGCURSORS = -1;
    int remainingCursors;

    protected OracleCallableStatement(PhysicalConnection connection, String sql, OracleResultSet.ResultSetType resultSetType) throws SQLException {
        super(connection, sql, resultSetType, null);
        this.statementType = 2;
        this.remainingCursors = -1;
    }

    void registerOutParameterInternal(int paramIndex, int external_type, int scale, int maxLength, String sqlName) throws SQLException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "registerOutParameterInternal", "paramIndex={0}, external_type={1}, scale={2}, maxLength={3}, sqlName={4}. ", (String)null, (Throwable)null, (Object)paramIndex, (Object)external_type, (Object)scale, (Object)maxLength, (Object)sqlName);
        this.ensureOpen();
        int index = paramIndex - 1;
        if (index < 0 || paramIndex > this.numberOfBindPositions) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        if (external_type == 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
        }
        int internal_type = this.getInternalType(external_type);
        if (external_type == 252 && (this.connection.databaseMetaData.getDatabaseMajorVersion() < 12 || this.connection.databaseMetaData.getDatabaseMajorVersion() == 12 && this.connection.databaseMetaData.getDatabaseMinorVersion() < 1)) {
            throw (SQLException)DatabaseError.createSqlException(299).fillInStackTrace();
        }
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        switch (external_type) {
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
            case 70: {
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                this.currentRowFormOfUse[index] = 2;
                break;
            }
            case 2011: {
                maxLength = 0;
                this.currentRowFormOfUse[index] = 2;
                break;
            }
            case 2009: {
                maxLength = 0;
                sqlName = "SYS.XMLTYPE";
                break;
            }
            case 2002: 
            case 2003: {
                if (sqlName == null || sqlName.length() == 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
                }
                maxLength = 0;
                break;
            }
            default: {
                maxLength = 0;
            }
        }
        this.currentRowBindAccessors[index] = this.allocateAccessor(internal_type, external_type, index + 1, maxLength, this.currentRowFormOfUse[index], sqlName, true);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, String sqlName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.registerOutParameterInternal(paramIndex, sqlType, 0, -1, sqlName);
            this.atLeastOneOrdinalParameter = true;
        }
    }

    @Override
    @Deprecated
    public void registerOutParameterBytes(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.registerOutParameterInternal(paramIndex, sqlType, scale, maxLength, null);
            this.atLeastOneOrdinalParameter = true;
        }
    }

    @Override
    @Deprecated
    public void registerOutParameterChars(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.registerOutParameterInternal(paramIndex, sqlType, scale, maxLength, null);
            this.atLeastOneOrdinalParameter = true;
        }
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, int scale, int maxLength) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.registerOutParameterInternal(paramIndex, sqlType, scale, maxLength, null);
            this.atLeastOneOrdinalParameter = true;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale, int maxLength) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.registerOutParameterInternal(parameterName, sqlType, scale, maxLength, null);
            this.atLeastOneNamedParameter = true;
        }
    }

    @Override
    public void registerOutParameterAtName(String parameterMarkerName, int sqlType) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String iName = parameterMarkerName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.registerOutParameter(i + 1, sqlType);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, parameterMarkerName).fillInStackTrace();
            }
        }
    }

    @Override
    public void registerOutParameterAtName(String parameterMarkerName, int sqlType, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String iName = parameterMarkerName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.registerOutParameter(i + 1, sqlType, scale);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, parameterMarkerName).fillInStackTrace();
            }
        }
    }

    @Override
    public void registerOutParameterAtName(String parameterMarkerName, int sqlType, String typeName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String iName = parameterMarkerName.intern();
            String[] names = this.sqlObject.getParameterList();
            int count = Math.min(this.sqlObject.getParameterCount(), names.length);
            boolean firstOccurrence = true;
            for (int i = 0; i < count; ++i) {
                if (names[i] != iName) continue;
                if (firstOccurrence) {
                    this.registerOutParameter(i + 1, sqlType, typeName);
                    firstOccurrence = false;
                    continue;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 135).fillInStackTrace();
            }
            if (firstOccurrence) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 147, parameterMarkerName).fillInStackTrace();
            }
        }
    }

    @Override
    boolean isOracleBatchStyle() {
        return false;
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType) throws SQLException {
        this.registerOutParameter(paramIndex, sqlType, 0, -1);
    }

    @Override
    public void registerOutParameter(int paramIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(paramIndex, sqlType, scale, -1);
    }

    @Override
    public boolean wasNull() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean bl = this.wasNullValue(0L);
            return bl;
        }
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            String string = accessor.getString(this.currentRank);
            return string;
        }
    }

    @Override
    public Datum getOracleObject(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Datum datum = accessor.getOracleObject(this.currentRank);
            return datum;
        }
    }

    @Override
    public ROWID getROWID(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ROWID rOWID = accessor.getROWID(this.currentRank);
            return rOWID;
        }
    }

    @Override
    public NUMBER getNUMBER(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            NUMBER nUMBER = accessor.getNUMBER(this.currentRank);
            return nUMBER;
        }
    }

    @Override
    public DATE getDATE(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            DATE dATE = accessor.getDATE(this.currentRank);
            return dATE;
        }
    }

    @Override
    public INTERVALYM getINTERVALYM(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            INTERVALYM iNTERVALYM = accessor.getINTERVALYM(this.currentRank);
            return iNTERVALYM;
        }
    }

    @Override
    public INTERVALDS getINTERVALDS(int parameterIndex) throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        if (this.atLeastOneNamedParameter) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
        }
        Accessor accessor = null;
        if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
        }
        this.lastIndex = parameterIndex;
        if (this.streamList != null) {
            this.closeUsedStreams(parameterIndex);
        }
        return accessor.getINTERVALDS(this.currentRank);
    }

    @Override
    public TIMESTAMP getTIMESTAMP(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            TIMESTAMP tIMESTAMP = accessor.getTIMESTAMP(this.currentRank);
            return tIMESTAMP;
        }
    }

    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            TIMESTAMPTZ tIMESTAMPTZ = accessor.getTIMESTAMPTZ(this.currentRank);
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = accessor.getTIMESTAMPLTZ(this.currentRank);
            return tIMESTAMPLTZ;
        }
    }

    @Override
    public REF getREF(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            REF rEF = accessor.getREF(this.currentRank);
            return rEF;
        }
    }

    @Override
    public ARRAY getARRAY(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ARRAY aRRAY = accessor.getARRAY(this.currentRank);
            return aRRAY;
        }
    }

    @Override
    public STRUCT getSTRUCT(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            STRUCT sTRUCT = accessor.getSTRUCT(this.currentRank);
            return sTRUCT;
        }
    }

    @Override
    public OPAQUE getOPAQUE(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            OPAQUE oPAQUE = accessor.getOPAQUE(this.currentRank);
            return oPAQUE;
        }
    }

    @Override
    public CHAR getCHAR(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            CHAR cHAR = accessor.getCHAR(this.currentRank);
            return cHAR;
        }
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Reader reader = accessor.getCharacterStream(this.currentRank);
            return reader;
        }
    }

    @Override
    public RAW getRAW(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            RAW rAW = accessor.getRAW(this.currentRank);
            return rAW;
        }
    }

    @Override
    public BLOB getBLOB(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BLOB bLOB = accessor.getBLOB(this.currentRank);
            return bLOB;
        }
    }

    @Override
    public CLOB getCLOB(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            CLOB cLOB = accessor.getCLOB(this.currentRank);
            return cLOB;
        }
    }

    @Override
    public BFILE getBFILE(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BFILE bFILE = accessor.getBFILE(this.currentRank);
            return bFILE;
        }
    }

    @Override
    public BFILE getBfile(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BFILE bFILE = accessor.getBFILE(this.currentRank);
            return bFILE;
        }
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            boolean bl = accessor.getBoolean(this.currentRank);
            return bl;
        }
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            byte by = accessor.getByte(this.currentRank);
            return by;
        }
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            short s = accessor.getShort(this.currentRank);
            return s;
        }
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            int n = accessor.getInt(this.currentRank);
            return n;
        }
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            long l = accessor.getLong(this.currentRank);
            return l;
        }
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            float f = accessor.getFloat(this.currentRank);
            return f;
        }
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            double d = accessor.getDouble(this.currentRank);
            return d;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BigDecimal bigDecimal = accessor.getBigDecimal(this.currentRank);
            return bigDecimal;
        }
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            byte[] byArray = accessor.getBytes(this.currentRank);
            return byArray;
        }
    }

    @Override
    public byte[] privateGetBytes(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            byte[] byArray = accessor.getBytesInternal(this.currentRank);
            return byArray;
        }
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Date date = accessor.getDate(this.currentRank);
            return date;
        }
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Time time = accessor.getTime(this.currentRank);
            return time;
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Timestamp timestamp = accessor.getTimestamp(this.currentRank);
            return timestamp;
        }
    }

    @Override
    public InputStream getAsciiStream(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            InputStream inputStream = accessor.getAsciiStream(this.currentRank);
            return inputStream;
        }
    }

    @Override
    public InputStream getUnicodeStream(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            InputStream inputStream = accessor.getUnicodeStream(this.currentRank);
            return inputStream;
        }
    }

    @Override
    public InputStream getBinaryStream(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            InputStream inputStream = accessor.getBinaryStream(this.currentRank);
            return inputStream;
        }
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Object object = accessor.getObject(this.currentRank);
            return object;
        }
    }

    @Override
    public Object getAnyDataEmbeddedObject(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Datum d;
            Object result = null;
            Object o = this.getObject(parameterIndex);
            if (o instanceof ANYDATA && (d = ((ANYDATA)o).accessDatum()) != null) {
                result = d.toJdbc();
            }
            Object object = result;
            return object;
        }
    }

    @Override
    public Object getCustomDatum(int parameterIndex, CustomDatumFactory factory) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            CustomDatum customDatum = accessor.getCustomDatum(this.currentRank, factory);
            return customDatum;
        }
    }

    @Override
    public Object getObject(int parameterIndex, OracleDataFactory factory) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Object object = accessor.getObject(this.currentRank, factory);
            return object;
        }
    }

    @Override
    public Object getORAData(int parameterIndex, ORADataFactory factory) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ORAData oRAData = accessor.getORAData(this.currentRank, factory);
            return oRAData;
        }
    }

    @Override
    public ResultSet getCursor(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ResultSet resultSet = accessor.getCursor(this.currentRank);
            return resultSet;
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            super.clearParametersCritical();
        }
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Object object = accessor.getObject(this.currentRank, map);
            return object;
        }
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            REF rEF = accessor.getREF(this.currentRank);
            return rEF;
        }
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BLOB bLOB = accessor.getBLOB(this.currentRank);
            return bLOB;
        }
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            CLOB cLOB = accessor.getCLOB(this.currentRank);
            return cLOB;
        }
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ARRAY aRRAY = accessor.getARRAY(this.currentRank);
            return aRRAY;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BigDecimal bigDecimal = accessor.getBigDecimal(this.currentRank);
            return bigDecimal;
        }
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Date date = accessor.getDate(this.currentRank, cal);
            return date;
        }
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Time time = accessor.getTime(this.currentRank, cal);
            return time;
        }
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Timestamp timestamp = accessor.getTimestamp(this.currentRank, cal);
            return timestamp;
        }
    }

    @Override
    public void addBatch() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.currentRowBindAccessors != null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Stored procedure with out or inout parameters cannot be batched").fillInStackTrace();
            }
            super.addBatch();
        }
    }

    @Override
    protected void alwaysOnClose() throws SQLException {
        this.sqlObject.resetNamedParameters();
        this.namedParameters = new String[8];
        this.parameterCount = 0;
        this.atLeastOneOrdinalParameter = false;
        this.atLeastOneNamedParameter = false;
        super.alwaysOnClose();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.registerOutParameterInternal(parameterName, sqlType, 0, -1, null);
            this.atLeastOneNamedParameter = true;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.registerOutParameterInternal(parameterName, sqlType, scale, -1, null);
            this.atLeastOneNamedParameter = true;
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.registerOutParameterInternal(parameterName, sqlType, 0, -1, typeName);
        }
    }

    void registerOutParameterInternal(String parameterName, int sqlType, int scale, int maxLength, String typeName) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.registerOutParameterInternal(index, sqlType, scale, maxLength, typeName);
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            URL uRL = accessor.getURL(this.currentRank);
            return uRL;
        }
    }

    @Override
    public void setStringForClob(String parameterName, String x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        if (x == null || x.length() == 0) {
            this.setNull(index, 2005);
            return;
        }
        this.setStringForClob(index, x);
    }

    @Override
    public void setStringForClob(int paramIndex, String x) throws SQLException {
        if (x == null || x.length() == 0) {
            this.setNull(paramIndex, 2005);
            return;
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setStringForClobCritical(paramIndex, x);
        }
    }

    @Override
    public void setBytesForBlob(String parameterName, byte[] x) throws SQLException {
        int index = this.addNamedPara(parameterName);
        this.setBytesForBlob(index, x);
    }

    @Override
    public void setBytesForBlob(int paramIndex, byte[] x) throws SQLException {
        if (x == null || x.length == 0) {
            this.setNull(paramIndex, 2004);
            return;
        }
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.setBytesForBlobCritical(paramIndex, x);
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            String string = accessor.getString(this.currentRank);
            return string;
        }
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            boolean bl = accessor.getBoolean(this.currentRank);
            return bl;
        }
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            byte by = accessor.getByte(this.currentRank);
            return by;
        }
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            short s = accessor.getShort(this.currentRank);
            return s;
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            int n = accessor.getInt(this.currentRank);
            return n;
        }
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            long l = accessor.getLong(this.currentRank);
            return l;
        }
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            float f = accessor.getFloat(this.currentRank);
            return f;
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            double d = accessor.getDouble(this.currentRank);
            return d;
        }
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            byte[] byArray = accessor.getBytes(this.currentRank);
            return byArray;
        }
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Date date = accessor.getDate(this.currentRank);
            return date;
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Time time = accessor.getTime(this.currentRank);
            return time;
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Timestamp timestamp = accessor.getTimestamp(this.currentRank);
            return timestamp;
        }
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Object object = accessor.getObject(this.currentRank);
            return object;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BigDecimal bigDecimal = accessor.getBigDecimal(this.currentRank);
            return bigDecimal;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BigDecimal bigDecimal = accessor.getBigDecimal(this.currentRank, scale);
            return bigDecimal;
        }
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Object object = accessor.getObject(this.currentRank, map);
            return object;
        }
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            REF rEF = accessor.getREF(this.currentRank);
            return rEF;
        }
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            BLOB bLOB = accessor.getBLOB(this.currentRank);
            return bLOB;
        }
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            CLOB cLOB = accessor.getCLOB(this.currentRank);
            return cLOB;
        }
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ARRAY aRRAY = accessor.getARRAY(this.currentRank);
            return aRRAY;
        }
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Date date = accessor.getDate(this.currentRank, cal);
            return date;
        }
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Time time = accessor.getTime(this.currentRank, cal);
            return time;
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Timestamp timestamp = accessor.getTimestamp(this.currentRank, cal);
            return timestamp;
        }
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            URL uRL = accessor.getURL(this.currentRank);
            return uRL;
        }
    }

    @Override
    @Deprecated
    public InputStream getAsciiStream(String parameterName) throws SQLException {
        throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getAsciiStream").fillInStackTrace();
    }

    @Override
    @Deprecated
    public void registerIndexTableOutParameter(int paramIndex, int maxLen, int elemSqlType, int elemMaxLen) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int index = paramIndex - 1;
            if (index < 0 || paramIndex > this.numberOfBindPositions) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            int elem_internal_type = this.getInternalType(elemSqlType);
            if (elem_internal_type == 96 || elem_internal_type == 1) {
                if (elemMaxLen < 0 || elemMaxLen > this.maxIbtVarcharElementLength) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53).fillInStackTrace();
                }
                if (elemMaxLen == 0) {
                    elemMaxLen = this.maxIbtVarcharElementLength;
                }
            }
            this.currentRowNeedToPrepareBinds = true;
            if (this.currentRowBindAccessors == null) {
                this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
            }
            this.currentRowBindAccessors[index] = this.allocateIndexTableAccessor(new PlsqlIbtBindInfo(this, null, maxLen, 0, elem_internal_type, elemMaxLen), this.currentRowFormOfUse[index]);
            this.hasIbtBind = true;
        }
    }

    Accessor allocateIndexTableAccessor(PlsqlIbtBindInfo ibtBindInfo, short form) throws SQLException {
        return new PlsqlIndexTableAccessor(this, ibtBindInfo, form);
    }

    @Override
    @Deprecated
    public Object getPlsqlIndexTable(int paramIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Datum[] darray = this.getOraclePlsqlIndexTable(paramIndex);
            Accessor accessor = this.outBindAccessors[paramIndex - 1];
            int type = accessor.plsqlIndexTableBindInfo().element_internal_type;
            Object[] jarray = null;
            switch (type) {
                case 9: {
                    jarray = new String[darray.length];
                    break;
                }
                case 6: {
                    jarray = new BigDecimal[darray.length];
                    break;
                }
                case 12: {
                    jarray = new Timestamp[darray.length];
                    break;
                }
                case 180: {
                    jarray = new TIMESTAMP[darray.length];
                    break;
                }
                default: {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid column type").fillInStackTrace();
                }
            }
            for (int i = 0; i < jarray.length; ++i) {
                jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].toJdbc() : null;
            }
            Object[] objectArray = jarray;
            return objectArray;
        }
    }

    @Override
    @Deprecated
    public Object getPlsqlIndexTable(int paramIndex, Class<?> primitiveType) throws SQLException {
        Throwable throwable = null;
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Datum[] darray = this.getOraclePlsqlIndexTable(paramIndex);
            if (primitiveType == null || !primitiveType.isPrimitive()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String type = primitiveType.getName();
            if (type.equals("byte")) {
                byte[] jarray = new byte[darray.length];
                for (int i = 0; i < darray.length; ++i) {
                    jarray[i] = darray[i] != null ? darray[i].byteValue() : (byte)0;
                }
                byte[] i = jarray;
                return i;
            }
            if (type.equals("char")) {
                char[] jarray = new char[darray.length];
                for (int i = 0; i < darray.length; ++i) {
                    jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? (char)darray[i].intValue() : (char)'\u0000';
                }
                char[] i = jarray;
                return i;
            }
            if (type.equals("double")) {
                double[] jarray = new double[darray.length];
                for (int i = 0; i < darray.length; ++i) {
                    jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].doubleValue() : 0.0;
                }
                double[] i = jarray;
                return i;
            }
            if (type.equals("float")) {
                float[] jarray = new float[darray.length];
                for (int i = 0; i < darray.length; ++i) {
                    jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].floatValue() : 0.0f;
                }
                float[] i = jarray;
                return i;
            }
            if (type.equals("int")) {
                int[] jarray = new int[darray.length];
                for (int i = 0; i < darray.length; ++i) {
                    jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].intValue() : 0;
                }
                int[] i = jarray;
                return i;
            }
            if (type.equals("long")) {
                long[] jarray = new long[darray.length];
                for (int i = 0; i < darray.length; ++i) {
                    jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].longValue() : 0L;
                }
                long[] i = jarray;
                return i;
            }
            if (type.equals("short")) {
                short[] jarray = new short[darray.length];
                for (int i = 0; i < darray.length; ++i) {
                    jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? (short)darray[i].intValue() : (short)0;
                }
                short[] i = jarray;
                return i;
            }
            if (type.equals("boolean")) {
                boolean[] jarray = new boolean[darray.length];
                for (int i = 0; i < darray.length; ++i) {
                    jarray[i] = darray[i] != null && darray[i].getLength() != 0L ? darray[i].booleanValue() : false;
                }
                boolean[] blArray = jarray;
                return blArray;
            }
            try {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Override
    @Deprecated
    public Datum[] getOraclePlsqlIndexTable(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Datum[] datumArray = accessor.getOraclePlsqlIndexTable(this.currentRank);
            return datumArray;
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            boolean bl = this.doExecute();
            return bl;
        }
    }

    @Override
    protected boolean doExecute() throws SQLException {
        this.connection.assertLockHeldByCurrentThread();
        this.ensureOpen();
        this.prepareNamedParameters();
        return super.doExecute();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            this.prepareNamedParameters();
            long l = super.doExecuteLargeUpdate();
            return l;
        }
    }

    private void prepareNamedParameters() throws SQLException {
        if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
        }
        if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) {
            this.needToParse = true;
        }
    }

    @Override
    public void setArray(int paramIndex, Array x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setArrayInternal(paramIndex, x);
        }
    }

    @Override
    public void setBigDecimal(int paramIndex, BigDecimal x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBigDecimalInternal(paramIndex, x);
        }
    }

    @Override
    public void setBlob(int paramIndex, Blob x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBlobInternal(paramIndex, x);
        }
    }

    @Override
    public void setBoolean(int paramIndex, boolean x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBooleanInternal(paramIndex, x);
        }
    }

    @Override
    public void setByte(int paramIndex, byte x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setByteInternal(paramIndex, x);
        }
    }

    @Override
    public void setBytes(int paramIndex, byte[] x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBytesInternal(paramIndex, x);
        }
    }

    @Override
    public void setClob(int paramIndex, Clob x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setFormOfUseInternal(paramIndex, this.defaultFormOfUse);
            this.setClobInternal(paramIndex, x);
        }
    }

    @Override
    public void setDate(int paramIndex, Date x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setDateInternal(paramIndex, x);
        }
    }

    @Override
    public void setDate(int paramIndex, Date x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setDateInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setDouble(int paramIndex, double x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setDoubleInternal(paramIndex, x);
        }
    }

    @Override
    public void setFloat(int paramIndex, float x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setFloatInternal(paramIndex, x);
        }
    }

    @Override
    public void setInt(int paramIndex, int x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setIntInternal(paramIndex, x);
        }
    }

    @Override
    public void setLong(int paramIndex, long x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setLongInternal(paramIndex, x);
        }
    }

    @Override
    public void setNClob(int paramIndex, NClob x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setNClobInternal(paramIndex, x);
        }
    }

    @Override
    public void setNString(int paramIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setNStringInternal(paramIndex, x);
        }
    }

    @Override
    public void setObject(int paramIndex, Object x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setObjectInternal(paramIndex, x);
        }
    }

    @Override
    public void setObject(int paramIndex, Object x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setObjectInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setRef(int paramIndex, Ref x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setRefInternal(paramIndex, x);
        }
    }

    @Override
    public void setRowId(int paramIndex, RowId x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setRowIdInternal(paramIndex, x);
        }
    }

    @Override
    public void setShort(int paramIndex, short x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setShortInternal(paramIndex, x);
        }
    }

    @Override
    public void setSQLXML(int paramIndex, SQLXML x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setSQLXMLInternal(paramIndex, x);
        }
    }

    @Override
    public void setString(int paramIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setStringInternal(paramIndex, x);
        }
    }

    @Override
    public void setTime(int paramIndex, Time x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setTimeInternal(paramIndex, x);
        }
    }

    @Override
    public void setTime(int paramIndex, Time x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setTimeInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setTimestamp(int paramIndex, Timestamp x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setTimestampInternal(paramIndex, x);
        }
    }

    @Override
    public void setTimestamp(int paramIndex, Timestamp x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setTimestampInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setURL(int paramIndex, URL x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setURLInternal(paramIndex, x);
        }
    }

    @Override
    public void setARRAY(int paramIndex, ARRAY x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setARRAYInternal(paramIndex, x);
        }
    }

    @Override
    public void setBFILE(int paramIndex, BFILE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBFILEInternal(paramIndex, x);
        }
    }

    @Override
    public void setBfile(int paramIndex, BFILE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBfileInternal(paramIndex, x);
        }
    }

    @Override
    public void setBinaryFloat(int paramIndex, float x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryFloatInternal(paramIndex, x);
        }
    }

    @Override
    public void setBinaryFloat(int paramIndex, BINARY_FLOAT x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryFloatInternal(paramIndex, x);
        }
    }

    @Override
    public void setBinaryDouble(int paramIndex, double x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryDoubleInternal(paramIndex, x);
        }
    }

    @Override
    public void setBinaryDouble(int paramIndex, BINARY_DOUBLE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryDoubleInternal(paramIndex, x);
        }
    }

    @Override
    public void setBLOB(int paramIndex, BLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBLOBInternal(paramIndex, x);
        }
    }

    @Override
    public void setCHAR(int paramIndex, CHAR x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setCHARInternal(paramIndex, x);
        }
    }

    @Override
    public void setCLOB(int paramIndex, CLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setCLOBInternal(paramIndex, x);
        }
    }

    @Override
    public void setCursor(int paramIndex, ResultSet x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setCursorInternal(paramIndex, x);
        }
    }

    @Override
    public void setDATE(int paramIndex, DATE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setDATEInternal(paramIndex, x);
        }
    }

    @Override
    public void setFixedCHAR(int paramIndex, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setFixedCHARInternal(paramIndex, x);
        }
    }

    @Override
    public void setINTERVALDS(int paramIndex, INTERVALDS x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setINTERVALDSInternal(paramIndex, x);
        }
    }

    @Override
    public void setINTERVALYM(int paramIndex, INTERVALYM x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setINTERVALYMInternal(paramIndex, x);
        }
    }

    @Override
    public void setNUMBER(int paramIndex, NUMBER x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setNUMBERInternal(paramIndex, x);
        }
    }

    @Override
    public void setOPAQUE(int paramIndex, OPAQUE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setOPAQUEInternal(paramIndex, x);
        }
    }

    @Override
    public void setOracleObject(int paramIndex, Datum x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setOracleObjectInternal(paramIndex, x);
        }
    }

    @Override
    public void setORAData(int paramIndex, ORAData x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setORADataInternal(paramIndex, x);
        }
    }

    @Override
    public void setRAW(int paramIndex, RAW x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setRAWInternal(paramIndex, x);
        }
    }

    @Override
    public void setREF(int paramIndex, REF x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setREFInternal(paramIndex, x);
        }
    }

    @Override
    public void setRefType(int paramIndex, REF x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setRefTypeInternal(paramIndex, x);
        }
    }

    @Override
    public void setROWID(int paramIndex, ROWID x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setROWIDInternal(paramIndex, x);
        }
    }

    @Override
    public void setSTRUCT(int paramIndex, STRUCT x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setSTRUCTInternal(paramIndex, x);
        }
    }

    @Override
    public void setTIMESTAMPLTZ(int paramIndex, TIMESTAMPLTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setTIMESTAMPLTZInternal(paramIndex, x);
        }
    }

    @Override
    public void setTIMESTAMPTZ(int paramIndex, TIMESTAMPTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setTIMESTAMPTZInternal(paramIndex, x);
        }
    }

    @Override
    public void setTIMESTAMP(int paramIndex, TIMESTAMP x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setTIMESTAMPInternal(paramIndex, x);
        }
    }

    @Override
    public void setCustomDatum(int paramIndex, CustomDatum x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setCustomDatumInternal(paramIndex, x);
        }
    }

    @Override
    public void setBlob(int paramIndex, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBlobInternal(paramIndex, x);
        }
    }

    @Override
    public void setBlob(int paramIndex, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (y < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setBlob() cannot be negative").fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBlobInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setClob(int paramIndex, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setFormOfUseInternal(paramIndex, this.defaultFormOfUse);
            this.setClobInternal(paramIndex, x);
        }
    }

    @Override
    public void setClob(int paramIndex, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (y < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative").fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setFormOfUseInternal(paramIndex, this.defaultFormOfUse);
            this.setClobInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setNClob(int paramIndex, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setNClobInternal(paramIndex, x);
        }
    }

    @Override
    public void setNClob(int paramIndex, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setNClobInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setAsciiStream(int paramIndex, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setAsciiStreamInternal(paramIndex, x);
        }
    }

    @Override
    public void setAsciiStream(int paramIndex, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setAsciiStreamInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setAsciiStream(int paramIndex, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setAsciiStreamInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setBinaryStream(int paramIndex, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryStreamInternal(paramIndex, x);
        }
    }

    @Override
    public void setBinaryStream(int paramIndex, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryStreamInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setBinaryStream(int paramIndex, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setBinaryStreamInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setCharacterStream(int paramIndex, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setCharacterStreamInternal(paramIndex, x);
        }
    }

    @Override
    public void setCharacterStream(int paramIndex, Reader x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setCharacterStreamInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setCharacterStream(int paramIndex, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setCharacterStreamInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setNCharacterStream(int paramIndex, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setNCharacterStreamInternal(paramIndex, x);
        }
    }

    @Override
    public void setNCharacterStream(int paramIndex, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setNCharacterStreamInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setUnicodeStream(int paramIndex, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setUnicodeStreamInternal(paramIndex, x, y);
        }
    }

    @Override
    public void setArray(String parameterName, Array x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setArrayInternal(index, x);
        }
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBigDecimalInternal(index, x);
        }
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBlobInternal(index, x);
        }
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBooleanInternal(index, x);
        }
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setByteInternal(index, x);
        }
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBytesInternal(index, x);
        }
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setClobInternal(index, x);
        }
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setDateInternal(index, x);
        }
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setDateInternal(index, x, y);
        }
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setDoubleInternal(index, x);
        }
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setFloatInternal(index, x);
        }
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setIntInternal(index, x);
        }
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setLongInternal(index, x);
        }
    }

    @Override
    public void setNClob(String parameterName, NClob x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setNClobInternal(index, x);
        }
    }

    @Override
    public void setNString(String parameterName, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setNStringInternal(index, x);
        }
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setObjectInternal(index, x);
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setObjectInternal(index, x, y);
        }
    }

    @Override
    public void setRef(String parameterName, Ref x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setRefInternal(index, x);
        }
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setRowIdInternal(index, x);
        }
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setShortInternal(index, x);
        }
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setSQLXMLInternal(index, x);
        }
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setStringInternal(index, x);
        }
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setTimeInternal(index, x);
        }
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setTimeInternal(index, x, y);
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setTimestampInternal(index, x);
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setTimestampInternal(index, x, y);
        }
    }

    @Override
    public void setURL(String parameterName, URL x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setURLInternal(index, x);
        }
    }

    @Override
    public void setARRAY(String parameterName, ARRAY x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setARRAYInternal(index, x);
        }
    }

    @Override
    public void setBFILE(String parameterName, BFILE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBFILEInternal(index, x);
        }
    }

    @Override
    public void setBfile(String parameterName, BFILE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBfileInternal(index, x);
        }
    }

    @Override
    public void setBinaryFloat(String parameterName, float x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryFloatInternal(index, x);
        }
    }

    @Override
    public void setBinaryFloat(String parameterName, BINARY_FLOAT x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryFloatInternal(index, x);
        }
    }

    @Override
    public void setBinaryDouble(String parameterName, double x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryDoubleInternal(index, x);
        }
    }

    @Override
    public void setBinaryDouble(String parameterName, BINARY_DOUBLE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryDoubleInternal(index, x);
        }
    }

    @Override
    public void setBLOB(String parameterName, BLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBLOBInternal(index, x);
        }
    }

    @Override
    public void setCHAR(String parameterName, CHAR x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setCHARInternal(index, x);
        }
    }

    @Override
    public void setCLOB(String parameterName, CLOB x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setCLOBInternal(index, x);
        }
    }

    @Override
    public void setCursor(String parameterName, ResultSet x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setCursorInternal(index, x);
        }
    }

    @Override
    public void setDATE(String parameterName, DATE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setDATEInternal(index, x);
        }
    }

    @Override
    public void setFixedCHAR(String parameterName, String x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setFixedCHARInternal(index, x);
        }
    }

    @Override
    public void setINTERVALDS(String parameterName, INTERVALDS x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setINTERVALDSInternal(index, x);
        }
    }

    @Override
    public void setINTERVALYM(String parameterName, INTERVALYM x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setINTERVALYMInternal(index, x);
        }
    }

    @Override
    public void setNUMBER(String parameterName, NUMBER x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setNUMBERInternal(index, x);
        }
    }

    @Override
    public void setOPAQUE(String parameterName, OPAQUE x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setOPAQUEInternal(index, x);
        }
    }

    @Override
    public void setOracleObject(String parameterName, Datum x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setOracleObjectInternal(index, x);
        }
    }

    @Override
    public void setORAData(String parameterName, ORAData x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setORADataInternal(index, x);
        }
    }

    @Override
    public void setRAW(String parameterName, RAW x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setRAWInternal(index, x);
        }
    }

    @Override
    public void setREF(String parameterName, REF x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setREFInternal(index, x);
        }
    }

    @Override
    public void setRefType(String parameterName, REF x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setRefTypeInternal(index, x);
        }
    }

    @Override
    public void setROWID(String parameterName, ROWID x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setROWIDInternal(index, x);
        }
    }

    @Override
    public void setSTRUCT(String parameterName, STRUCT x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setSTRUCTInternal(index, x);
        }
    }

    @Override
    public void setTIMESTAMPLTZ(String parameterName, TIMESTAMPLTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setTIMESTAMPLTZInternal(index, x);
        }
    }

    @Override
    public void setTIMESTAMPTZ(String parameterName, TIMESTAMPTZ x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setTIMESTAMPTZInternal(index, x);
        }
    }

    @Override
    public void setTIMESTAMP(String parameterName, TIMESTAMP x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setTIMESTAMPInternal(index, x);
        }
    }

    @Override
    public void setCustomDatum(String parameterName, CustomDatum x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setCustomDatumInternal(index, x);
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBlobInternal(index, x);
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (y < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setBlob() cannot be negative").fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBlobInternal(index, x, y);
        }
    }

    @Override
    public void setClob(String parameterName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setClobInternal(index, x);
        }
    }

    @Override
    public void setClob(String parameterName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (y < 0L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative").fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setClobInternal(index, x, y);
        }
    }

    @Override
    public void setNClob(String parameterName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setNClobInternal(index, x);
        }
    }

    @Override
    public void setNClob(String parameterName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setNClobInternal(index, x, y);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setAsciiStreamInternal(index, x);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setAsciiStreamInternal(index, x, y);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setAsciiStreamInternal(index, x, y);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryStreamInternal(index, x);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryStreamInternal(index, x, y);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setBinaryStreamInternal(index, x, y);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setCharacterStreamInternal(index, x);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setCharacterStreamInternal(index, x, y);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setCharacterStreamInternal(index, x, y);
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setNCharacterStreamInternal(index, x);
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader x, long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setNCharacterStreamInternal(index, x, y);
        }
    }

    @Override
    public void setUnicodeStream(String parameterName, InputStream x, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setUnicodeStreamInternal(index, x, y);
        }
    }

    @Override
    public void setNull(String parameterName, int x, String y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setNullInternal(index, x, y);
        }
    }

    @Override
    public void setNull(String parameterName, int x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setNullInternal(index, x);
        }
    }

    @Override
    public void setStructDescriptor(String parameterName, StructDescriptor x) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(parameterName);
            this.setStructDescriptorInternal(index, x);
        }
    }

    @Override
    public void setObject(String name, Object value, int type, int scale) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            int index = this.addNamedPara(name);
            this.setObjectInternal(index, value, type, scale);
        }
    }

    @Override
    @Deprecated
    public void setPlsqlIndexTable(int paramIndex, Object arrayData, int maxLen, int curLen, int elemSqlType, int elemMaxLen) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            this.atLeastOneOrdinalParameter = true;
            this.setPlsqlIndexTableInternal(paramIndex, arrayData, maxLen, curLen, elemSqlType, elemMaxLen);
        }
    }

    int addNamedPara(String parameterName) throws SQLException {
        if (this.closed) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
        }
        if (parameterName == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        String iParameterName = parameterName.toUpperCase().intern();
        for (int i = 0; i < this.parameterCount; ++i) {
            if (iParameterName != this.namedParameters[i]) continue;
            return i + 1;
        }
        if (this.parameterCount >= this.namedParameters.length) {
            String[] newList = new String[this.namedParameters.length * 2];
            System.arraycopy(this.namedParameters, 0, newList, 0, this.namedParameters.length);
            this.namedParameters = newList;
        }
        this.namedParameters[this.parameterCount++] = iParameterName;
        this.atLeastOneNamedParameter = true;
        return this.parameterCount;
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Reader reader = accessor.getCharacterStream(this.currentRank);
            return reader;
        }
    }

    @Override
    public InputStream getUnicodeStream(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            InputStream inputStream = accessor.getUnicodeStream(this.currentRank);
            return inputStream;
        }
    }

    @Override
    public InputStream getBinaryStream(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            InputStream inputStream = accessor.getBinaryStream(this.currentRank);
            return inputStream;
        }
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ROWID rOWID = accessor.getROWID(this.currentRank);
            return rOWID;
        }
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            ROWID rOWID = accessor.getROWID(this.currentRank);
            return rOWID;
        }
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            NClob nClob = accessor.getNClob(this.currentRank);
            return nClob;
        }
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            NClob nClob = accessor.getNClob(this.currentRank);
            return nClob;
        }
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            SQLXML sQLXML = accessor.getSQLXML(this.currentRank);
            return sQLXML;
        }
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            SQLXML sQLXML = accessor.getSQLXML(this.currentRank);
            return sQLXML;
        }
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            String string = accessor.getNString(this.currentRank);
            return string;
        }
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            String string = accessor.getNString(this.currentRank);
            return string;
        }
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Reader reader = accessor.getNCharacterStream(this.currentRank);
            return reader;
        }
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            Reader reader = accessor.getNCharacterStream(this.currentRank);
            return reader;
        }
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.closed) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9).fillInStackTrace();
            }
            if (this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            Accessor accessor = null;
            if (parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            T t = accessor.getObject(this.currentRank, type);
            return t;
        }
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int parameterIndex;
            if (!this.atLeastOneNamedParameter) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, errMsgMixedBind).fillInStackTrace();
            }
            if (parameterName == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
            }
            String iName = parameterName.toUpperCase().intern();
            for (parameterIndex = 0; parameterIndex < this.parameterCount && iName != this.namedParameters[parameterIndex]; ++parameterIndex) {
            }
            Accessor accessor = null;
            if (++parameterIndex <= 0 || parameterIndex > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[parameterIndex - 1]) == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6).fillInStackTrace();
            }
            this.lastIndex = parameterIndex;
            if (this.streamList != null) {
                this.closeUsedStreams(parameterIndex);
            }
            T t = accessor.getObject(this.currentRank, type);
            return t;
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType) throws SQLException {
        if (sqlType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, int scale) throws SQLException {
        if (sqlType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(int parameterIndex, SQLType sqlType, String typeName) throws SQLException {
        if (sqlType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        this.registerOutParameter(parameterIndex, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType) throws SQLException {
        if (sqlType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber());
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, int scale) throws SQLException {
        if (sqlType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), scale);
    }

    @Override
    public void registerOutParameter(String parameterName, SQLType sqlType, String typeName) throws SQLException {
        if (sqlType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        this.registerOutParameter(parameterName, (int)sqlType.getVendorTypeNumber(), typeName);
    }

    @Override
    public void setObject(String parameterName, Object value, SQLType targetSqlType) throws SQLException {
        if (targetSqlType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        this.setObject(parameterName, value, (int)targetSqlType.getVendorTypeNumber());
    }

    @Override
    public void setObject(String parameterName, Object value, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        if (targetSqlType == null) {
            throw new IllegalArgumentException("null SQLType");
        }
        this.setObject(parameterName, value, (int)targetSqlType.getVendorTypeNumber(), scaleOrLength);
    }

    boolean isLastCursor() throws SQLException {
        if (this.remainingCursors == -1) {
            this.remainingCursors = 0;
            if (this.outBindAccessors != null) {
                for (int i = 0; i < this.outBindAccessors.length; ++i) {
                    if (this.outBindAccessors[i] == null || this.outBindAccessors[i].internalType != 102 || this.outBindAccessors[i].isNull(this.currentRank)) continue;
                    ++this.remainingCursors;
                }
            }
        }
        return --this.remainingCursors == 0;
    }

    @Override
    boolean closeByDependent() throws SQLException {
        if (this.isCloseOnCompletion && this.isLastCursor()) {
            if (this.parent == null || !this.parent.closeByDependent()) {
                this.close();
            }
            return true;
        }
        return false;
    }
}

