/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.util.logging.Level;
import oracle.jdbc.diagnostics.AbstractDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.Diagnostic;
import oracle.jdbc.diagnostics.OracleDiagnosticsMXBean;
import oracle.jdbc.diagnostics.PropertyChangeEvent;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.diagnostics.TraceAttributes;
import oracle.jdbc.driver.GeneratedPhysicalConnection;

public final class CommonDiagnosable
extends AbstractDiagnosable {
    private static final String CLASS_NAME = CommonDiagnosable.class.getName();
    private static final CommonDiagnosable COMMON_DIAGNOSABLE_INSTANCE = new CommonDiagnosable();
    private final String diagnosticLoggerName = CommonDiagnosable.getSystemProperty("oracle.jdbc.diagnostic.loggerName", "oracle.jdbc", IS_VALID_LOGGER_NAME);
    private final int diagnosticBufferSize = Integer.parseInt(CommonDiagnosable.getSystemProperty("oracle.jdbc.diagnostic.bufferSize", "1000", IS_VALID_BUFFER_SIZE));
    private volatile boolean isDiagnoseFirstFailureEnabled = Boolean.parseBoolean(CommonDiagnosable.getSystemProperty("oracle.jdbc.diagnostic.enableDiagnoseFirstFailure", "true", IS_VALID_BOOLEAN_STRING));
    private volatile boolean isDebugEnabled = Boolean.parseBoolean(CommonDiagnosable.getSystemProperty("oracle.jdbc.diagnostic.enableLogging", "false", IS_VALID_BOOLEAN_STRING));
    private final boolean isSensitivePermitted = Boolean.parseBoolean(CommonDiagnosable.getSystemProperty("oracle.jdbc.diagnostic.permitSensitiveDiagnostics", "false", IS_VALID_BOOLEAN_STRING));
    private final boolean isSensitiveEnabled = Boolean.parseBoolean(CommonDiagnosable.getSystemProperty("oracle.jdbc.diagnostic.enableSensitiveDiagnostics", "false", IS_VALID_BOOLEAN_STRING));

    private CommonDiagnosable() {
        this.init();
    }

    public static Diagnosable getInstance() {
        return COMMON_DIAGNOSABLE_INSTANCE;
    }

    private void init() {
        this.diagnostic = Diagnostic.get(this.diagnosticLoggerName, this.diagnosticBufferSize);
        this.setDebugEnabled(this.isDebugEnabled || CommonDiagnosable.isGlobalDebugEnabled());
        this.setDiagnoseFirstFailureEnabled(this.isDiagnoseFirstFailureEnabled);
        this.setSensitiveEnabled(this.isSensitiveEnabled);
        OracleDiagnosticsMXBean.addPropertyChangeListener(this);
        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "init", "Properties : {0}", (String)null, null, (Object)GeneratedPhysicalConnection.CONNECTION_PROPERTIES_BLINDER.blind(Diagnostic.SYSTEM_CONFIG));
    }

    @Override
    public final void setDebugEnabled(boolean enabled) {
        this.isDebugEnabled = enabled;
    }

    @Override
    public final void setDiagnoseFirstFailureEnabled(boolean enabled) {
        this.isDiagnoseFirstFailureEnabled = enabled;
    }

    @Override
    protected boolean isSensitivePermitted() {
        return this.isSensitivePermitted;
    }

    @Override
    public String getDiagnosticLoggerName() {
        return this.diagnosticLoggerName;
    }

    @Override
    protected TraceAttributes getTraceAttributes() {
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        switch (event.getPropertyName()) {
            case "Event-Dump-DiagnoseFirstFailure": {
                if (!this.isDiagnoseFirstFailureEnabled) break;
                this.diagnostic.dumpDiagnoseFirstFailure(true);
                break;
            }
            default: {
                this.abstractPropertyChange(event);
            }
        }
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public final boolean isDiagnoseFirstFailureEnabled() {
        return this.isDiagnoseFirstFailureEnabled;
    }
}

