/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.net.ssl.SSLException;
import oracle.jdbc.driver.utils.WalletLocation;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jndi.LDAPSSLSocketFactory;
import oracle.net.ns.NetException;
import oracle.security.pki.OracleSSOKeyStoreSpi;

public class JndiAttrs {
    private static final String WALLET_ENTRY_DN = "oracle.ldap.client.dn";
    private static final String WALLET_ENTRY_PASSWORD = "oracle.ldap.client.password";
    private static final String LDAP_AUTH_TYPE_NONE = "none";
    private static final String LDAP_AUTH_TYPE_SIMPLE = "simple";
    private Properties env;
    private static final String nFactory = "java.naming.factory.initial";
    private static final String nProvider = "java.naming.provider.url";
    private static final String nProfile = "ora-net-profile";
    private static final String default_nFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String ldap_read_timeout = "com.sun.jndi.ldap.read.timeout";
    private static final String ldap_connect_timeout = "com.sun.jndi.ldap.connect.timeout";
    DirContext ctx;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JndiAttrs(@Blind(value=PropertiesBlinder.class) Properties up) throws NetException {
        Object providerURL = null;
        this.env = new Properties();
        if (up.containsKey(nFactory)) {
            this.env.put(nFactory, up.getProperty(nFactory));
        } else {
            this.env.put(nFactory, default_nFactory);
        }
        if (up.containsKey(nProvider)) {
            providerURL = up.getProperty(nProvider);
            if (((String)providerURL).startsWith("ldaps")) {
                this.env.put("java.naming.ldap.factory.socket", "oracle.net.jndi.LDAPSSLSocketFactory");
                this.env.put("java.naming.security.protocol", "ssl");
                providerURL = "ldap:" + ((String)providerURL).substring(6);
            }
            this.env.put(nProvider, providerURL);
        }
        if (up.containsKey("oracle.net.profile")) {
            this.env.put(nProfile, up.getProperty("oracle.net.profile"));
        }
        try {
            Class<?> jclass = Class.forName("javax.naming.directory.InitialDirContext");
            if (this.env.get(nFactory) == null) {
                this.env.put(nFactory, default_nFactory);
            }
            if (this.env.get(nProvider) == null) {
                this.env.put(nProvider, providerURL);
            }
        }
        catch (Exception classE) {
            throw new NetException(17860, classE.toString());
        }
        if (up.containsKey(ldap_connect_timeout)) {
            this.env.put(ldap_connect_timeout, up.getProperty(ldap_connect_timeout));
        }
        if (up.containsKey(ldap_read_timeout)) {
            this.env.put(ldap_read_timeout, up.getProperty(ldap_read_timeout));
        }
        this.addAuthenticationDetails(up);
        LDAPSSLSocketFactory.connectionProperties.set(up);
        try {
            this.initializeLDAPContext(this.env);
        }
        finally {
            LDAPSSLSocketFactory.connectionProperties.remove();
        }
    }

    private void addAuthenticationDetails(Properties connectionProps) throws NetException {
        OpaqueString credentials;
        String principal;
        String ldapAuthType = connectionProps.getProperty("oracle.net.ldap.security.authentication");
        if (ldapAuthType == null || ldapAuthType.equalsIgnoreCase(LDAP_AUTH_TYPE_NONE)) {
            return;
        }
        if (ldapAuthType.equalsIgnoreCase(LDAP_AUTH_TYPE_SIMPLE)) {
            Object[] creds;
            this.env.put("java.naming.security.authentication", LDAP_AUTH_TYPE_SIMPLE);
            principal = connectionProps.getProperty("oracle.net.ldap.security.principal");
            credentials = (OpaqueString)connectionProps.get("oracle.net.ldap.security.credentials");
            if ((principal == null || credentials == null) && (creds = JndiAttrs.getAuthDetailsFromWallet((WalletLocation)connectionProps.get("oracle.net.ldap.ssl.walletLocation"), (OpaqueString)connectionProps.get("oracle.net.ldap.ssl.walletPassword"))) != null) {
                principal = (String)creds[0];
                credentials = (OpaqueString)creds[1];
            }
            if (principal == null || credentials == null) {
                throw new NetException(17876);
            }
        } else {
            throw new NetException(17875, null, false, "oracle.net.ldap.security.authentication", ldapAuthType);
        }
        this.env.put("java.naming.security.principal", principal);
        this.env.put("java.naming.security.credentials", credentials.get());
    }

    public static Object[] getAuthDetailsFromWallet(WalletLocation walletLocationObject, OpaqueString walletPassword) throws NetException {
        Object[] objectArray;
        block13: {
            if (walletLocationObject == null) {
                return null;
            }
            char[] walletPwd = null;
            try {
                Object walletLocation = WalletLocation.switchExpression(walletLocationObject, systemLocation -> null, WalletLocation.PathLocation::pathString, WalletLocation.FileURILocation::uriString, sqlNetLocation -> null, dataUriLocation -> null);
                if (walletLocation == null) {
                    Object[] objectArray2 = null;
                    return objectArray2;
                }
                File walletFile = new File((String)walletLocation);
                if (walletFile.exists() && walletFile.isDirectory()) {
                    walletLocation = (String)walletLocation + File.separator + "cwallet.sso";
                }
                if (walletPassword != null) {
                    walletPwd = walletPassword.getChars();
                }
                OracleSSOKeyStoreSpi secretKeyStore = new OracleSSOKeyStoreSpi();
                secretKeyStore.engineLoad((InputStream)new FileInputStream((String)walletLocation), walletPwd);
                Object[] credentials = new Object[2];
                if (secretKeyStore.secretStoreContainsAlias(WALLET_ENTRY_DN)) {
                    credentials[0] = new String(secretKeyStore.secretStoreGetSecret(WALLET_ENTRY_DN));
                }
                if (secretKeyStore.secretStoreContainsAlias(WALLET_ENTRY_PASSWORD)) {
                    credentials[1] = OpaqueString.newOpaqueString(secretKeyStore.secretStoreGetSecret(WALLET_ENTRY_PASSWORD));
                }
                objectArray = credentials;
                if (walletPwd == null) break block13;
            }
            catch (Exception e) {
                throw (NetException)new NetException(17858, e.getMessage()).initCause(e);
            }
            finally {
                if (walletPwd != null) {
                    Arrays.fill(walletPwd, '\u0000');
                }
            }
            Arrays.fill(walletPwd, '\u0000');
        }
        return objectArray;
    }

    private void initializeLDAPContext(@Blind(value=PropertiesBlinder.class) Properties env) throws NetException {
        for (int i = 0; i < 3; ++i) {
            try {
                this.ctx = new InitialDirContext(env);
                break;
            }
            catch (NamingException ne) {
                if (ne.getRootCause() instanceof SSLException && i < 3) continue;
                if (ne.getRootCause() instanceof NetException) {
                    throw (NetException)ne.getRootCause();
                }
                NetException netEx = new NetException(17858, ne.toString());
                throw (NetException)netEx.initCause(ne);
            }
        }
    }

    public Vector getProfileAttrs(String cn) throws NetException {
        String _cn = "cn=";
        Attributes attrs = null;
        try {
            _cn = _cn.concat(cn);
            attrs = this.ctx.getAttributes(_cn);
        }
        catch (NamingException namingE) {
            throw new NetException(17858, namingE.toString());
        }
        return this.setAttrs(attrs);
    }

    public Vector getAttrs(String alias, String[] attrname) throws NetException {
        if (alias == null) {
            throw new NetException(17858, "alias is null");
        }
        if (attrname == null) {
            throw new NetException(17858, "attrname is null");
        }
        if (this.ctx == null) {
            throw new NetException(17858, "ctx is null");
        }
        String _cn = "cn=";
        Attributes attrs = null;
        try {
            _cn = !alias.startsWith(_cn) ? _cn.concat(alias) : alias;
            attrs = this.ctx.getAttributes(_cn, attrname);
        }
        catch (NamingException namingE) {
            throw new NetException(17858, namingE.toString());
        }
        if (attrs.size() == 0) {
            throw new NetException(12154, ", LDAP", false, alias, attrname);
        }
        return this.setAttrs(attrs);
    }

    private Vector setAttrs(Attributes attrs) throws NetException {
        Vector nattr = new Vector(1, 1);
        if (attrs != null) {
            try {
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                while (ae != null && ae.hasMoreElements()) {
                    Attribute attr = ae.next();
                    NamingEnumeration<?> e = attr.getAll();
                    while (e.hasMoreElements()) {
                        nattr.addElement(e.nextElement());
                    }
                }
            }
            catch (NamingException namingE) {
                throw new NetException(17858, namingE.toString());
            }
        }
        return nattr;
    }

    public void setEnv(String envP, String envV) {
        this.env.put(envP, envV);
    }

    public void close() throws NetException {
        try {
            if (null != this.ctx) {
                this.ctx.close();
            }
        }
        catch (NamingException namingE) {
            throw new NetException(17858, namingE.toString());
        }
    }

    public final String getLdapUrlUsed() throws NetException {
        String url = null;
        try {
            url = (String)this.ctx.getEnvironment().get(nProvider);
        }
        catch (NamingException namingE) {
            throw new NetException(17858, namingE.toString());
        }
        return url;
    }
}

