/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.cli.urlbuilder;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;

class UrlValidator {
    UrlValidator() {
    }

    static Optional<String> validateUserInput(String property, String value, DriverPropertyInfo[] extractedProperties) {
        switch (property) {
            case "ssl_server_dn_match": 
            case "ssl_server_cert_dn": {
                if (value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("no")) break;
                return Optional.of("Expected 'yes' or 'no'.");
            }
            case "https_proxy": 
            case "service_tag": {
                if (!value.isEmpty()) break;
                return Optional.of("Value must not be empty.");
            }
            case "https_proxy_port": 
            case "recv_buf_size": 
            case "send_buf_size": 
            case "sdu": {
                if (UrlValidator.isInteger(value)) break;
                return Optional.of("Expected an integer.");
            }
            case "enable": {
                if (value.equalsIgnoreCase("broken")) break;
                return Optional.of("Expected 'broken'.");
            }
            case "failover": 
            case "load_balance": 
            case "source_route": {
                if (value.equalsIgnoreCase("on") || value.equalsIgnoreCase("off")) break;
                return Optional.of("Expected 'on' or 'off'.");
            }
            case "retry_count": 
            case "retry_delay": {
                if (UrlValidator.isInteger(value) && Integer.parseInt(value) >= 0) break;
                return Optional.of("Expected a non-negative integer.");
            }
            case "pool_connection_class": 
            case "pool_purity": {
                if (value.equalsIgnoreCase("NEW") || value.equalsIgnoreCase("SELF")) break;
                return Optional.of("Expected 'NEW' or 'SELF'.");
            }
            default: {
                for (DriverPropertyInfo propInfo : extractedProperties) {
                    String defaultValue;
                    if (propInfo.name == null || !propInfo.name.equals(property) || (defaultValue = propInfo.value) == null || UrlValidator.validateOracleConnectionInput(defaultValue, value)) continue;
                    return Optional.of("Expected " + UrlValidator.getExpectedOracleFieldValue(defaultValue) + " but got '" + value + "'.");
                }
            }
        }
        return Optional.empty();
    }

    static String isOracleDB(String connectionString) {
        OracleDataSource ods = null;
        try {
            ods = new OracleDataSource();
            ods.setURL(connectionString);
            Properties connectionProperties = new Properties();
            connectionProperties.put("oracle.net.CONNECT_TIMEOUT", "3000");
            connectionProperties.put("user", "invalid_user");
            connectionProperties.put("password", "invalid_password");
            ods.setConnectionProperties(connectionProperties);
            OracleConnection conn = (OracleConnection)ods.getConnection();
            conn.close();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 1017) {
                return "";
            }
            return e.getMessage();
        }
        return "";
    }

    private static boolean validateOracleConnectionInput(String fieldValue, String userInput) {
        if (fieldValue == null) {
            return true;
        }
        if (UrlValidator.isBooleanString(fieldValue)) {
            return userInput.equalsIgnoreCase("true") || userInput.equalsIgnoreCase("false");
        }
        if (UrlValidator.isInteger(fieldValue)) {
            return UrlValidator.isInteger(userInput);
        }
        return !userInput.isEmpty();
    }

    private static String getExpectedOracleFieldValue(String fieldValue) {
        if (UrlValidator.isBooleanString(fieldValue)) {
            return "'true' or 'false'";
        }
        if (UrlValidator.isInteger(fieldValue)) {
            return "an integer";
        }
        return "a non-empty string";
    }

    private static boolean isBooleanString(String str) {
        return str.equalsIgnoreCase("true") || str.equalsIgnoreCase("false");
    }

    private static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

