/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.json;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import oracle.jdbc.driver.json.BufferPoolImpl;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.OsonBuffer;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonGeneratorImpl;
import oracle.jdbc.driver.json.binary.OsonParserImpl;
import oracle.jdbc.driver.json.binary.OsonStructureImpl;
import oracle.jdbc.driver.json.parser.JsonParserImpl;
import oracle.jdbc.driver.json.tree.OracleJsonArrayImpl;
import oracle.jdbc.driver.json.tree.OracleJsonBinaryImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDateImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDecimalImpl;
import oracle.jdbc.driver.json.tree.OracleJsonDoubleImpl;
import oracle.jdbc.driver.json.tree.OracleJsonFloatImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalDSImpl;
import oracle.jdbc.driver.json.tree.OracleJsonIntervalYMImpl;
import oracle.jdbc.driver.json.tree.OracleJsonObjectImpl;
import oracle.jdbc.driver.json.tree.OracleJsonStringImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampImpl;
import oracle.jdbc.driver.json.tree.OracleJsonTimestampTZImpl;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.CHAR;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public final class OracleJsonFactory {
    private static final boolean DISABLE_GENERATOR_POOL = Boolean.getBoolean("oracle.sql.json.OracleJsonFactory.DISABLE_GENERATOR_POOL");
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final OsonGeneratorImpl.OsonGeneratorStatePool generatorPool = DISABLE_GENERATOR_POOL ? null : new OsonGeneratorImpl.OsonGeneratorStatePool();
    private final BufferPoolImpl bufferPool = new BufferPoolImpl();

    public OracleJsonParser createJsonBinaryParser(InputStream inputStream) throws OracleJsonException {
        byte[] byArray = OracleJsonFactory.readInputStream(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        OsonContext osonContext = new OsonContext(new OsonBuffer(byteBuffer));
        OsonParserImpl osonParserImpl = new OsonParserImpl(osonContext);
        osonParserImpl.setCloseable(inputStream);
        return osonParserImpl;
    }

    public OracleJsonParser createJsonTextParser(InputStream inputStream) throws OracleJsonException {
        return new JsonParserImpl(inputStream, this.bufferPool);
    }

    public OracleJsonParser createJsonTextParser(Reader reader) throws OracleJsonException {
        return new JsonParserImpl(reader, this.bufferPool);
    }

    public OracleJsonParser createJsonBinaryParser(ByteBuffer byteBuffer) throws OracleJsonException {
        OsonContext osonContext = new OsonContext(new OsonBuffer(byteBuffer));
        return new OsonParserImpl(osonContext);
    }

    public OracleJsonValue createJsonBinaryValue(InputStream inputStream) throws OracleJsonException {
        byte[] byArray = OracleJsonFactory.readInputStream(inputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        return this.createJsonBinaryValue(byteBuffer);
    }

    public OracleJsonValue createJsonTextValue(InputStream inputStream) throws OracleJsonException {
        try (OracleJsonParser oracleJsonParser = this.createJsonTextParser(inputStream);){
            oracleJsonParser.next();
            OracleJsonValue oracleJsonValue = oracleJsonParser.getValue();
            return oracleJsonValue;
        }
    }

    public OracleJsonValue createJsonTextValue(Reader reader) throws OracleJsonException {
        try (OracleJsonParser oracleJsonParser = this.createJsonTextParser(reader);){
            oracleJsonParser.next();
            OracleJsonValue oracleJsonValue = oracleJsonParser.getValue();
            return oracleJsonValue;
        }
    }

    public OracleJsonValue createJsonBinaryValue(ByteBuffer byteBuffer) throws OracleJsonException {
        OsonContext osonContext = new OsonContext(new OsonBuffer(byteBuffer));
        int n2 = osonContext.getHeader().getTreeSegmentOffset();
        return (OracleJsonValue)OsonStructureImpl.getValueInternal(n2, osonContext.getFactory(), osonContext);
    }

    public final OracleJsonGenerator createJsonBinaryGenerator(OutputStream outputStream) {
        return new OsonGeneratorImpl(this.generatorPool, outputStream);
    }

    public OracleJsonGenerator createJsonTextGenerator(OutputStream outputStream) {
        return new JsonSerializerImpl(outputStream);
    }

    public OracleJsonGenerator createJsonTextGenerator(Writer writer) {
        return new JsonSerializerImpl(writer);
    }

    public OracleJsonObject createObject() {
        return new OracleJsonObjectImpl();
    }

    public OracleJsonArray createArray() {
        return new OracleJsonArrayImpl();
    }

    public OracleJsonObject createObject(OracleJsonObject oracleJsonObject) {
        return new OracleJsonObjectImpl(oracleJsonObject);
    }

    public OracleJsonArray createArray(OracleJsonArray oracleJsonArray) {
        return new OracleJsonArrayImpl(oracleJsonArray);
    }

    public OracleJsonString createString(String string) {
        return new OracleJsonStringImpl(string);
    }

    public OracleJsonDecimal createDecimal(BigDecimal bigDecimal) throws OracleJsonException {
        return new OracleJsonDecimalImpl(bigDecimal);
    }

    public OracleJsonDecimal createDecimal(int n2) {
        return new OracleJsonDecimalImpl(n2);
    }

    public OracleJsonDecimal createDecimal(long l2) {
        return new OracleJsonDecimalImpl(l2);
    }

    public OracleJsonFloat createFloat(float f2) {
        return new OracleJsonFloatImpl(f2);
    }

    public OracleJsonDouble createDouble(double d2) {
        return new OracleJsonDoubleImpl(d2);
    }

    public OracleJsonBinary createBinary(byte[] byArray) {
        return new OracleJsonBinaryImpl(byArray, false);
    }

    public OracleJsonValue createBoolean(boolean bl) {
        return bl ? OracleJsonValue.TRUE : OracleJsonValue.FALSE;
    }

    public OracleJsonValue createNull() {
        return OracleJsonValue.NULL;
    }

    public OracleJsonTimestamp createTimestamp(LocalDateTime localDateTime) {
        return new OracleJsonTimestampImpl(localDateTime);
    }

    public OracleJsonDate createDate(LocalDateTime localDateTime) {
        return new OracleJsonDateImpl(localDateTime);
    }

    public OracleJsonTimestampTZ createTimestampTZ(OffsetDateTime offsetDateTime) {
        return new OracleJsonTimestampTZImpl(offsetDateTime);
    }

    public OracleJsonIntervalDS createIntervalDS(Duration duration) {
        return new OracleJsonIntervalDSImpl(duration);
    }

    public OracleJsonIntervalYM createIntervalYM(Period period) {
        return new OracleJsonIntervalYMImpl(period);
    }

    public OracleJsonValue createValue(Datum datum) {
        try {
            if (datum instanceof CHAR) {
                return new OracleJsonStringImpl(datum.stringValue());
            }
            if (datum instanceof NUMBER) {
                return new OracleJsonDecimalImpl(datum.getBytes(), null);
            }
            if (datum instanceof BINARY_DOUBLE) {
                return new OracleJsonDoubleImpl(datum.doubleValue());
            }
            if (datum instanceof BINARY_FLOAT) {
                return new OracleJsonFloatImpl(datum.floatValue());
            }
            if (datum instanceof RAW) {
                return new OracleJsonBinaryImpl(datum.getBytes(), false);
            }
            if (datum instanceof DATE) {
                return new OracleJsonDateImpl(datum.getBytes());
            }
            if (datum instanceof TIMESTAMP) {
                return new OracleJsonTimestampImpl(datum.getBytes());
            }
            if (datum instanceof INTERVALDS) {
                return new OracleJsonIntervalDSImpl(datum.getBytes());
            }
            if (datum instanceof INTERVALYM) {
                return new OracleJsonIntervalYMImpl(datum.getBytes());
            }
            if (datum instanceof OracleJsonDatum) {
                OracleJsonDatum oracleJsonDatum = (OracleJsonDatum)datum;
                return this.createJsonBinaryValue(ByteBuffer.wrap(oracleJsonDatum.shareBytes()));
            }
            if (datum instanceof TIMESTAMPTZ) {
                return new OracleJsonTimestampTZImpl(datum.getBytes());
            }
            throw new UnsupportedOperationException();
        }
        catch (SQLException sQLException) {
            throw new OracleJsonException(sQLException.getMessage(), sQLException);
        }
    }

    private static byte[] readInputStream(InputStream inputStream) throws OracleJsonException {
        try {
            int n2;
            byte[] byArray = new byte[8192];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw OracleJsonExceptions.IO.create(OracleJsonExceptions.ORACLE_FACTORY, iOException, new Object[0]);
        }
    }
}

