/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.ser.std.DateSerializer;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Date;
import oracle.jdbc.provider.oson.OsonGenerator;

public class OsonDateSerializer
extends DateSerializer {
    public static final OsonDateSerializer INSTANCE = new OsonDateSerializer(false, false);
    private boolean isTemporalTimeStamp = false;
    private boolean isTemporalTime = false;

    public OsonDateSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
        return new OsonDateSerializer(timestamp, customFormat);
    }

    public OsonDateSerializer(boolean isTemporalTimeStamp, boolean isTemporalTime) {
        this(null, null);
        this.isTemporalTimeStamp = isTemporalTimeStamp;
        this.isTemporalTime = isTemporalTime;
    }

    public OsonDateSerializer(Boolean useTimestamp, DateFormat customFormat) {
        super(useTimestamp, customFormat);
    }

    public void serialize(Date value, JsonGenerator g, SerializerProvider provider) throws IOException {
        if (this._customFormat != null) {
            super.serialize(value, g, provider);
            return;
        }
        if (value instanceof Time) {
            g.writeString(value.toString());
            return;
        }
        if (g instanceof OsonGenerator) {
            if (value instanceof Timestamp) {
                ((OsonGenerator)g).writeTimeStamp((Timestamp)value);
                return;
            }
            ((OsonGenerator)g).writeDate(value);
            return;
        }
        super.serialize(value, g, provider);
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        Temporal temporal;
        AnnotatedMember introspector;
        if (property != null && (introspector = property.getMember()) != null && (temporal = (Temporal)introspector.getAnnotation(Temporal.class)) != null) {
            if (temporal.value() == TemporalType.TIMESTAMP) {
                return new OsonDateSerializer(true, false);
            }
            if (temporal.value() == TemporalType.TIME) {
                return new OsonDateSerializer(false, true);
            }
        }
        return super.createContextual(serializers, property);
    }
}

