/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OsonConverterSerializer
extends JsonSerializer<Object> {
    private final AttributeConverter<Object, Object> attributeConverter;
    private final Class<?> requiredType;

    public OsonConverterSerializer(Class<? extends AttributeConverter> converter) {
        try {
            this.attributeConverter = converter.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.requiredType = this.resolveRequiredType(this.attributeConverter);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> resolveRequiredType(AttributeConverter<?, ?> attributeConverter) {
        Class iter = attributeConverter.getClass();
        do {
            Method[] methods;
            for (Method method : methods = iter.getDeclaredMethods()) {
                if (!method.getName().equals("convertToDatabaseColumn") || method.getReturnType() == Object.class) continue;
                Class<?> returnType = method.getReturnType();
                return returnType;
            }
        } while ((iter = iter.getSuperclass()).getSuperclass() != null);
        return Object.class;
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        if (this.requiredType.isAssignableFrom(value.getClass())) {
            gen.writeObject(value);
            return;
        }
        Object convertedValue = this.attributeConverter.convertToDatabaseColumn(value);
        gen.writeObject(convertedValue);
    }
}

