/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OsonConverterArraySerializer
extends ArraySerializerBase<Object[]> {
    private final AttributeConverter<Object, Object> attributeConverter;
    private final Class<?> requiredType;

    public OsonConverterArraySerializer(Class<? extends AttributeConverter> converter) {
        super(Object[].class);
        try {
            this.attributeConverter = converter.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.requiredType = this.resolveRequiredType(this.attributeConverter);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Class<?> resolveRequiredType(AttributeConverter<?, ?> attributeConverter) {
        Class iter = attributeConverter.getClass();
        do {
            Method[] methods;
            for (Method method : methods = iter.getDeclaredMethods()) {
                if (!method.getName().equals("convertToDatabaseColumn") || method.getReturnType() == Object.class) continue;
                Class<?> returnType = method.getReturnType();
                return returnType;
            }
        } while ((iter = iter.getSuperclass()).getSuperclass() != null);
        return Object.class;
    }

    public void serialize(Object[] value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        int len = value.length;
        gen.writeStartArray();
        for (int i = 0; i < len; ++i) {
            if (value[i] == null) {
                gen.writeNull();
                continue;
            }
            if (this.requiredType.isAssignableFrom(value[i].getClass())) {
                gen.writeObject(value[i]);
                continue;
            }
            Object convertedValue = this.attributeConverter.convertToDatabaseColumn(value[i]);
            gen.writeObject(convertedValue);
        }
        gen.writeEndArray();
    }

    public JsonSerializer<?> _withResolved(BeanProperty prop, Boolean unwrapSingle) {
        return null;
    }

    protected void serializeContents(Object[] value, JsonGenerator jgen, SerializerProvider provider) {
    }

    public JavaType getContentType() {
        return null;
    }

    public JsonSerializer<?> getContentSerializer() {
        return null;
    }

    public boolean hasSingleElement(Object[] value) {
        return false;
    }

    protected ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return null;
    }
}

