/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import java.io.IOException;
import java.sql.Date;
import java.text.DateFormat;
import java.time.LocalDateTime;
import oracle.jdbc.provider.oson.OsonParser;
import oracle.sql.json.OracleJsonParser;

public class OsonSqlDateDeserializer
extends DateDeserializers.SqlDateDeserializer {
    public static final OsonSqlDateDeserializer INSTANCE = new OsonSqlDateDeserializer();

    public OsonSqlDateDeserializer() {
    }

    public OsonSqlDateDeserializer(DateDeserializers.SqlDateDeserializer src, DateFormat df, String formatString) {
        super(src, df, formatString);
    }

    protected DateDeserializers.SqlDateDeserializer withDateFormat(DateFormat df, String formatString) {
        return super.withDateFormat(df, formatString);
    }

    public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        OsonParser parser;
        if (p instanceof OsonParser && (parser = (OsonParser)p).currentOsonEvent().equals((Object)OracleJsonParser.Event.VALUE_DATE)) {
            LocalDateTime dateTime = parser.readLocalDateTime();
            return Date.valueOf(dateTime.toLocalDate());
        }
        return super.deserialize(p, ctxt);
    }
}

