/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class OsonSerializableDeserializer
extends JsonDeserializer<Object> {
    public static final OsonSerializableDeserializer INSTANCE = new OsonSerializableDeserializer();

    OsonSerializableDeserializer() {
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        Serializable serializable;
        byte[] data = p.getBinaryValue();
        if (data == null) {
            return null;
        }
        ObjectInputStream objectStream = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            serializable = (Serializable)objectStream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    objectStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Class not found during deserialization", e);
            }
        }
        objectStream.close();
        return serializable;
    }
}

