/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import oracle.jdbc.provider.oson.OsonParser;
import oracle.sql.json.OracleJsonParser;

public class OsonOffsetDateTimeDeserializer
extends InstantDeserializer<OffsetDateTime> {
    public static final OsonOffsetDateTimeDeserializer INSTANCE = new OsonOffsetDateTimeDeserializer();

    protected OsonOffsetDateTimeDeserializer() {
        super(OffsetDateTime.class, DateTimeFormatter.ISO_OFFSET_DATE_TIME, OffsetDateTime::from, a -> OffsetDateTime.ofInstant(Instant.ofEpochMilli(a.value), a.zoneId), a -> OffsetDateTime.ofInstant(Instant.ofEpochSecond(a.integer, a.fraction), a.zoneId), (d, z) -> d.isEqual(OffsetDateTime.MIN) || d.isEqual(OffsetDateTime.MAX) ? d : d.withOffsetSameInstant(z.getRules().getOffset(d.toLocalDateTime())), true);
    }

    protected OsonOffsetDateTimeDeserializer(OsonOffsetDateTimeDeserializer base, DateTimeFormatter f) {
        super((InstantDeserializer)base, f);
    }

    protected OsonOffsetDateTimeDeserializer(OsonOffsetDateTimeDeserializer base, Boolean adjustToContextTimezoneOverride) {
        super((InstantDeserializer)base, adjustToContextTimezoneOverride);
    }

    protected OsonOffsetDateTimeDeserializer(OsonOffsetDateTimeDeserializer base, DateTimeFormatter f, Boolean leniency) {
        super((InstantDeserializer)base, f, leniency);
    }

    protected OsonOffsetDateTimeDeserializer withDateFormat(DateTimeFormatter dtf) {
        if (dtf == this._formatter) {
            return this;
        }
        return new OsonOffsetDateTimeDeserializer(this, dtf);
    }

    protected OsonOffsetDateTimeDeserializer withLeniency(Boolean leniency) {
        return new OsonOffsetDateTimeDeserializer(this, this._formatter, leniency);
    }

    protected OsonOffsetDateTimeDeserializer withShape(JsonFormat.Shape shape) {
        return this;
    }

    public OffsetDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p instanceof OsonParser) {
            OsonParser _parser = (OsonParser)p;
            if (_parser.currentOsonEvent().equals((Object)OracleJsonParser.Event.VALUE_TIMESTAMPTZ)) {
                return _parser.readOffsetDateTime();
            }
            return (OffsetDateTime)super.deserialize(p, ctxt);
        }
        return (OffsetDateTime)super.deserialize(p, ctxt);
    }
}

