/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import oracle.jdbc.provider.oson.OsonParser;
import oracle.sql.json.OracleJsonParser;

public class OsonDateDeserializer
extends DateDeserializers.DateDeserializer {
    public static final OsonDateDeserializer INSTANCE = new OsonDateDeserializer(false, false);
    private boolean isTemporalTimeStamp = false;
    private boolean isTemporalTime = false;

    public OsonDateDeserializer() {
    }

    public OsonDateDeserializer(boolean isTemporalTimeStamp, boolean isTemporalTime) {
        this();
        this.isTemporalTimeStamp = isTemporalTimeStamp;
        this.isTemporalTime = isTemporalTime;
    }

    public OsonDateDeserializer(DateDeserializers.DateDeserializer base, DateFormat df, String formatString) {
        super(base, df, formatString);
    }

    protected OsonDateDeserializer withDateFormat(DateFormat df, String formatString) {
        return new OsonDateDeserializer(this, df, formatString);
    }

    public Object getEmptyValue(DeserializationContext ctxt) {
        return new Date(0L);
    }

    public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (this._customFormat != null) {
            return super.deserialize(p, ctxt);
        }
        if (p instanceof OsonParser) {
            OsonParser parser = (OsonParser)p;
            if (parser.currentOsonEvent().equals((Object)OracleJsonParser.Event.VALUE_DATE)) {
                LocalDateTime dateTime = parser.readLocalDateTime();
                return java.sql.Date.valueOf(dateTime.toLocalDate());
            }
            if (parser.currentOsonEvent().equals((Object)OracleJsonParser.Event.VALUE_TIMESTAMP)) {
                LocalDateTime dateTime = parser.readLocalDateTime();
                return Timestamp.valueOf(dateTime);
            }
            switch (p.getCurrentTokenId()) {
                case 6: {
                    if (this.isTemporalTime) {
                        return Time.valueOf(p.getText().trim());
                    }
                    String dateTimeString = p.getText().trim();
                    LocalDateTime localDateTime = LocalDateTime.parse(dateTimeString, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
                    return Date.from(localDateTime.atZone(ZoneId.of("UTC")).toInstant());
                }
            }
            return super.deserialize(p, ctxt);
        }
        return super.deserialize(p, ctxt);
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        Temporal temporal;
        AnnotatedMember introspector;
        if (property != null && (introspector = property.getMember()) != null && (temporal = (Temporal)introspector.getAnnotation(Temporal.class)) != null) {
            if (temporal.value() == TemporalType.TIMESTAMP) {
                return new OsonDateDeserializer(true, false);
            }
            if (temporal.value() == TemporalType.TIME) {
                return new OsonDateDeserializer(false, true);
            }
        }
        return super.createContextual(ctxt, property);
    }
}

