/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson.deser;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import oracle.jdbc.provider.oson.deser.OsonConverterDeserializer;

public class OsonConverterArrayDeserializer<T>
extends JsonDeserializer<T[]> {
    private final Class<?> elementType;
    private final OsonConverterDeserializer<T> deserializer;

    public OsonConverterArrayDeserializer(Class<? extends AttributeConverter> converter) {
        this.elementType = this.resolveType(converter);
        this.deserializer = new OsonConverterDeserializer(converter);
    }

    private Class<?> resolveType(Class<? extends AttributeConverter> converter) {
        Class<? extends AttributeConverter> iter = converter;
        do {
            Method[] methods;
            for (Method method : methods = iter.getDeclaredMethods()) {
                if (!method.getName().equals("convertToEntityAttribute") || method.getReturnType() == Object.class) continue;
                return method.getReturnType();
            }
        } while ((iter = iter.getSuperclass()).getSuperclass() != null);
        return Object.class;
    }

    public T[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        ArrayList<T> result = new ArrayList<T>();
        if (p.getCurrentToken() == JsonToken.START_ARRAY) {
            while (p.nextToken() != JsonToken.END_ARRAY) {
                result.add(this.deserializer.deserialize(p, ctxt));
            }
        }
        Object[] array = (Object[])Array.newInstance(this.elementType, result.size());
        return result.toArray(array);
    }
}

