/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Logger;

public class Util {
    private static final Logger logger = Logger.getLogger(Util.class.getName());

    public static boolean isJavaSerializableType(Class<?> clazz) {
        String packageName = clazz.getPackage().getName();
        logger.fine("Util.isJavaSerializableType packageName: " + packageName);
        return packageName.startsWith("java.lang") || packageName.startsWith("java.util") || packageName.startsWith("java.sql") || packageName.startsWith("java.time") || packageName.startsWith("java.math") || packageName.startsWith("java.security") || packageName.startsWith("java.net") || clazz.isArray();
    }

    public static boolean implementsSerializable(List<JavaType> interfaces) {
        boolean result = false;
        for (JavaType javaType : interfaces) {
            if (!Serializable.class.isAssignableFrom(javaType.getRawClass())) continue;
            result = true;
            break;
        }
        return result;
    }

    public static boolean isJavaWrapperSerializable(BeanPropertyWriter writer) {
        JavaType type = writer.getType();
        return Util.isJavaWrapperSerializable(type);
    }

    public static boolean isJavaWrapperSerializable(JavaType type) {
        Class rawType = type.getRawClass();
        return Util.isJavaSerializableType(rawType);
    }
}

