/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.util.VersionUtil;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import jakarta.persistence.Convert;
import java.io.InputStream;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.Year;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.provider.oson.Util;
import oracle.jdbc.provider.oson.deser.OsonBigIntegerDeserializer;
import oracle.jdbc.provider.oson.deser.OsonBooleanDeserializer;
import oracle.jdbc.provider.oson.deser.OsonByteDeserializer;
import oracle.jdbc.provider.oson.deser.OsonConverterArrayDeserializer;
import oracle.jdbc.provider.oson.deser.OsonConverterDeserializer;
import oracle.jdbc.provider.oson.deser.OsonDateDeserializer;
import oracle.jdbc.provider.oson.deser.OsonDurationDeserializer;
import oracle.jdbc.provider.oson.deser.OsonLocalDateDeserializer;
import oracle.jdbc.provider.oson.deser.OsonLocalDateTimeDeserializer;
import oracle.jdbc.provider.oson.deser.OsonOffsetDateTimeDeserializer;
import oracle.jdbc.provider.oson.deser.OsonPeriodDeserializer;
import oracle.jdbc.provider.oson.deser.OsonSerializableDeserializer;
import oracle.jdbc.provider.oson.deser.OsonSqlDateDeserializer;
import oracle.jdbc.provider.oson.deser.OsonTimeStampDeserializer;
import oracle.jdbc.provider.oson.deser.OsonUUIDDeserializer;
import oracle.jdbc.provider.oson.deser.OsonYearDeserializer;
import oracle.jdbc.provider.oson.ser.OsonBigIntegerSerializer;
import oracle.jdbc.provider.oson.ser.OsonByteSerializer;
import oracle.jdbc.provider.oson.ser.OsonConverterArraySerializer;
import oracle.jdbc.provider.oson.ser.OsonConverterSerializer;
import oracle.jdbc.provider.oson.ser.OsonDateSerializer;
import oracle.jdbc.provider.oson.ser.OsonDurationSerializer;
import oracle.jdbc.provider.oson.ser.OsonEnumSerializer;
import oracle.jdbc.provider.oson.ser.OsonLocalDateSerializer;
import oracle.jdbc.provider.oson.ser.OsonLocalDateTimeSerializer;
import oracle.jdbc.provider.oson.ser.OsonOffsetDateTimeSerializer;
import oracle.jdbc.provider.oson.ser.OsonPeriodSerializer;
import oracle.jdbc.provider.oson.ser.OsonSerializableSerializer;
import oracle.jdbc.provider.oson.ser.OsonYearSerializer;

public class OsonModule
extends SimpleModule {
    public static String providerVersion;
    public static String groupId;
    public static String artifactId;
    public static Version VERSION;
    public static final String PROPERTIES_FILE_PATH = "/META-INF/maven/com.oracle.database.jdbc/ojdbc-provider-jackson-oson/pom.properties";
    private static final Logger logger;

    private static void instantiateProviderVersionInfo() {
        Properties properties = new Properties();
        try (InputStream inputStream = OsonModule.class.getResourceAsStream(PROPERTIES_FILE_PATH);){
            if (inputStream != null) {
                properties.load(inputStream);
                providerVersion = properties.getProperty("version");
                groupId = properties.getProperty("groupId");
                artifactId = properties.getProperty("artifactId");
            } else {
                providerVersion = "1.0";
                groupId = "com.oracle.database.jdbc";
                artifactId = "ojdbc-provider-jackson-oson";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OsonModule() {
        super(VERSION);
        this.addDeserializer(LocalDateTime.class, (JsonDeserializer)OsonLocalDateTimeDeserializer.INSTANCE);
        this.addSerializer(LocalDateTime.class, (JsonSerializer)OsonLocalDateTimeSerializer.INSTANCE);
        this.addDeserializer(OffsetDateTime.class, (JsonDeserializer)OsonOffsetDateTimeDeserializer.INSTANCE);
        this.addSerializer(OffsetDateTime.class, (JsonSerializer)OsonOffsetDateTimeSerializer.INSTANCE);
        this.addDeserializer(Period.class, (JsonDeserializer)OsonPeriodDeserializer.INSTANCE);
        this.addSerializer(Period.class, (JsonSerializer)OsonPeriodSerializer.INSTANCE);
        this.addDeserializer(Duration.class, (JsonDeserializer)OsonDurationDeserializer.INSTANCE);
        this.addSerializer(Duration.class, (JsonSerializer)OsonDurationSerializer.INSTANCE);
        this.addDeserializer(BigInteger.class, (JsonDeserializer)OsonBigIntegerDeserializer.INSTANCE);
        this.addSerializer(BigInteger.class, (JsonSerializer)OsonBigIntegerSerializer.INSTANCE);
        this.addDeserializer(Year.class, (JsonDeserializer)OsonYearDeserializer.INSTANCE);
        this.addSerializer(Year.class, (JsonSerializer)OsonYearSerializer.INSTANCE);
        this.addDeserializer(byte[].class, (JsonDeserializer)OsonByteDeserializer.INSTANCE);
        this.addSerializer(byte[].class, (JsonSerializer)OsonByteSerializer.INSTANCE);
        this.addDeserializer(java.util.Date.class, (JsonDeserializer)OsonDateDeserializer.INSTANCE);
        this.addSerializer(java.util.Date.class, (JsonSerializer)OsonDateSerializer.INSTANCE);
        this.addDeserializer(Date.class, (JsonDeserializer)OsonSqlDateDeserializer.INSTANCE);
        this.addDeserializer(Timestamp.class, (JsonDeserializer)OsonTimeStampDeserializer.INSTANCE);
        this.addDeserializer(UUID.class, (JsonDeserializer)OsonUUIDDeserializer.INSTANCE);
        this.addDeserializer(Boolean.class, (JsonDeserializer)OsonBooleanDeserializer.INSTANCE);
        this.addSerializer(LocalDate.class, (JsonSerializer)OsonLocalDateSerializer.INSTANCE);
        this.addDeserializer(LocalDate.class, (JsonDeserializer)OsonLocalDateDeserializer.INSTANCE);
        logger.log(Level.FINEST, "OsonModule instantiated.");
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addBeanSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                Iterator properties = serializer.properties();
                while (properties.hasNext()) {
                    boolean serializerAssigned = false;
                    BeanPropertyWriter writer = (BeanPropertyWriter)properties.next();
                    if (writer.getMember() != null && writer.getMember().hasAnnotation(Convert.class)) {
                        Object mySerializer;
                        Convert annotation = (Convert)writer.getMember().getAnnotation(Convert.class);
                        Class converterClass = annotation.converter();
                        serializerAssigned = true;
                        if (writer.getType().isArrayType()) {
                            mySerializer = new OsonConverterArraySerializer(converterClass);
                            writer.assignSerializer((JsonSerializer)mySerializer);
                            logger.log(Level.FINEST, "OsonConverterArraySerializer assigned: " + writer.getName());
                        } else {
                            mySerializer = new OsonConverterSerializer(converterClass);
                            writer.assignSerializer((JsonSerializer)mySerializer);
                            logger.log(Level.FINEST, "OsonConverterSerializer assigned: " + writer.getName());
                        }
                    }
                    if (!Util.implementsSerializable(writer.getType().getInterfaces()) || Util.isJavaWrapperSerializable(writer) || serializerAssigned) continue;
                    writer.assignSerializer((JsonSerializer)OsonSerializableSerializer.INSTANCE);
                    logger.log(Level.FINEST, "OsonSerializableSerializer assigned: " + writer.getName());
                }
                return serializer;
            }

            public JsonSerializer<?> modifyEnumSerializer(SerializationConfig config, JavaType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                return new OsonEnumSerializer(false, false);
            }
        });
        context.addBeanDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (deserializer instanceof BeanDeserializer) {
                    Iterator properties = ((BeanDeserializer)deserializer).properties();
                    while (properties.hasNext()) {
                        SettableBeanProperty property = (SettableBeanProperty)properties.next();
                        boolean deserializerAssigned = false;
                        if (property.getMember() != null && property.getMember().hasAnnotation(Convert.class)) {
                            JsonDeserializer deser;
                            Convert annotation = (Convert)property.getMember().getAnnotation(Convert.class);
                            Class converterClass = annotation.converter();
                            deserializerAssigned = true;
                            if (property.getType().isArrayType()) {
                                deser = new OsonConverterArrayDeserializer(converterClass);
                                ((BeanDeserializer)deserializer).replaceProperty(property, property.withValueDeserializer(deser));
                                logger.log(Level.FINEST, "OsonConverterArrayDeserializer assigned: " + property.getName());
                            } else {
                                deser = new OsonConverterDeserializer(converterClass);
                                ((BeanDeserializer)deserializer).replaceProperty(property, property.withValueDeserializer(deser));
                                logger.log(Level.FINEST, "OsonConverterDeserializer assigned: " + property.getName());
                            }
                        }
                        if (!Util.implementsSerializable(property.getType().getInterfaces()) || Util.isJavaWrapperSerializable(property.getType()) || deserializerAssigned) continue;
                        OsonSerializableDeserializer deser = OsonSerializableDeserializer.INSTANCE;
                        ((BeanDeserializer)deserializer).replaceProperty(property, property.withValueDeserializer((JsonDeserializer)deser));
                        logger.log(Level.FINEST, "OsonSerializableDeserializer assigned: " + property.getName());
                    }
                    return deserializer;
                }
                return deserializer;
            }
        });
    }

    static {
        logger = Logger.getLogger(OsonModule.class.getName());
        OsonModule.instantiateProviderVersionInfo();
        VERSION = VersionUtil.parseVersion((String)providerVersion, (String)groupId, (String)artifactId);
        logger.info("OsonExtention version: " + groupId + ":" + artifactId + ":" + providerVersion);
    }
}

