/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.provider.oson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.provider.oson.OsonFactory;
import oracle.jdbc.provider.oson.OsonModule;
import oracle.jdbc.spi.OsonConverter;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonParser;

public class JacksonOsonConverter
implements OsonConverter {
    private static final OsonFactory osonFactory = new OsonFactory();
    private static final ObjectMapper om = new ObjectMapper((JsonFactory)osonFactory);
    private static final Logger logger = Logger.getLogger(JacksonOsonConverter.class.getName());

    public void serialize(OracleJsonGenerator oGen, Object object) throws IllegalStateException {
        logger.log(Level.FINEST, "Serializing to OSON");
        try {
            om.writeValue(osonFactory.createGenerator(oGen), object);
        }
        catch (IOException e) {
            throw new IllegalStateException("Oson conversion failed", e);
        }
    }

    public Object deserialize(OracleJsonParser oParser, Class<?> type) throws IllegalStateException {
        logger.log(Level.FINEST, "Deserializing OSON");
        if (!oParser.hasNext()) {
            return null;
        }
        try {
            return om.readValue(osonFactory.createParser(oParser), type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Object parsing from oson failed", e);
        }
    }

    public static Object convertValue(Object fromValue, JavaType javaType) {
        logger.log(Level.FINEST, "Converting value to JavaType");
        return om.convertValue(fromValue, javaType);
    }

    public static ObjectMapper getObjectMapper() {
        return om;
    }

    public static OsonFactory getOsonFactory() {
        return osonFactory;
    }

    static {
        om.findAndRegisterModules();
        om.registerModule((Module)new OsonModule());
        om.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
    }
}

