/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.Map;
import oracle.ons.CallBack;
import oracle.ons.CallBackMode;
import oracle.ons.Message;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.Subscriber;

public class CallBackSubscriber
extends Subscriber {
    private String logicalAddress = "";
    private boolean started = false;
    private String rpcServerName;
    private Map<String, String> addrProperties;

    public CallBackSubscriber(String rpcServerName, String subscription, String component, CallBack callback, CallBackMode callBackMode, Map<String, String> addrProperties) {
        this(rpcServerName, ONS.getONS(), subscription, component, callback, callBackMode, addrProperties);
    }

    public CallBackSubscriber(String rpcServerName, ONS myONS, String subscription, String component, CallBack callback, CallBackMode callBackMode, Map<String, String> addrProperties) {
        super(myONS.getNetwork().config, subscription, component, callback);
        if (callback == null) {
            throw new IllegalStateException("oracle.ons.Callback parameter must not be null");
        }
        this.rpcServerName = rpcServerName;
        this.started = false;
        this.addrProperties = addrProperties;
    }

    public String getLogicalAddress() {
        return this.logicalAddress;
    }

    public void start() {
        this.started = true;
    }

    @Override
    protected boolean handleInternalNotification(Notification n) {
        return super.handleInternalNotification(n);
    }

    @Override
    protected Message getSubscriptionMessage() {
        Message m = new Message("ONSregister");
        m.put("LocalOnly", "true");
        m.put("ONSregisterID", "sONSrpc" + this.rpcServerName);
        m.put("ONSregisterGroup", "true");
        m.put("DirectRoute", "true");
        if (this.addrProperties != null) {
            for (Map.Entry<String, String> entry : this.addrProperties.entrySet()) {
                m.put(entry.getKey(), entry.getValue());
            }
        }
        return m;
    }

    public void sendRpcServerRegistration() {
    }
}

