/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.tuple;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.tuple.Tuple;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class Pair<A, B>
implements ImmutableBean,
Tuple,
Comparable<Pair<A, B>>,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final A first;
    @PropertyDefinition(validate="notNull")
    private final B second;
    private static final long serialVersionUID = 1L;

    public static <A, B> Pair<A, B> of(A first, B second) {
        return new Pair<A, B>(first, second);
    }

    public static <A, B> BinaryOperator<Pair<A, B>> combining(BiFunction<? super A, ? super A, ? extends A> combinerFirst, BiFunction<? super B, ? super B, ? extends B> combinerSecond) {
        return (pair1, pair2) -> pair1.combinedWith((Pair)pair2, combinerFirst, combinerSecond);
    }

    public <C, D> Pair<A, B> combinedWith(Pair<C, D> other, BiFunction<? super A, ? super C, ? extends A> combinerFirst, BiFunction<? super B, ? super D, ? extends B> combinerSecond) {
        return Pair.of(combinerFirst.apply(this.first, other.getFirst()), combinerSecond.apply(this.second, other.getSecond()));
    }

    @Override
    public int size() {
        return 2;
    }

    public ImmutableList<Object> elements() {
        return ImmutableList.of(this.first, this.second);
    }

    @Override
    public int compareTo(Pair<A, B> other) {
        return ComparisonChain.start().compare((Comparable)this.first, (Comparable)other.first).compare((Comparable)this.second, (Comparable)other.second).result();
    }

    public String toString() {
        return "" + '[' + this.first + ", " + this.second + ']';
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static <R, S> Meta<R, S> metaPair(Class<R> cls1, Class<S> cls2) {
        return Meta.INSTANCE;
    }

    private Pair(A first, B second) {
        JodaBeanUtils.notNull(first, (String)"first");
        JodaBeanUtils.notNull(second, (String)"second");
        this.first = first;
        this.second = second;
    }

    public Meta<A, B> metaBean() {
        return Meta.INSTANCE;
    }

    public A getFirst() {
        return this.first;
    }

    public B getSecond() {
        return this.second;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Pair other = (Pair)obj;
            return JodaBeanUtils.equal(this.first, other.first) && JodaBeanUtils.equal(this.second, other.second);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.first);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.second);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder<A, B>
    extends DirectPrivateBeanBuilder<Pair<A, B>> {
        private A first;
        private B second;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return this.first;
                }
                case -906279820: {
                    return this.second;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder<A, B> set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    this.first = newValue;
                    break;
                }
                case -906279820: {
                    this.second = newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Pair<A, B> build() {
            return new Pair(this.first, this.second);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("Pair.Builder{");
            buf.append("first").append('=').append(JodaBeanUtils.toString(this.first)).append(',').append(' ');
            buf.append("second").append('=').append(JodaBeanUtils.toString(this.second));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta<A, B>
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<A> first = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"first", Pair.class, Object.class);
        private final MetaProperty<B> second = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"second", Pair.class, Object.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"first", "second"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return this.first;
                }
                case -906279820: {
                    return this.second;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends Pair<A, B>> builder() {
            return new Builder();
        }

        public Class<? extends Pair<A, B>> beanType() {
            return Pair.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<A> first() {
            return this.first;
        }

        public MetaProperty<B> second() {
            return this.second;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return ((Pair)bean).getFirst();
                }
                case -906279820: {
                    return ((Pair)bean).getSecond();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

