/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.named;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.io.IniFile;
import com.opengamma.strata.collect.io.PropertySet;
import com.opengamma.strata.collect.io.ResourceConfig;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Logger;
import org.joda.convert.RenameHandler;

public final class CombinedExtendedEnum<T extends Named> {
    private static final Logger log = Logger.getLogger(CombinedExtendedEnum.class.getName());
    private static final String TYPES_SECTION = "types";
    private final Class<T> type;
    private final ImmutableList<ExtendedEnum<? extends T>> children;

    public static <R extends Named> CombinedExtendedEnum<R> of(Class<R> type) {
        try {
            String name = type.getSimpleName() + ".ini";
            IniFile config = ResourceConfig.combinedIniFile(name);
            ImmutableList children = CombinedExtendedEnum.parseChildren(config, type);
            log.fine(() -> "Loaded combined extended enum: " + name + ", providers: " + children);
            return new CombinedExtendedEnum<R>(type, children);
        }
        catch (RuntimeException ex) {
            log.severe("Failed to load CombinedExtendedEnum for " + type + ": " + Throwables.getStackTraceAsString((Throwable)ex));
            return new CombinedExtendedEnum<R>(type, ImmutableList.of());
        }
    }

    private static <R extends Named> ImmutableList<ExtendedEnum<? extends R>> parseChildren(IniFile config, Class<R> enumType) {
        if (!config.contains(TYPES_SECTION)) {
            return ImmutableList.of();
        }
        PropertySet section = config.section(TYPES_SECTION);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String key : section.keys()) {
            ExtendedEnum result;
            Method method;
            Class cls;
            try {
                cls = RenameHandler.INSTANCE.lookupType(key);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to find extended enum class: " + key, ex);
            }
            try {
                method = cls.getMethod("extendedEnum", new Class[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to find extendedEnum() method on class: " + cls.getName(), ex);
            }
            if (!method.getReturnType().equals(ExtendedEnum.class)) {
                throw new IllegalArgumentException("Method extendedEnum() does not return ExtendedEnum on class: " + cls.getName());
            }
            try {
                result = (ExtendedEnum)ExtendedEnum.class.cast(method.invoke(null, new Object[0]));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Unable to call extendedEnum() method on class: " + cls.getName(), ex);
            }
            if (!enumType.isAssignableFrom(result.getType())) {
                throw new IllegalArgumentException("Method extendedEnum() returned an ExtendedEnum with an incompatible type on class: " + cls.getName());
            }
            builder.add((Object)result);
        }
        return builder.build();
    }

    private CombinedExtendedEnum(Class<T> type, ImmutableList<ExtendedEnum<? extends T>> children) {
        this.type = ArgChecker.notNull(type, "type");
        this.children = ArgChecker.notNull(children, "children");
    }

    public Optional<T> find(String name) {
        for (ExtendedEnum child : this.children) {
            Optional found = child.find(name);
            if (!found.isPresent()) continue;
            return found;
        }
        return Optional.empty();
    }

    public T lookup(String name) {
        return (T)((Named)this.find(name).orElseThrow(() -> new IllegalArgumentException(this.type.getSimpleName() + " name not found: " + name)));
    }

    public String toString() {
        return "CombinedExtendedEnum[" + this.type.getSimpleName() + "]";
    }
}

