/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.io.ArrayByteSource;
import com.opengamma.strata.collect.io.BeanByteSource;
import com.opengamma.strata.collect.io.ZipDecryptInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

public final class ZipUtils {
    private static final Path DUMMY_PATH = Paths.get("/dummy/", new String[0]);

    private ZipUtils() {
    }

    public static Set<String> unzipPathNames(BeanByteSource source) {
        ImmutableSet.Builder entryNames = ImmutableSet.builder();
        try (ZipInputStream in = new ZipInputStream(source.openStream());){
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                ZipUtils.validateZipPathName(DUMMY_PATH, entry);
                if (!entry.isDirectory()) {
                    entryNames.add((Object)entry.getName());
                }
                in.closeEntry();
                entry = in.getNextEntry();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return entryNames.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ArrayByteSource> unzipPathNameInMemory(BeanByteSource source, String relativePathName) {
        ArgChecker.notNull(relativePathName, "relativePathName");
        try (ZipInputStream in = new ZipInputStream(source.openStream());){
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                ZipUtils.validateZipPathName(DUMMY_PATH, entry);
                if (!entry.isDirectory() && entry.getName().equals(relativePathName)) {
                    ArrayByteSource extractedBytes = ZipUtils.extractInputStream(in, entry.getName());
                    Optional<ArrayByteSource> optional = Optional.of(extractedBytes);
                    return optional;
                }
                in.closeEntry();
                entry = in.getNextEntry();
            }
            return Optional.empty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static void unzip(BeanByteSource source, Path path) {
        Path absolutePath = path.toAbsolutePath();
        HashSet<ZipKey> deduplicate = new HashSet<ZipKey>();
        try (ZipInputStream in = new ZipInputStream(source.openStream());){
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                Path resolved = ZipUtils.validateZipPathName(absolutePath, entry);
                if (!entry.isDirectory() && deduplicate.add(new ZipKey(entry, resolved))) {
                    Files.createDirectories(resolved, new FileAttribute[0]);
                    Files.copy(in, resolved, StandardCopyOption.REPLACE_EXISTING);
                }
                in.closeEntry();
                entry = in.getNextEntry();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArrayByteSource zipInMemory(List<? extends BeanByteSource> sources) {
        long instantMillis = System.currentTimeMillis();
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (ZipOutputStream out = new ZipOutputStream(baos);){
                for (BeanByteSource beanByteSource : sources) {
                    ZipEntry entry = new ZipEntry(beanByteSource.getFileName().orElseThrow(() -> new IllegalArgumentException("ByteSource must have a name in order to be zipped")));
                    entry.setTime(instantMillis);
                    out.putNextEntry(entry);
                    beanByteSource.copyTo(out);
                    out.closeEntry();
                }
            }
            ArrayByteSource arrayByteSource = ArrayByteSource.ofUnsafe(baos.toByteArray());
            return arrayByteSource;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static Map<String, ArrayByteSource> unpackInMemory(BeanByteSource source) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ZipUtils.unpackInMemory(source, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    public static void unpackInMemory(BeanByteSource source, BiConsumer<String, ArrayByteSource> consumer) {
        block19: {
            String fileName = source.getFileName().orElse("");
            if (ZipUtils.suffixMatches(fileName, ".zip")) {
                ZipUtils.unzipInMemory(source, consumer);
            } else if (ZipUtils.suffixMatches(fileName, ".gz")) {
                ZipUtils.ungzInMemory(source, fileName, consumer);
            } else {
                if (ZipUtils.suffixMatches(fileName, ".base64")) {
                    try (InputStream in = Base64.getDecoder().wrap(source.openBufferedStream());){
                        String shortFileName = fileName.substring(0, fileName.length() - 7);
                        ArrayByteSource extracted = ZipUtils.extractInputStream(in, shortFileName);
                        consumer.accept(shortFileName, extracted);
                        break block19;
                    }
                    catch (IOException ex) {
                        throw new UncheckedIOException(ex);
                    }
                }
                consumer.accept(fileName, source.load());
            }
        }
    }

    public static Map<String, ArrayByteSource> unzipInMemory(BeanByteSource source) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ZipUtils.unzipInMemory(source, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        return builder.build();
    }

    public static void unzipInMemory(BeanByteSource source, BiConsumer<String, ArrayByteSource> consumer) {
        HashSet<ZipKey> deduplicate = new HashSet<ZipKey>();
        try (ZipInputStream in = new ZipInputStream(source.openStream());){
            ZipEntry entry = in.getNextEntry();
            while (entry != null) {
                Path resolved = ZipUtils.validateZipPathName(DUMMY_PATH, entry);
                if (!entry.isDirectory() && deduplicate.add(new ZipKey(entry, resolved))) {
                    ArrayByteSource extractedBytes = ZipUtils.extractInputStream(in, entry.getName());
                    consumer.accept(entry.getName(), extractedBytes);
                }
                in.closeEntry();
                entry = in.getNextEntry();
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static BeanByteSource decryptZip(BeanByteSource source, String password) {
        return new ZipDecryptByteSource(source, password);
    }

    private static void ungzInMemory(BeanByteSource source, String fileName, BiConsumer<String, ArrayByteSource> consumer) {
        try (GZIPInputStream in = new GZIPInputStream(source.openStream());){
            String shortFileName = fileName.substring(0, fileName.length() - 3);
            ArrayByteSource extractedBytes = ZipUtils.extractInputStream(in, shortFileName);
            consumer.accept(shortFileName, extractedBytes);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static boolean suffixMatches(String name, String suffix) {
        return name.regionMatches(true, name.length() - suffix.length(), suffix, 0, suffix.length());
    }

    private static ArrayByteSource extractInputStream(InputStream in, String fileName) throws IOException {
        try {
            return ArrayByteSource.from(in).withFileName(fileName);
        }
        catch (OutOfMemoryError ex) {
            System.gc();
            throw new IOException("Unzipped input too large: " + fileName);
        }
    }

    private static Path validateZipPathName(Path rootPath, ZipEntry entry) throws ZipException {
        Path normalizedRootPath = rootPath.normalize();
        Path resolved = normalizedRootPath.resolve(entry.getName()).normalize();
        if (!resolved.startsWith(normalizedRootPath)) {
            throw new ZipException("ZIP file contains illegal file name: " + entry.getName());
        }
        return resolved;
    }

    private static final class ZipDecryptByteSource
    extends BeanByteSource
    implements ImmutableBean {
        @PropertyDefinition
        private final BeanByteSource underlying;
        private final char[] password;
        private static final TypedMetaBean<ZipDecryptByteSource> META_BEAN = LightMetaBean.of(ZipDecryptByteSource.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"underlying"}, (Object[])new Object[0]);

        private ZipDecryptByteSource(BeanByteSource underlying) {
            throw new IllegalStateException("ZipDecryptByteSource cannot be deserialized as it contains a password");
        }

        private ZipDecryptByteSource(BeanByteSource underlying, String password) {
            this.underlying = ArgChecker.notNull(underlying, "underlying");
            this.password = ArgChecker.notNull(password, "password").toCharArray();
        }

        @Override
        public Optional<String> getFileName() {
            return this.underlying.getFileName();
        }

        public InputStream openStream() throws IOException {
            return new ZipDecryptInputStream(this.underlying.openStream(), this.password);
        }

        public static TypedMetaBean<ZipDecryptByteSource> meta() {
            return META_BEAN;
        }

        public TypedMetaBean<ZipDecryptByteSource> metaBean() {
            return META_BEAN;
        }

        public BeanByteSource getUnderlying() {
            return this.underlying;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == ((Object)((Object)this)).getClass()) {
                ZipDecryptByteSource other = (ZipDecryptByteSource)((Object)obj);
                return JodaBeanUtils.equal((Object)((Object)this.underlying), (Object)((Object)other.underlying));
            }
            return false;
        }

        public int hashCode() {
            int hash = ((Object)((Object)this)).getClass().hashCode();
            hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.underlying));
            return hash;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("ZipDecryptByteSource{");
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)((Object)this.underlying)));
            buf.append('}');
            return buf.toString();
        }

        static {
            MetaBean.register(META_BEAN);
        }
    }

    private static class ZipKey {
        private final Path resolvedPath;
        private final long crc;
        private final long size;

        private ZipKey(ZipEntry entry, Path resolvedPath) {
            this.resolvedPath = resolvedPath;
            this.crc = entry.getCrc();
            this.size = entry.getSize();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ZipKey) {
                ZipKey key = (ZipKey)obj;
                return this.resolvedPath.equals(key.resolvedPath) && this.crc == key.crc && this.size == key.size;
            }
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }
    }
}

