/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

class ZipDecryptInputStream
extends InputStream {
    private final InputStream delegate;
    private final int[] keys = new int[3];
    private final int[] pwdKeys = new int[3];
    private ZipState state = ZipState.SIGNATURE;
    private boolean isEncrypted;
    private ZipSection section;
    private int skipBytes;
    private int compressedSize;
    private int crc;
    private static final int BUF_SIZE = 8;
    private int bufOffset = 8;
    private final int[] buf = new int[8];
    private static final int[] CRC_TABLE = new int[256];
    private static final int DECRYPT_HEADER_SIZE = 12;
    private static final int[] LFH_SIGNATURE;
    private static final int[] DD_SIGNATURE;

    ZipDecryptInputStream(InputStream stream, char[] password) {
        this.delegate = stream;
        this.pwdKeys[0] = 305419896;
        this.pwdKeys[1] = 591751049;
        this.pwdKeys[2] = 878082192;
        for (int i = 0; i < password.length; ++i) {
            ZipDecryptInputStream.updateKeyArray((byte)(password[i] & 0xFF), this.pwdKeys);
        }
    }

    @Override
    public int read() throws IOException {
        int result;
        block23: {
            block22: {
                result = this.delegateRead();
                if (this.skipBytes != 0) break block22;
                switch (this.state) {
                    case SIGNATURE: {
                        if (!this.peekAheadEquals(LFH_SIGNATURE)) {
                            this.state = ZipState.TAIL;
                            break;
                        }
                        this.section = ZipSection.FILE_HEADER;
                        this.skipBytes = 5;
                        this.state = ZipState.FLAGS;
                        break;
                    }
                    case FLAGS: {
                        boolean bl = this.isEncrypted = (result & 1) != 0;
                        if ((result & 0x40) == 64) {
                            throw new UncheckedIOException(new IOException("Unable to decrypt ZIP file, ZIP has strong encryption"));
                        }
                        if ((result & 8) == 8) {
                            this.compressedSize = -1;
                            this.state = ZipState.FN_LENGTH;
                            this.skipBytes = 19;
                        } else {
                            this.state = ZipState.CRC;
                            this.skipBytes = 10;
                        }
                        if (this.isEncrypted) {
                            --result;
                            break;
                        }
                        break block23;
                    }
                    case CRC: {
                        this.crc = result;
                        this.state = ZipState.COMPRESSED_SIZE;
                        break;
                    }
                    case COMPRESSED_SIZE: {
                        int[] values = new int[4];
                        this.peekAhead(values);
                        this.compressedSize = 0;
                        int valueInc = this.isEncrypted ? 12 : 0;
                        for (int i = 0; i < 4; ++i) {
                            this.compressedSize += values[i] << 8 * i;
                            int n = i;
                            values[n] = values[n] - valueInc;
                            if (values[i] < 0) {
                                valueInc = 1;
                                int n2 = i;
                                values[n2] = values[n2] + 256;
                                continue;
                            }
                            valueInc = 0;
                        }
                        this.overrideBuffer(values);
                        result = values[0];
                        this.state = this.section == ZipSection.DATA_DESCRIPTOR ? ZipState.SIGNATURE : ZipState.FN_LENGTH;
                        this.skipBytes = 7;
                        break;
                    }
                    case FN_LENGTH: {
                        int[] values = new int[4];
                        this.peekAhead(values);
                        this.skipBytes = 3 + values[0] + values[2] + (values[1] + values[3]) * 256;
                        if (!this.isEncrypted) {
                            if (this.compressedSize > 0) {
                                throw new UncheckedIOException(new IOException("Unable to decrypt ZIP file, ZIP is not password protected"));
                            }
                            this.state = ZipState.SIGNATURE;
                            break;
                        }
                        this.state = ZipState.HEADER;
                        break;
                    }
                    case HEADER: {
                        this.section = ZipSection.FILE_DATA;
                        this.initKeys();
                        byte lastValue = 0;
                        for (int i = 0; i < 12; ++i) {
                            lastValue = (byte)(result ^ this.decryptByte());
                            this.updateKeys(lastValue);
                            result = this.delegateRead();
                        }
                        if ((lastValue & 0xFF) != this.crc) {
                            throw new UncheckedIOException(new IOException("Unable to decrypt ZIP file, wrong password"));
                        }
                        this.compressedSize -= 12;
                        this.state = ZipState.DATA;
                    }
                    case DATA: {
                        if (this.compressedSize == -1 && this.peekAheadEquals(DD_SIGNATURE)) {
                            this.section = ZipSection.DATA_DESCRIPTOR;
                            this.skipBytes = 5;
                            this.state = ZipState.CRC;
                            break;
                        }
                        result = (result ^ this.decryptByte()) & 0xFF;
                        this.updateKeys((byte)result);
                        --this.compressedSize;
                        if (this.compressedSize == 0) {
                            this.state = ZipState.SIGNATURE;
                            break;
                        }
                        break block23;
                    }
                }
                break block23;
            }
            --this.skipBytes;
        }
        return result;
    }

    private int delegateRead() throws IOException {
        ++this.bufOffset;
        if (this.bufOffset >= 8) {
            this.fetchData(0);
            this.bufOffset = 0;
        }
        return this.buf[this.bufOffset];
    }

    private boolean peekAheadEquals(int[] values) throws IOException {
        this.prepareBuffer(values);
        for (int i = 0; i < values.length; ++i) {
            if (this.buf[this.bufOffset + i] == values[i]) continue;
            return false;
        }
        return true;
    }

    private void prepareBuffer(int[] values) throws IOException {
        if (values.length > 8 - this.bufOffset) {
            for (int i = this.bufOffset; i < 8; ++i) {
                this.buf[i - this.bufOffset] = this.buf[i];
            }
            this.fetchData(8 - this.bufOffset);
            this.bufOffset = 0;
        }
    }

    private void peekAhead(int[] values) throws IOException {
        this.prepareBuffer(values);
        System.arraycopy(this.buf, this.bufOffset, values, 0, values.length);
    }

    private void overrideBuffer(int[] values) throws IOException {
        this.prepareBuffer(values);
        System.arraycopy(values, 0, this.buf, this.bufOffset, values.length);
    }

    private void fetchData(int offset) throws IOException {
        for (int i = offset; i < 8; ++i) {
            this.buf[i] = this.delegate.read();
            if (this.buf[i] == -1) break;
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
        super.close();
    }

    private void initKeys() {
        System.arraycopy(this.pwdKeys, 0, this.keys, 0, this.keys.length);
    }

    private void updateKeys(byte charAt) {
        ZipDecryptInputStream.updateKeyArray(charAt, this.keys);
    }

    private byte decryptByte() {
        int temp = this.keys[2] | 2;
        return (byte)(temp * (temp ^ 1) >>> 8);
    }

    private static void updateKeyArray(byte charAt, int[] keys) {
        keys[0] = ZipDecryptInputStream.crc32(keys[0], charAt);
        keys[1] = keys[1] + (keys[0] & 0xFF);
        keys[1] = keys[1] * 134775813 + 1;
        keys[2] = ZipDecryptInputStream.crc32(keys[2], (byte)(keys[1] >> 24));
    }

    private static int crc32(int oldCrc, byte charAt) {
        return oldCrc >>> 8 ^ CRC_TABLE[(oldCrc ^ charAt) & 0xFF];
    }

    static {
        for (int i = 0; i < 256; ++i) {
            int r = i;
            for (int j = 0; j < 8; ++j) {
                if ((r & 1) == 1) {
                    r = r >>> 1 ^ 0xEDB88320;
                    continue;
                }
                r >>>= 1;
            }
            ZipDecryptInputStream.CRC_TABLE[i] = r;
        }
        LFH_SIGNATURE = new int[]{80, 75, 3, 4};
        DD_SIGNATURE = new int[]{80, 75, 7, 8};
    }

    private static enum ZipSection {
        FILE_HEADER,
        FILE_DATA,
        DATA_DESCRIPTOR;

    }

    private static enum ZipState {
        SIGNATURE,
        FLAGS,
        COMPRESSED_SIZE,
        FN_LENGTH,
        EF_LENGTH,
        HEADER,
        DATA,
        TAIL,
        CRC;

    }
}

