/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.io.XmlElement;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class XmlFile {
    private static final XMLInputFactory XML_FACTORY;
    private final XmlElement root;
    private final ImmutableMap<String, XmlElement> refs;

    public static XmlFile of(ByteSource source) {
        return XmlFile.of(source, "");
    }

    public static XmlFile of(ByteSource source, String refAttrName) {
        ArgChecker.notNull(source, "source");
        return Unchecked.wrap(() -> {
            Throwable throwable = null;
            try (InputStream in = source.openBufferedStream();){
                XmlFile xmlFile;
                XMLStreamReader xmlReader = XML_FACTORY.createXMLStreamReader(in);
                try {
                    HashMap<String, XmlElement> refs = new HashMap<String, XmlElement>();
                    XmlElement root = XmlFile.parse(xmlReader, refAttrName, refs);
                    xmlFile = new XmlFile(root, refs);
                }
                catch (Throwable throwable2) {
                    try {
                        xmlReader.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                xmlReader.close();
                return xmlFile;
            }
        });
    }

    public static XmlElement parseElements(ByteSource source, ToIntFunction<String> filterFn) {
        ArgChecker.notNull(source, "source");
        ArgChecker.notNull(filterFn, "filterFn");
        ToIntFunction<String> safeFilterFn = name -> Math.max(filterFn.applyAsInt((String)name), 0);
        return Unchecked.wrap(() -> {
            Throwable throwable = null;
            try (InputStream in = source.openBufferedStream();){
                XmlElement xmlElement;
                XMLStreamReader xmlReader = XML_FACTORY.createXMLStreamReader(in);
                try {
                    xmlElement = XmlFile.parseElements(xmlReader, safeFilterFn, Integer.MAX_VALUE);
                }
                catch (Throwable throwable2) {
                    try {
                        xmlReader.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                xmlReader.close();
                return xmlElement;
            }
        });
    }

    private static XmlElement parse(XMLStreamReader reader, String refAttr, Map<String, XmlElement> refs) {
        try {
            String elementName = XmlFile.parseElementName(reader);
            ImmutableMap<String, String> attrs = XmlFile.parseAttributes(reader);
            ImmutableList.Builder childBuilder = ImmutableList.builder();
            String content = "";
            int event = reader.next();
            while (event != 2) {
                switch (event) {
                    case 1: {
                        childBuilder.add((Object)XmlFile.parse(reader, refAttr, refs));
                        break;
                    }
                    case 4: 
                    case 12: {
                        content = content + reader.getText();
                        break;
                    }
                }
                event = reader.next();
            }
            ImmutableList children = childBuilder.build();
            XmlElement parsed = children.isEmpty() ? XmlElement.ofContent(elementName, attrs, content) : XmlElement.ofChildren(elementName, attrs, (List<XmlElement>)children);
            String ref = (String)attrs.get((Object)refAttr);
            if (ref != null) {
                refs.put(ref, parsed);
            }
            return parsed;
        }
        catch (XMLStreamException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static XmlElement parseElements(XMLStreamReader reader, ToIntFunction<String> filterFn, int currentLevel) {
        try {
            String elementName = XmlFile.parseElementName(reader);
            ImmutableList.Builder childBuilder = ImmutableList.builder();
            int event = reader.next();
            while (event != 2) {
                if (event == 1) {
                    int childLevel = currentLevel == Integer.MAX_VALUE ? filterFn.applyAsInt(elementName) : currentLevel - 1;
                    XmlElement child = XmlFile.parseElements(reader, filterFn, childLevel);
                    if (childLevel > 0) {
                        childBuilder.add((Object)child);
                    }
                }
                event = reader.next();
            }
            ImmutableList children = childBuilder.build();
            XmlElement parsed = children.isEmpty() ? XmlElement.ofContent(elementName, "") : XmlElement.ofChildren(elementName, (List<XmlElement>)children);
            return parsed;
        }
        catch (XMLStreamException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static String parseElementName(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.getEventType();
        while (event != 1) {
            event = reader.next();
        }
        return reader.getLocalName();
    }

    private static ImmutableMap<String, String> parseAttributes(XMLStreamReader reader) {
        ImmutableMap attrs;
        int attributeCount = reader.getAttributeCount() + reader.getNamespaceCount();
        if (attributeCount == 0) {
            attrs = ImmutableMap.of();
        } else {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                builder.put((Object)reader.getAttributeLocalName(i), (Object)reader.getAttributeValue(i));
            }
            attrs = builder.build();
        }
        return attrs;
    }

    private XmlFile(XmlElement root, Map<String, XmlElement> refs) {
        this.root = ArgChecker.notNull(root, "root");
        this.refs = ImmutableMap.copyOf(refs);
    }

    public XmlElement getRoot() {
        return this.root;
    }

    public ImmutableMap<String, XmlElement> getReferences() {
        return this.refs;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XmlFile) {
            XmlFile other = (XmlFile)obj;
            return this.root.equals(other.root) && this.refs.equals(other.refs);
        }
        return false;
    }

    public int hashCode() {
        return this.root.hashCode() ^ this.refs.hashCode();
    }

    public String toString() {
        return this.root.toString();
    }

    static {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", true);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.supportDTD", false);
        XML_FACTORY = factory;
    }
}

