/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;

public final class CsvRow {
    private final ImmutableList<String> headers;
    private final ImmutableMap<String, Integer> searchHeaders;
    private final ImmutableList<String> fields;
    private final int lineNumber;

    private CsvRow(ImmutableList<String> headers, int lineNumber, ImmutableList<String> fields) {
        this.headers = headers;
        HashMap<String, Integer> searchHeaders = new HashMap<String, Integer>();
        for (int i = 0; i < headers.size(); ++i) {
            String searchHeader = ((String)headers.get(i)).toLowerCase(Locale.ENGLISH);
            searchHeaders.putIfAbsent(searchHeader, i);
        }
        this.searchHeaders = ImmutableMap.copyOf(searchHeaders);
        this.lineNumber = lineNumber;
        this.fields = fields;
    }

    CsvRow(ImmutableList<String> headers, ImmutableMap<String, Integer> searchHeaders, int lineNumber, ImmutableList<String> fields) {
        this.headers = headers;
        this.searchHeaders = searchHeaders;
        this.lineNumber = lineNumber;
        this.fields = fields;
    }

    public ImmutableList<String> headers() {
        return this.headers;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public ImmutableList<String> fields() {
        return this.fields;
    }

    public int fieldCount() {
        return Math.max(this.fields.size(), this.headers.size());
    }

    public String field(int index) {
        if (index >= this.fields.size() && index < this.headers.size()) {
            return "";
        }
        return (String)this.fields.get(index);
    }

    public String getField(String header) {
        Integer index = this.findIndex(header);
        if (index == null) {
            throw new IllegalArgumentException("Header not found: '" + header + "'");
        }
        return this.field(index);
    }

    public <T> T getField(String header, Function<String, T> postProcessor) {
        String value = this.getField(header);
        return postProcessor.apply(value);
    }

    public Optional<String> findField(String header) {
        Integer index = this.findIndex(header);
        return index == null ? Optional.empty() : Optional.of(this.field(index));
    }

    private Integer findIndex(String header) {
        return (Integer)this.searchHeaders.get((Object)header.toLowerCase(Locale.ENGLISH));
    }

    public String getField(Pattern headerPattern) {
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!headerPattern.matcher((CharSequence)this.headers.get(i)).matches()) continue;
            return this.field(i);
        }
        throw new IllegalArgumentException("Header pattern not found: '" + headerPattern + "'");
    }

    public <T> T getField(Pattern headerPattern, Function<String, T> postProcessor) {
        String value = this.getField(headerPattern);
        return postProcessor.apply(value);
    }

    public Optional<String> findField(Pattern headerPattern) {
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!headerPattern.matcher((CharSequence)this.headers.get(i)).matches()) continue;
            return Optional.of(this.field(i));
        }
        return Optional.empty();
    }

    public String getValue(String header) {
        String value = this.getField(header);
        if (value.isEmpty()) {
            throw new IllegalArgumentException("No value was found for field: '" + header + "'");
        }
        return value;
    }

    public <T> T getValue(String header, Function<String, T> postProcessor) {
        String value = this.getValue(header);
        return postProcessor.apply(value);
    }

    public Optional<String> findValue(String header) {
        return this.findField(header).filter(str -> !str.isEmpty());
    }

    public <T> Optional<T> findValue(String header, Function<String, T> postProcessor) {
        return this.findValue(header).map(postProcessor);
    }

    public String getValue(Pattern headerPattern) {
        String value = this.getField(headerPattern);
        if (value.isEmpty()) {
            throw new IllegalArgumentException("No value was found for header pattern: '" + headerPattern + "'");
        }
        return value;
    }

    public <T> T getValue(Pattern headerPattern, Function<String, T> postProcessor) {
        String value = this.getValue(headerPattern);
        return postProcessor.apply(value);
    }

    public Optional<String> findValue(Pattern headerPattern) {
        return this.findField(headerPattern).filter(str -> !str.isEmpty());
    }

    public <T> Optional<T> findValue(Pattern headerPattern, Function<String, T> postProcessor) {
        return this.findValue(headerPattern).map(postProcessor);
    }

    public CsvRow subRow(int startInclusive) {
        return this.subRow(startInclusive, this.fields.size());
    }

    public CsvRow subRow(int startInclusive, int endExclusive) {
        return new CsvRow((ImmutableList<String>)this.headers.subList(Math.min(startInclusive, this.headers.size()), Math.min(endExclusive, this.headers.size())), this.lineNumber, (ImmutableList<String>)this.fields.subList(startInclusive, endExclusive));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CsvRow) {
            CsvRow other = (CsvRow)obj;
            return this.headers.equals(other.headers) && this.fields.equals(other.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.headers.hashCode() ^ this.fields.hashCode();
    }

    public String toString() {
        return "CsvRow" + this.fields.toString();
    }
}

