/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.opengamma.strata.collect.Unchecked;
import com.opengamma.strata.collect.function.CheckedFunction;
import com.opengamma.strata.collect.io.ArrayByteSource;
import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum ByteSourceCodec implements NamedEnum
{
    BASE64(base -> Base64.getEncoder().wrap((OutputStream)base), base -> Base64.getDecoder().wrap((InputStream)base), ".base64"),
    GZ(base -> new GZIPOutputStream((OutputStream)base), base -> new GZIPInputStream((InputStream)base), ".gz"),
    GZ_BASE64(base -> new GZIPOutputStream(Base64.getEncoder().wrap((OutputStream)base)), base -> new GZIPInputStream(Base64.getDecoder().wrap((InputStream)base)), ".gz.base64");

    private static final EnumNames<ByteSourceCodec> NAMES;
    private final CheckedFunction<OutputStream, OutputStream> encoder;
    private final CheckedFunction<InputStream, InputStream> decoder;
    private final String suffix;

    @FromString
    public static ByteSourceCodec of(String name) {
        return NAMES.parse(name);
    }

    private ByteSourceCodec(CheckedFunction<OutputStream, OutputStream> encoder, CheckedFunction<InputStream, InputStream> decoder, String suffix) {
        this.encoder = encoder;
        this.decoder = decoder;
        this.suffix = suffix;
    }

    @ToString
    public String toString() {
        return NAMES.format(this);
    }

    ArrayByteSource encode(byte[] bytes, String fileName) {
        ByteArrayOutputStream baos = this.encode(bytes);
        return new ArrayByteSource(baos.toByteArray(), fileName == null ? null : fileName + this.suffix);
    }

    private ByteArrayOutputStream encode(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try (OutputStream out = this.encoder.apply(baos);){
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw Unchecked.propagate(ex);
        }
        return baos;
    }

    ArrayByteSource decode(byte[] bytes, String fileName) {
        try {
            ArrayByteSource decoded = ArrayByteSource.from(this.decode(bytes));
            return fileName == null ? decoded : decoded.withFileName(fileName.endsWith(this.suffix) ? fileName.substring(0, fileName.length() - this.suffix.length()) : fileName);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private InputStream decode(byte[] bytes) throws IOException {
        try {
            return this.decoder.apply(new ByteArrayInputStream(bytes));
        }
        catch (Throwable ex) {
            throw Unchecked.propagate(ex);
        }
    }

    static {
        NAMES = EnumNames.of(ByteSourceCodec.class);
    }
}

