/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.LineProcessor;
import com.opengamma.strata.collect.io.ArrayByteSource;
import com.opengamma.strata.collect.io.BeanByteSource;
import com.opengamma.strata.collect.io.StringCharSource;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.joda.beans.ImmutableBean;

public abstract class BeanCharSource
extends CharSource
implements ImmutableBean {
    protected BeanCharSource() {
    }

    public Optional<String> getFileName() {
        return Optional.empty();
    }

    public String getFileNameOrThrow() {
        return this.getFileName().orElseThrow(() -> new IllegalArgumentException("No file name present on char source"));
    }

    public Stream<String> lines() {
        try {
            return super.lines();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public boolean isEmpty() {
        try {
            return super.isEmpty();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public long length() {
        try {
            return super.length();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String read() {
        try {
            return super.read();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public String readFirstLine() {
        try {
            return super.readFirstLine();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public ImmutableList<String> readLines() {
        try {
            return super.readLines();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public <T> T readLines(LineProcessor<T> processor) {
        try {
            return (T)super.readLines(processor);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public void forEachLine(Consumer<? super String> action) {
        try {
            super.forEachLine(action);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public StringCharSource load() {
        return StringCharSource.from(this);
    }

    public BeanByteSource asByteSourceUtf8() {
        return this.asByteSource(StandardCharsets.UTF_8);
    }

    public BeanByteSource asByteSource(Charset charset) {
        return ArrayByteSource.from(super.asByteSource(charset));
    }
}

