/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.FixedScaleDecimal;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import java.util.function.UnaryOperator;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class Decimal
implements Serializable,
Comparable<Decimal> {
    private static final long serialVersionUID = 1L;
    private static final int MAX_PRECISION = 18;
    static final int MAX_SCALE = 18;
    private static final long MAX_UNSCALED = 999999999999999999L;
    private static final long[] POWERS = new long[19];
    private static final MathContext MATH_CONTEXT;
    public static final Decimal ZERO;
    public static final Decimal MAX_VALUE;
    public static final Decimal MIN_VALUE;
    private final long unscaled;
    private final int scale;

    public static Decimal of(long value) {
        if (value > 999999999999999999L || value < -999999999999999999L) {
            throw new IllegalArgumentException("Decimal value must not exceed 18 digits of precision at scale 0: " + value);
        }
        return new Decimal(value, 0);
    }

    public static Decimal of(double value) {
        if (!Double.isFinite(value)) {
            throw new IllegalArgumentException("Decimal value must be finite: " + value);
        }
        long longValue = (long)value;
        if (value == (double)longValue) {
            return Decimal.of(longValue);
        }
        return Decimal.of(Double.toString(value));
    }

    public static Decimal of(String str) {
        int len = str.length();
        if (len == 0) {
            throw new NumberFormatException("Decimal string must not be empty");
        }
        if (len == 1) {
            return Decimal.parseShortString(str);
        }
        return Decimal.parseString(str);
    }

    private static Decimal parseString(String str) {
        char[] chs = str.toCharArray();
        if (chs.length > 256) {
            throw new NumberFormatException("Decimal string must not exceed 256 characters");
        }
        int sign = 1;
        int startPos = 0;
        char first = chs[0];
        if (first == '-') {
            sign = -1;
            startPos = 1;
        } else if (first == '+') {
            startPos = 1;
        }
        long unscaled = 0L;
        int precision = 0;
        int scale = 0;
        boolean afterDecimalPoint = false;
        block5: for (int i = startPos; i < chs.length; ++i) {
            char ch = chs[i];
            switch (ch) {
                case '+': 
                case '-': {
                    throw new NumberFormatException("Decimal string must not have sign in the middle: " + str);
                }
                case '.': {
                    if (afterDecimalPoint) {
                        throw new NumberFormatException("Decimal string must not have two decimal points: " + str);
                    }
                    afterDecimalPoint = true;
                    continue block5;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (precision >= 18) {
                        if (afterDecimalPoint) continue block5;
                        throw new NumberFormatException("Decimal string must not exceed 18 digits before decimal point: " + str);
                    }
                    if (scale >= 18) continue block5;
                    int chValue = ch - 48;
                    if (afterDecimalPoint) {
                        ++scale;
                    }
                    if (precision <= 0 && chValue <= 0) continue block5;
                    unscaled = unscaled * 10L + (long)chValue;
                    ++precision;
                    continue block5;
                }
                default: {
                    return Decimal.of(new BigDecimal(str));
                }
            }
        }
        return Decimal.ofScaled(unscaled * (long)sign, scale);
    }

    private static Decimal parseShortString(String str) {
        char ch = str.charAt(0);
        if (ch >= '0' && ch <= '9') {
            return new Decimal(ch - 48, 0);
        }
        throw new NumberFormatException("Decimal string is invalid: " + ch);
    }

    public static Decimal of(BigDecimal value) {
        return Decimal.ofRounded(value.round(MATH_CONTEXT));
    }

    private static Decimal ofRounded(BigDecimal value) {
        BigDecimal adjusted = value.stripTrailingZeros();
        BigDecimal bigDecimal = adjusted = adjusted.scale() < 0 ? adjusted.setScale(0) : adjusted;
        if (adjusted.precision() > 18) {
            throw new IllegalArgumentException("Decimal value must not exceed 18 digits of precision at scale 0: " + value);
        }
        return Decimal.ofScaled(adjusted.unscaledValue().longValueExact(), adjusted.scale());
    }

    public static Decimal ofScaled(long unscaled, int scale) {
        if (unscaled == 0L) {
            return ZERO;
        }
        if (scale < 0 || scale > 18 || unscaled > 999999999999999999L || unscaled < -999999999999999999L) {
            return Decimal.ofScaled0(unscaled, scale);
        }
        return Decimal.create(unscaled, scale);
    }

    private static Decimal create(long unscaled, int scale) {
        if (scale > 0 && unscaled % 10L == 0L) {
            return Decimal.create(unscaled / 10L, scale - 1);
        }
        return new Decimal(unscaled, scale);
    }

    private static Decimal ofScaled0(long unscaled, int scale) {
        if (scale >= 36) {
            return ZERO;
        }
        if (scale <= -18) {
            throw new IllegalArgumentException("Decimal value must not exceed 18 digits of precision at scale 0: " + unscaled + "E" + -scale);
        }
        if (unscaled > 999999999999999999L || unscaled < -999999999999999999L) {
            if (scale == 0) {
                throw new IllegalArgumentException("Decimal value must not exceed 18 digits of precision at scale 0: " + unscaled + "E" + -scale);
            }
            return Decimal.ofScaled0(unscaled / 10L, scale - 1);
        }
        if (scale < 0) {
            try {
                long adjUnscaled = Math.multiplyExact(unscaled, POWERS[-scale]);
                return Decimal.ofScaled0(adjUnscaled, 0);
            }
            catch (ArithmeticException ex) {
                throw new IllegalArgumentException("Decimal value must not exceed 18 digits of precision: " + unscaled + "E" + -scale);
            }
        }
        if (scale > 18) {
            long adjUnscaled = unscaled / POWERS[scale - 18];
            if (adjUnscaled == 0L) {
                return ZERO;
            }
            return Decimal.create(adjUnscaled, 18);
        }
        return Decimal.create(unscaled, scale);
    }

    @FromString
    public static Decimal parse(String str) {
        return Decimal.of(str);
    }

    private Decimal(long unscaled, int scale) {
        this.unscaled = unscaled;
        this.scale = scale;
    }

    public long unscaledValue() {
        return this.unscaled;
    }

    public int scale() {
        return this.scale;
    }

    public Decimal plus(Decimal other) {
        if (this.unscaled == 0L) {
            return other;
        }
        if (other.unscaled == 0L) {
            return this;
        }
        return this.plus0(this.unscaled, this.scale, other.unscaled, other.scale);
    }

    public Decimal plus(long other) {
        if (other == 0L) {
            return this;
        }
        if (other < -999999999999999999L || other > 999999999999999999L) {
            try {
                return Decimal.of(Math.addExact(this.longValue(), other));
            }
            catch (ArithmeticException ex) {
                throw new IllegalArgumentException("Decimal value must not exceed 18 digits of precision at scale 0: " + this.unscaled + " * " + other);
            }
        }
        return this.plus0(this.unscaled, this.scale, other, 0);
    }

    public Decimal plus(double other) {
        if (other == 0.0) {
            return this;
        }
        return this.plus(Decimal.of(other));
    }

    private Decimal plus0(long unscaled1, int scale1, long unscaled2, int scale2) {
        if (scale1 == scale2) {
            long sum = unscaled1 + unscaled2;
            return Decimal.ofScaled(sum, scale1);
        }
        if (scale1 > scale2) {
            return this.plus0Sorted(unscaled1, scale1, unscaled2, scale2);
        }
        return this.plus0Sorted(unscaled2, scale2, unscaled1, scale1);
    }

    private Decimal plus0Sorted(long unscaled1, int scale1, long unscaled2, int scale2) {
        int scaleDiff = scale1 - scale2;
        if (scaleDiff < 18 && Math.abs(unscaled2) < POWERS[18 - scaleDiff - 1]) {
            long rescaled2 = unscaled2 * POWERS[scaleDiff];
            return Decimal.ofScaled(unscaled1 + rescaled2, scale1);
        }
        return Decimal.of(BigDecimal.valueOf(unscaled1, scale1).add(BigDecimal.valueOf(unscaled2, scale2)));
    }

    public Decimal minus(Decimal other) {
        if (other.unscaled == 0L) {
            return this;
        }
        return this.plus(other.negated());
    }

    public Decimal minus(long other) {
        if (other == 0L) {
            return this;
        }
        if (other < -999999999999999999L || other > 999999999999999999L) {
            try {
                return Decimal.of(Math.subtractExact(this.longValue(), other));
            }
            catch (ArithmeticException ex) {
                throw new IllegalArgumentException("Decimal value must not exceed 18 digits of precision at scale 0: " + this.unscaled + " * " + other);
            }
        }
        return this.plus0(this.unscaled, this.scale, -other, 0);
    }

    public Decimal minus(double other) {
        if (other == 0.0) {
            return this;
        }
        return this.minus(Decimal.of(other));
    }

    public Decimal multipliedBy(Decimal other) {
        if (other.scale == 0) {
            return this.multipliedBy(other.unscaled);
        }
        return Decimal.of(this.toBigDecimal().multiply(other.toBigDecimal()));
    }

    public Decimal multipliedBy(long other) {
        if (other == 0L) {
            return ZERO;
        }
        try {
            return Decimal.ofScaled(Math.multiplyExact(this.unscaled, other), this.scale);
        }
        catch (ArithmeticException ex) {
            return Decimal.of(this.toBigDecimal().multiply(BigDecimal.valueOf(other)));
        }
    }

    public Decimal multipliedBy(double other) {
        if (other == 0.0) {
            return ZERO;
        }
        return this.multipliedBy(Decimal.of(other));
    }

    public Decimal movePoint(int movement) {
        if (movement == 0) {
            return this;
        }
        try {
            return Decimal.ofScaled0(this.unscaled, Math.subtractExact(this.scale, movement));
        }
        catch (ArithmeticException ex) {
            return ZERO;
        }
    }

    public Decimal dividedBy(Decimal other) {
        return Decimal.ofRounded(this.toBigDecimal().divide(other.toBigDecimal(), MATH_CONTEXT));
    }

    public Decimal dividedBy(Decimal other, RoundingMode roundingMode) {
        return Decimal.ofRounded(this.toBigDecimal().divide(other.toBigDecimal(), new MathContext(18, roundingMode)));
    }

    public Decimal dividedBy(long other) {
        if (other == 1L) {
            return this;
        }
        int pos = Arrays.binarySearch(POWERS, other);
        if (pos > 0) {
            return this.movePoint(-pos);
        }
        return Decimal.ofRounded(this.toBigDecimal().divide(BigDecimal.valueOf(other), MATH_CONTEXT));
    }

    public Decimal dividedBy(double other) {
        return this.dividedBy(Decimal.of(other));
    }

    public Decimal roundToScale(int desiredScale, RoundingMode roundingMode) {
        if (desiredScale >= this.scale) {
            return this;
        }
        if (desiredScale <= -18) {
            throw new IllegalArgumentException("Rounding scale must not be -18 or less: " + desiredScale);
        }
        if (this.unscaled == 0L) {
            return ZERO;
        }
        int adjScale = Math.min(desiredScale, 18);
        switch (roundingMode) {
            case DOWN: {
                return this.roundDownToScale(adjScale);
            }
            case HALF_UP: {
                return this.roundHalfUpToScale(adjScale);
            }
            case FLOOR: {
                return this.unscaled > 0L ? this.roundDownToScale(adjScale) : Decimal.of(this.toBigDecimal().setScale(adjScale, roundingMode));
            }
        }
        return Decimal.of(this.toBigDecimal().setScale(adjScale, roundingMode));
    }

    private Decimal roundDownToScale(int adjScale) {
        int scaleDiff = this.scale - adjScale;
        if (scaleDiff <= 18) {
            long rescaled = this.unscaled / POWERS[scaleDiff];
            return Decimal.ofScaled(rescaled, adjScale);
        }
        return ZERO;
    }

    private Decimal roundHalfUpToScale(int adjScale) {
        int scaleDiff = this.scale - adjScale;
        if (scaleDiff < 18) {
            long rescaledPlusNext = this.unscaled / POWERS[scaleDiff - 1];
            long rescaled = rescaledPlusNext / 10L;
            long nextDigit = rescaledPlusNext % 10L;
            int bump = nextDigit >= 5L ? 1 : (nextDigit <= -5L ? -1 : 0);
            return Decimal.ofScaled(rescaled + (long)bump, adjScale);
        }
        return Decimal.of(this.toBigDecimal().setScale(adjScale, RoundingMode.HALF_DOWN));
    }

    public Decimal roundToPrecision(int precision, RoundingMode roundingMode) {
        ArgChecker.notNegative(precision, "precision");
        if (precision >= 18) {
            return this;
        }
        return Decimal.ofRounded(this.toBigDecimal().round(new MathContext(precision, roundingMode)));
    }

    public boolean isZero() {
        return this.unscaled == 0L;
    }

    public Decimal abs() {
        return new Decimal(this.unscaled < 0L ? -this.unscaled : this.unscaled, this.scale);
    }

    public Decimal negated() {
        return new Decimal(-this.unscaled, this.scale);
    }

    public Decimal mapAsDouble(DoubleUnaryOperator fn) {
        return Decimal.of(fn.applyAsDouble(this.doubleValue()));
    }

    public Decimal mapAsBigDecimal(UnaryOperator<BigDecimal> fn) {
        return Decimal.of((BigDecimal)fn.apply(this.toBigDecimal()));
    }

    public double doubleValue() {
        return this.toBigDecimal().doubleValue();
    }

    public long longValue() {
        return this.unscaled / POWERS[this.scale];
    }

    public BigDecimal toBigDecimal() {
        return BigDecimal.valueOf(this.unscaled, this.scale);
    }

    public FixedScaleDecimal toFixedScale(int fixedScale) {
        return FixedScaleDecimal.of(this, fixedScale);
    }

    public String formatAtLeast(int minDecimalPlaces) {
        if (minDecimalPlaces < 0 || minDecimalPlaces > 18) {
            throw new IllegalArgumentException("Format requires decimal places between 0 and 18 inclusive");
        }
        return this.format0(Math.max(minDecimalPlaces, this.scale));
    }

    public String format(int decimalPlaces, RoundingMode roundingMode) {
        if (decimalPlaces < 0 || decimalPlaces > 18) {
            throw new IllegalArgumentException("Format requires decimal places between 0 and 18 inclusive");
        }
        return this.roundToScale(decimalPlaces, roundingMode).format0(decimalPlaces);
    }

    private String format0(int decimalPlaces) {
        long abs = Math.abs(this.unscaled);
        long power = POWERS[this.scale];
        long whole = abs / power;
        long prefixedFraction = abs % power + power;
        long paddedFraction = prefixedFraction * POWERS[decimalPlaces - this.scale];
        StringBuilder buf = new StringBuilder(40);
        if (this.unscaled < 0L) {
            buf.append('-');
        }
        buf.append(whole);
        if (decimalPlaces > 0) {
            buf.append('.');
            int pos = buf.length();
            buf.setLength(pos + decimalPlaces);
            for (int i = decimalPlaces + pos - 1; i >= pos; --i) {
                int value = (int)(paddedFraction % 10L);
                buf.setCharAt(i, (char)(value + 48));
                paddedFraction /= 10L;
            }
        }
        return buf.toString();
    }

    @Override
    public int compareTo(Decimal other) {
        if (this.scale == other.scale) {
            return Long.compare(this.unscaled, other.unscaled);
        }
        long power1 = POWERS[this.scale];
        long whole1 = this.unscaled / power1;
        long power2 = POWERS[other.scale];
        long whole2 = other.unscaled / power2;
        if (whole1 < whole2) {
            return -1;
        }
        if (whole1 > whole2) {
            return 1;
        }
        long fraction1 = this.unscaled % power1 * POWERS[18 - this.scale];
        long fraction2 = other.unscaled % power2 * POWERS[18 - other.scale];
        return Long.compare(fraction1, fraction2);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Decimal) {
            Decimal other = (Decimal)obj;
            return this.unscaled == other.unscaled && this.scale == other.scale;
        }
        return false;
    }

    public int hashCode() {
        return Long.hashCode(this.unscaled) ^ this.scale;
    }

    @ToString
    public String toString() {
        return this.format0(this.scale);
    }

    static {
        Decimal.POWERS[0] = 1L;
        for (int i = 1; i < POWERS.length; ++i) {
            Decimal.POWERS[i] = POWERS[i - 1] * 10L;
        }
        MATH_CONTEXT = new MathContext(18, RoundingMode.DOWN);
        ZERO = new Decimal(0L, 0);
        MAX_VALUE = new Decimal(999999999999999999L, 0);
        MIN_VALUE = new Decimal(-999999999999999999L, 0);
    }
}

