/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Decimal;
import com.opengamma.strata.collect.Percentage;
import java.math.RoundingMode;
import java.util.function.UnaryOperator;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public final class BasisPoints {
    public static final BasisPoints ZERO = new BasisPoints(Decimal.ZERO);
    private static final int MAX_SCALE = 8;
    private final Decimal amount;

    public static BasisPoints of(double basisPoints) {
        return BasisPoints.of(Decimal.of(basisPoints));
    }

    public static BasisPoints of(Decimal basisPoints) {
        return new BasisPoints(basisPoints);
    }

    public static BasisPoints fromDecimalForm(double decimal) {
        return BasisPoints.fromDecimalForm(Decimal.of(decimal));
    }

    public static BasisPoints fromDecimalForm(Decimal decimal) {
        return BasisPoints.of(decimal.movePoint(4));
    }

    public static BasisPoints fromPercentage(Percentage percentage) {
        return BasisPoints.of(percentage.valuePercent().movePoint(2));
    }

    @FromString
    public static BasisPoints parse(String str) {
        ArgChecker.notNull(str, "str");
        if (str.endsWith("bps")) {
            return BasisPoints.of(Decimal.of(str.substring(0, str.length() - 3).trim()));
        }
        return BasisPoints.of(Decimal.of(str.trim()));
    }

    private BasisPoints(Decimal basisPoints) {
        ArgChecker.notNull(basisPoints, "basisPoints");
        this.amount = basisPoints.roundToScale(8, RoundingMode.HALF_UP);
    }

    public Decimal valueBasisPoints() {
        return this.amount;
    }

    public Decimal toDecimalForm() {
        return this.amount.movePoint(-4);
    }

    public Percentage toPercentage() {
        return Percentage.fromBasisPoints(this);
    }

    public BasisPoints plus(BasisPoints other) {
        return new BasisPoints(this.amount.plus(other.amount));
    }

    public BasisPoints minus(BasisPoints other) {
        return new BasisPoints(this.amount.minus(other.amount));
    }

    public BasisPoints map(UnaryOperator<Decimal> mapper) {
        return new BasisPoints((Decimal)mapper.apply(this.amount));
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasisPoints) {
            BasisPoints other = (BasisPoints)obj;
            return this.amount.equals(other.amount);
        }
        return false;
    }

    public int hashCode() {
        return this.amount.hashCode();
    }

    @ToString
    public String toString() {
        return this.amount.toString() + "bps";
    }
}

