/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.clogproxy.client.connection;

import com.oceanbase.clogproxy.common.util.NetworkUtil;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connection {
    private static final Logger logger = LoggerFactory.getLogger(Connection.class);
    private Channel channel;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public Connection(Channel channel) {
        this.channel = channel;
    }

    public void close() {
        if (!this.closed.compareAndSet(false, true)) {
            logger.warn("connection already closed");
        }
        if (this.channel != null) {
            if (this.channel.isActive()) {
                try {
                    this.channel.close().addListener(this::logCloseResult).syncUninterruptibly();
                }
                catch (Exception e) {
                    logger.warn("close connection to remote address {} exception", (Object)NetworkUtil.parseRemoteAddress((Channel)this.channel), (Object)e);
                }
            }
            this.channel = null;
        }
    }

    private void logCloseResult(Future future) {
        if (future.isSuccess()) {
            if (logger.isInfoEnabled()) {
                logger.info("close connection to remote address {} success", (Object)NetworkUtil.parseRemoteAddress((Channel)this.channel));
            }
        } else {
            logger.warn("close connection to remote address {} fail", (Object)NetworkUtil.parseRemoteAddress((Channel)this.channel), (Object)future.cause());
        }
    }
}

