/*
 * Decompiled with CFR 0.152.
 */
package com.noelios.restlet.local;

import com.noelios.restlet.local.LocalClientHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import org.restlet.Client;
import org.restlet.data.LocalReference;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.InputRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.Variant;
import org.restlet.service.MetadataService;

public class ClapClientHelper
extends LocalClientHelper {
    public ClapClientHelper(Client client) {
        super(client);
        this.getProtocols().add(Protocol.CLAP);
    }

    public void handle(Request request, Response response) {
        String scheme = request.getResourceRef().getScheme();
        request.getResourceRef().normalize();
        if (scheme.equalsIgnoreCase(Protocol.CLAP.getSchemeName())) {
            LocalReference cr = new LocalReference(request.getResourceRef());
            if (cr.getClapAuthorityType() == 2) {
                this.handleClassLoader(request, response, ((Object)((Object)this)).getClass().getClassLoader());
            } else if (cr.getClapAuthorityType() == 3) {
                this.handleClassLoader(request, response, ClassLoader.getSystemClassLoader());
            } else if (cr.getClapAuthorityType() == 4) {
                this.handleClassLoader(request, response, Thread.currentThread().getContextClassLoader());
            }
        } else {
            throw new IllegalArgumentException("Protocol \"" + scheme + "\" not supported by the connector. Only CLAP is supported.");
        }
    }

    protected void handleClassLoader(Request request, Response response, ClassLoader classLoader) {
        MetadataService metadataService = this.getMetadataService(request);
        if (request.getMethod().equals((Object)Method.GET) || request.getMethod().equals((Object)Method.HEAD)) {
            File file;
            URL url;
            String path = request.getResourceRef().getPath();
            if (path != null && path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((url = classLoader.getResource(path)) != null && url.getProtocol().equals("file") && (file = new File(url.getFile())).isDirectory()) {
                url = null;
            }
            if (url != null) {
                try {
                    InputRepresentation output = new InputRepresentation(url.openStream(), metadataService.getDefaultMediaType());
                    String name = path.substring(path.lastIndexOf(47) + 1);
                    this.updateMetadata(metadataService, name, (Variant)output);
                    response.setEntity((Representation)output);
                    response.setStatus(Status.SUCCESS_OK);
                }
                catch (IOException ioe) {
                    this.getLogger().log(Level.WARNING, "Unable to open the representation's input stream", ioe);
                    response.setStatus(Status.SERVER_ERROR_INTERNAL);
                }
            } else {
                response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        } else {
            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
            response.getAllowedMethods().add(Method.GET);
            response.getAllowedMethods().add(Method.HEAD);
        }
    }
}

