package com.newrelic.api.agent;

import java.util.Map;

/**
 * Used to send custom events to Insights.
 *
 */
public interface Insights {

    /**
     * Sends an Insights event for the current application.
     * @param eventType Must match /^[a-zA-Z0-9:_ ]+$/, be non-null, and less than 256 chars.
     * @param attributes A map of event data. Each key should be a String and each value should be a String, Number, or Boolean.
     * @since 3.13.0 
     */
    void recordCustomEvent(String eventType, Map<String, Object> attributes);
}
