/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.agent.deps.com.google.common.collect.Lists;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.api.agent.weaver.MatchType;
import com.newrelic.api.agent.weaver.SkipIfPresent;
import com.newrelic.api.agent.weaver.Weave;
import com.newrelic.api.agent.weaver.WeaveWithAnnotation;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.violation.WeaveViolation;
import com.newrelic.weave.violation.WeaveViolationType;
import java.util.List;
import java.util.Set;

public class WeaveClassInfo {
    public static final String SKIP_IF_PRESENT_DESC = Type.getType(SkipIfPresent.class).getDescriptor();
    public static final String WEAVE_DESC = Type.getType(Weave.class).getDescriptor();
    public static final String WEAVE_ANNOTATED_TYPE_DESC = Type.getType(WeaveWithAnnotation.class).getDescriptor();
    private final List<WeaveViolation> violations = Lists.newArrayList();
    private MatchType matchType = null;
    private String originalName;
    private boolean skipIfPresent;
    private final Set<String> requiredClassAnnotations = Sets.newHashSet();
    private final Set<String> requiredMethodAnnotations = Sets.newHashSet();

    public WeaveClassInfo(ClassNode weaveClassNode) {
        if (weaveClassNode.version > WeaveUtils.RUNTIME_MAX_SUPPORTED_CLASS_VERSION) {
            this.violations.add(new WeaveViolation(WeaveViolationType.INCOMPATIBLE_BYTECODE_VERSION, weaveClassNode.name));
        }
        this.matchType = null;
        if (weaveClassNode.visibleAnnotations != null) {
            for (AnnotationNode annotationNode : weaveClassNode.visibleAnnotations) {
                if (annotationNode.desc.equals(WEAVE_DESC)) {
                    this.matchType = MatchType.ExactClass;
                    this.originalName = weaveClassNode.name;
                    this.processAnnotationValues(annotationNode, null);
                    continue;
                }
                if (annotationNode.desc.equals(SKIP_IF_PRESENT_DESC)) {
                    this.skipIfPresent = true;
                    this.originalName = weaveClassNode.name;
                    this.processAnnotationValues(annotationNode, null);
                    continue;
                }
                if (!annotationNode.desc.equals(WEAVE_ANNOTATED_TYPE_DESC)) continue;
                this.matchType = MatchType.ExactClass;
                this.processAnnotationValues(annotationNode, this.requiredClassAnnotations);
            }
        }
        for (MethodNode methodNode : weaveClassNode.methods) {
            if (methodNode.visibleAnnotations == null) continue;
            for (AnnotationNode annotationNode : methodNode.visibleAnnotations) {
                if (!annotationNode.desc.equals(WEAVE_ANNOTATED_TYPE_DESC)) continue;
                this.processAnnotationValues(annotationNode, this.requiredMethodAnnotations);
            }
        }
    }

    private void processAnnotationValues(AnnotationNode annotationNode, Set<String> annotationWeavingType) {
        if (annotationNode.values != null) {
            for (int i = 0; i < annotationNode.values.size(); i += 2) {
                if ("type".equals(annotationNode.values.get(i))) {
                    String[] typeParameters = (String[])annotationNode.values.get(i + 1);
                    if (!Type.getType(MatchType.class).getDescriptor().equals(typeParameters[0])) continue;
                    this.matchType = MatchType.valueOf(typeParameters[1]);
                    continue;
                }
                if ("originalName".equals(annotationNode.values.get(i))) {
                    this.originalName = WeaveUtils.getClassInternalName(String.valueOf(annotationNode.values.get(i + 1)));
                    continue;
                }
                if (annotationWeavingType == null || !"annotationClasses".equals(annotationNode.values.get(i))) continue;
                List requiredAnnotationClasses = (List)annotationNode.values.get(i + 1);
                annotationWeavingType.addAll(requiredAnnotationClasses);
            }
        }
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public List<WeaveViolation> getViolations() {
        return this.violations;
    }

    public boolean isSkipIfPresent() {
        return this.skipIfPresent;
    }

    public Set<String> getRequiredClassAnnotations() {
        return this.requiredClassAnnotations;
    }

    public Set<String> getRequiredMethodAnnotations() {
        return this.requiredMethodAnnotations;
    }
}

