/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave.utils;

import com.newrelic.weave.weavepackage.WeavePackage;
import com.newrelic.weave.weavepackage.WeavePackageConfig;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;

public final class PrintManifestClasses {
    private PrintManifestClasses() {
    }

    public static void main(String[] args) {
        String jarLoc = null;
        String attribteName = null;
        boolean argsAreValid = false;
        if (args.length == 2) {
            jarLoc = args[0];
            attribteName = args[1];
            boolean bl = argsAreValid = attribteName.equals("Reference-Classes") || attribteName.equals("Illegal-Classes") || attribteName.equals("Weave-Classes") || attribteName.equals("Weave-Methods") || attribteName.equals("Class-Required-Annotations") || attribteName.equals("Method-Required-Annotations");
        }
        if (argsAreValid) {
            try {
                WeavePackage weavePackage = PrintManifestClasses.createWeavePackage(jarLoc);
                if (attribteName.equals("Weave-Classes")) {
                    for (String originalName : weavePackage.getMatchTypes().keySet()) {
                        System.out.print(originalName + ",");
                    }
                } else if (attribteName.equals("Weave-Methods")) {
                    for (String methodSignature : weavePackage.getMethodSignatures()) {
                        System.out.print("\"" + methodSignature + "\",");
                    }
                } else if (attribteName.equals("Illegal-Classes")) {
                    for (String skipName : weavePackage.getIllegalClasses()) {
                        System.out.print(skipName + ",");
                    }
                } else if (attribteName.equals("Reference-Classes")) {
                    for (String referencedClass : weavePackage.getReferencedClassNames()) {
                        System.out.print(referencedClass + ",");
                    }
                } else if (attribteName.equals("Class-Required-Annotations")) {
                    for (String requiredClassAnnotations : weavePackage.getAllRequiredAnnotationClasses()) {
                        System.out.print(requiredClassAnnotations + ",");
                    }
                } else if (attribteName.equals("Method-Required-Annotations")) {
                    for (String requiredMethodAnnotations : weavePackage.getAllRequiredMethodAnnotationClasses()) {
                        System.out.print(requiredMethodAnnotations + ",");
                    }
                }
                System.exit(0);
            }
            catch (Exception e) {
                System.err.println("Unexpected error while printing manifest entries");
                e.printStackTrace();
            }
        } else {
            PrintManifestClasses.help();
        }
        System.exit(1);
    }

    private static void help() {
        System.out.println("Print weave, illegal, or reference class names for a weave package jar.");
        System.out.println("Usage:  java -cp newrelic-weaver.jar PrintManifestClasses [/weave/module.jar] [attribute]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WeavePackage createWeavePackage(String jarLoc) throws Exception {
        ZipInputStream jarInStream = null;
        try {
            URL weavePackageJarLoc = new File(jarLoc).toURI().toURL();
            WeavePackageConfig config = WeavePackageConfig.builder().url(weavePackageJarLoc).build();
            jarInStream = new JarInputStream(weavePackageJarLoc.openStream());
            WeavePackage weavePackage = WeavePackage.createWeavePackage((JarInputStream)jarInStream, config);
            return weavePackage;
        }
        finally {
            if (null != jarInStream) {
                try {
                    jarInStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

