/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.weave;

import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.deps.com.google.common.collect.Sets;
import com.newrelic.agent.deps.org.objectweb.asm.ClassVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.FieldVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Label;
import com.newrelic.agent.deps.org.objectweb.asm.MethodVisitor;
import com.newrelic.agent.deps.org.objectweb.asm.Type;
import com.newrelic.agent.deps.org.objectweb.asm.commons.Method;
import com.newrelic.agent.deps.org.objectweb.asm.commons.RemappingClassAdapter;
import com.newrelic.agent.deps.org.objectweb.asm.commons.SimpleRemapper;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AbstractInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.AnnotationNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.ClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.FieldNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InnerClassNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.InsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.LabelNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.LocalVariableNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodInsnNode;
import com.newrelic.agent.deps.org.objectweb.asm.tree.MethodNode;
import com.newrelic.weave.CallOriginalReplacement;
import com.newrelic.weave.ClassMatch;
import com.newrelic.weave.ErrorTrapWeaveMethodsProcessor;
import com.newrelic.weave.MethodKey;
import com.newrelic.weave.MethodProcessors;
import com.newrelic.weave.PreparedExtension;
import com.newrelic.weave.utils.SynchronizedClassNode;
import com.newrelic.weave.utils.WeaveUtils;
import com.newrelic.weave.weavepackage.ErrorTrapHandler;
import com.newrelic.weave.weavepackage.ExtensionClassTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PreparedMatch {
    private static final String ANONYMOUS_CLASS_FORMAT = "com/newrelic/weave/%s_%d_nr_anon";
    public static final String NR_WEAVE = "_nr_weave_";
    private final String originalName;
    private final String weaveName;
    private final String weaveSuperName;
    private final AnnotationInfo weaveClassAnnotations;
    private final Map<String, AnnotationInfo> matchedWeaveFieldAnnotations;
    private final Set<String> newInnerClasses;
    private final Set<String> newFields;
    private final Set<String> matchedFields;
    private final Set<MethodNode> newMethods = Sets.newHashSet();
    private final Map<String, String> anonymousInnerClassTypeMap = Maps.newHashMap();
    private final Map<Method, MethodNode> preparedMatchedMethods = Maps.newHashMap();
    private final PreparedExtension extension;
    private final boolean removeLineNumbers;
    private final Map<String, AnnotationNode> getClassAnnotationMap;
    private final Map<MethodKey, Map<String, AnnotationNode>> getMethodAnnotationMap;
    private final Set<MethodNode> classAnnotationGetters;
    private final Map<MethodKey, Map<String, AnnotationNode>> methodAnnotationGetters;
    private final Map<String, ClassNode> annotationProxyClasses = Maps.newHashMap();
    private MethodNode preparedWeaveAllConstructor;
    private ClassNode errorHandleClassNode = ErrorTrapHandler.NO_ERROR_TRAP_HANDLER;
    private ClassNode extensionClassTemplate = ExtensionClassTemplate.DEFAULT_EXTENSION_TEMPLATE;

    private PreparedMatch(ClassMatch match, ClassNode errorHandleClassNode, ClassNode extensionTemplate, boolean removeLineNumbers) {
        this(match, extensionTemplate, removeLineNumbers);
        MethodNode method;
        if (errorHandleClassNode != ErrorTrapHandler.NO_ERROR_TRAP_HANDLER && null != (method = WeaveUtils.getMethodNode(errorHandleClassNode, "onWeaverThrow", "(Ljava/lang/Throwable;)V")) && ErrorTrapHandler.class.getCanonicalName().replace('.', '/').equals(errorHandleClassNode.superName) && (method.access & 8) != 0) {
            this.errorHandleClassNode = errorHandleClassNode;
        }
    }

    private PreparedMatch(ClassMatch match, ClassNode extensionTemplate, boolean removeLineNumbers) {
        this.removeLineNumbers = removeLineNumbers;
        this.originalName = match.getOriginal().name;
        this.weaveName = match.getWeave().name;
        this.weaveSuperName = match.getWeave().superName;
        this.weaveClassAnnotations = new AnnotationInfo(match.getWeave().visibleAnnotations, match.getWeave().invisibleAnnotations);
        this.matchedWeaveFieldAnnotations = Maps.newHashMap();
        for (String fieldName : match.getMatchedFields()) {
            FieldNode weaveField = WeaveUtils.findRequiredMatch(match.getWeave().fields, fieldName);
            AnnotationInfo annotationInfo = new AnnotationInfo(weaveField.visibleAnnotations, weaveField.invisibleAnnotations);
            this.matchedWeaveFieldAnnotations.put(fieldName, annotationInfo);
        }
        this.newInnerClasses = match.getNewInnerClasses();
        this.extensionClassTemplate = extensionTemplate;
        this.newFields = match.getNewFields();
        this.matchedFields = match.getMatchedFields();
        this.getClassAnnotationMap = match.getClassAnnotationMap();
        this.classAnnotationGetters = match.getClassAnnotationGetters();
        this.methodAnnotationGetters = match.getMethodAnnotationMap();
        this.getMethodAnnotationMap = match.getMethodAnnotationMap();
        MethodNode weavesAllMethod = match.getWeavesAllMethod();
        for (Method newMethod : match.getNewMethods()) {
            MethodNode newMethodNode;
            if (weavesAllMethod != null && weavesAllMethod.name.equals(newMethod.getName()) && weavesAllMethod.desc.equals(newMethod.getDescriptor()) || (newMethodNode = WeaveUtils.findMatch(match.getWeave().methods, newMethod)) == null) continue;
            this.newMethods.add(newMethodNode);
        }
        if (!match.getNewInnerClasses().isEmpty()) {
            for (String newClassName : match.getNewInnerClasses()) {
                for (InnerClassNode innerClassNode : match.getWeave().innerClasses) {
                    if (!innerClassNode.name.equals(newClassName) || !WeaveUtils.isAnonymousInnerClass(innerClassNode)) continue;
                    String anonName = String.format(ANONYMOUS_CLASS_FORMAT, newClassName, System.identityHashCode(this));
                    this.anonymousInnerClassTypeMap.put(newClassName, anonName);
                }
            }
        }
        this.extension = match.getNewFields().size() > 0 ? new PreparedExtension(match, this.extensionClassTemplate) : null;
    }

    public static PreparedMatch prepare(ClassMatch match, ClassNode errorHandle, ClassNode extensionTemplate, boolean removeLineNumbers) {
        PreparedMatch result = new PreparedMatch(match, errorHandle, extensionTemplate, removeLineNumbers);
        result.prepare(match);
        return result;
    }

    private void prepare(ClassMatch match) {
        if (match.weavesAllMethods()) {
            this.preparedMatchedMethods.putAll(this.buildWeaveAllMatches(match));
        }
        for (Method matchedMethod : match.getMatchedMethods()) {
            this.preparedMatchedMethods.put(matchedMethod, this.prepare(match, WeaveUtils.findMatch(match.getWeave().methods, matchedMethod), match.getOriginalReplacements()));
        }
        if (match.isInterfaceMatch() || match.weavesAllConstructors()) {
            this.preparedWeaveAllConstructor = this.prepare(match, WeaveUtils.findMatch(match.getWeave().methods, WeaveUtils.DEFAULT_CONSTRUCTOR), match.getOriginalReplacements());
        }
    }

    private Map<Method, MethodNode> buildWeaveAllMatches(ClassMatch match) {
        HashMap<Method, MethodNode> weavesAllMatches = Maps.newHashMap();
        for (Map.Entry<MethodNode, MethodNode> weaveAllMatch : match.getWeaveAllMatches().entrySet()) {
            MethodNode originalMethod = weaveAllMatch.getKey();
            MethodNode weavesAllMethodsNode = weaveAllMatch.getValue();
            MethodNode weaveCode = WeaveUtils.copy(weavesAllMethodsNode);
            weaveCode.name = originalMethod.name;
            weaveCode.desc = originalMethod.desc;
            weaveCode.signature = originalMethod.signature;
            weaveCode.access = originalMethod.access;
            weaveCode.exceptions = originalMethod.exceptions;
            weaveCode.parameters = originalMethod.parameters;
            weaveCode.maxStack += originalMethod.maxStack;
            weaveCode.maxLocals += originalMethod.maxLocals;
            ArrayList<LocalVariableNode> localVariableNodes = new ArrayList<LocalVariableNode>();
            boolean isStatic = (originalMethod.access & 8) != 0;
            final int argumentsSize = (Type.getArgumentsAndReturnSizes(originalMethod.desc) >> 2) - (isStatic ? 1 : 0);
            for (LocalVariableNode localVariableNode : originalMethod.localVariables) {
                if (localVariableNode.index >= argumentsSize) continue;
                localVariableNodes.add(localVariableNode);
            }
            for (LocalVariableNode localVariableNode : weaveCode.localVariables) {
                localVariableNode.name = NR_WEAVE + localVariableNode.name;
                localVariableNodes.add(localVariableNode);
            }
            weaveCode.localVariables.clear();
            weaveCode.localVariables.addAll(localVariableNodes);
            MethodNode result = WeaveUtils.newMethodNode(weaveCode);
            weaveCode.accept(new MethodVisitor(393216, result){

                @Override
                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                    if (name.startsWith(PreparedMatch.NR_WEAVE)) {
                        super.visitLocalVariable(name, desc, signature, start, end, index + argumentsSize);
                    } else {
                        super.visitLocalVariable(name, desc, signature, start, end, index);
                    }
                }

                @Override
                public void visitVarInsn(int opcode, int var) {
                    super.visitVarInsn(opcode, var + argumentsSize);
                }

                @Override
                public void visitIincInsn(int var, int increment) {
                    super.visitIincInsn(var + argumentsSize, increment);
                }

                @Override
                public void visitParameter(String name, int access) {
                }
            });
            result.instructions.add(new MethodInsnNode(184, WeaveUtils.WEAVER_TYPE.getInternalName(), WeaveUtils.CALL_ORIGINAL_METHOD.getName(), WeaveUtils.CALL_ORIGINAL_METHOD.getDescriptor(), false));
            Type returnType = Type.getReturnType(originalMethod.desc);
            if (Type.VOID_TYPE.equals(returnType)) {
                result.instructions.add(new InsnNode(87));
            } else {
                MethodInsnNode unboxingInstruction;
                String returnTypeClassInternalName = WeaveUtils.getClassInternalName(returnType);
                AbstractInsnNode checkCastInstruction = WeaveUtils.getCheckCastInstruction(returnTypeClassInternalName);
                if (checkCastInstruction != null) {
                    result.instructions.add(checkCastInstruction);
                }
                if ((unboxingInstruction = WeaveUtils.getUnboxingInstruction(returnType)) != null) {
                    result.instructions.add(unboxingInstruction);
                }
            }
            result.instructions.add(new InsnNode(WeaveUtils.getReturnOpcodeForReturnType(returnType)));
            CallOriginalReplacement replacement = CallOriginalReplacement.replace(match.getWeave().name, result);
            Method method = new Method(originalMethod.name, originalMethod.desc);
            if (this.classAnnotationGetters.contains(weavesAllMethodsNode)) {
                this.classAnnotationGetters.add(result);
            }
            if (this.methodAnnotationGetters.containsKey(new MethodKey(weavesAllMethodsNode))) {
                this.classAnnotationGetters.add(result);
            }
            MethodNode preparedMethod = this.prepare(match, result, Collections.singletonMap(method, replacement));
            weavesAllMatches.put(method, preparedMethod);
        }
        return weavesAllMatches;
    }

    private MethodNode prepare(ClassMatch classMatch, MethodNode matchedMethod, Map<Method, CallOriginalReplacement> callOriginalReplacementMap) {
        MethodNode prepared = MethodProcessors.removeJSRInstructions(matchedMethod);
        LabelNode startOfOriginal = null;
        LabelNode endOfOriginal = null;
        if (prepared.name.equals("<init>")) {
            prepared = MethodProcessors.extractConstructorInstructionsAfterInit(prepared);
            prepared.instructions.resetLabels();
            prepared = ErrorTrapWeaveMethodsProcessor.writeErrorTrap(prepared, this.errorHandleClassNode, startOfOriginal, endOfOriginal);
            prepared = MethodProcessors.inlineMethods(this.errorHandleClassNode.name, ErrorTrapHandler.NO_ERROR_TRAP_HANDLER == this.errorHandleClassNode ? Collections.emptySet() : this.errorHandleClassNode.methods, this.weaveName, prepared);
            prepared.instructions.resetLabels();
        } else {
            CallOriginalReplacement replacementResult = callOriginalReplacementMap.get(new Method(prepared.name, prepared.desc));
            if (replacementResult != null && replacementResult.isSuccess()) {
                startOfOriginal = replacementResult.getStartOfOriginalMethodLabelNode();
                endOfOriginal = replacementResult.getEndOfOriginalMethodLabelNode();
                prepared = replacementResult.getResult();
                prepared = ErrorTrapWeaveMethodsProcessor.writeErrorTrap(prepared, this.errorHandleClassNode, startOfOriginal, endOfOriginal);
                prepared = MethodProcessors.inlineMethods(this.errorHandleClassNode.name, ErrorTrapHandler.NO_ERROR_TRAP_HANDLER == this.errorHandleClassNode ? Collections.emptySet() : this.errorHandleClassNode.methods, this.weaveName, prepared);
                prepared.instructions.resetLabels();
            }
        }
        Collection<AnnotationNode> classAnnotations = this.getClassAnnotationMap.values();
        List<AnnotationNode> methodAnnotations = Collections.emptyList();
        Map<String, AnnotationNode> methodAnnotationsMap = this.getMethodAnnotationMap.get(new MethodKey(prepared));
        if (methodAnnotationsMap != null) {
            methodAnnotations = methodAnnotationsMap.values();
        }
        prepared = MethodProcessors.renameGetAnnotationCalls(prepared, classMatch.getOriginal(), classAnnotations, methodAnnotations, this.annotationProxyClasses);
        if (this.removeLineNumbers) {
            prepared = MethodProcessors.removeLineNumbers(prepared);
        }
        if (!this.newMethods.isEmpty()) {
            prepared = MethodProcessors.inlineMethods(this.weaveName, this.newMethods, this.weaveName, prepared);
        }
        prepared = MethodProcessors.updateConstructorArgsForInnerClass(prepared, this.weaveName, this.originalName, classMatch.getNewInnerClasses());
        if (!this.anonymousInnerClassTypeMap.isEmpty()) {
            prepared = MethodProcessors.updateTypes(prepared, this.anonymousInnerClassTypeMap);
        }
        if (this.extension != null) {
            prepared = this.extension.rewriteNewFieldCalls(prepared);
        }
        return prepared;
    }

    public ClassNode prepareNewInnerClass(ClassNode newInnerClassNode) {
        if (null != this.extension && null != newInnerClassNode.methods) {
            for (MethodNode method : newInnerClassNode.methods) {
                this.extension.rewriteNewFieldCalls(method);
            }
        }
        SynchronizedClassNode anonClass = new SynchronizedClassNode(393216);
        HashMap<String, String> typeMap = Maps.newHashMap(this.anonymousInnerClassTypeMap);
        typeMap.put(this.weaveName, this.originalName);
        RemappingClassAdapter remapper = new RemappingClassAdapter(anonClass, new SimpleRemapper(typeMap));
        ClassVisitor rewriteNewVisitor = new ClassVisitor(393216, remapper){

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                super.visit(version, PreparedMatch.makePublic(access), name, signature, superName, interfaces);
            }

            @Override
            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                return super.visitField(PreparedMatch.makePublic(access), name, desc, signature, value);
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return super.visitMethod(PreparedMatch.makePublic(access), name, desc, signature, exceptions);
            }
        };
        newInnerClassNode.accept(rewriteNewVisitor);
        return anonClass;
    }

    private static int makePublic(int access) {
        access |= 1;
        return access &= 0xFFFFFFF9;
    }

    public String nameNewInnerClass(String originalName) {
        String anonName = this.anonymousInnerClassTypeMap.get(originalName);
        return anonName == null ? originalName : anonName;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getWeaveName() {
        return this.weaveName;
    }

    public String getWeaveSuperName() {
        return this.weaveSuperName;
    }

    public Map<Method, MethodNode> getPreparedMatchedMethods() {
        return this.preparedMatchedMethods;
    }

    public Set<String> getNewFields() {
        return this.newFields;
    }

    public Set<String> getMatchedFields() {
        return this.matchedFields;
    }

    public MethodNode getPreparedWeaveAllConstructor() {
        return this.preparedWeaveAllConstructor;
    }

    public PreparedExtension getExtension() {
        return this.extension;
    }

    public AnnotationInfo getWeaveClassAnnotations() {
        return this.weaveClassAnnotations;
    }

    public Map<String, AnnotationInfo> getMatchedWeaveFieldAnnotations() {
        return this.matchedWeaveFieldAnnotations;
    }

    public Set<String> getNewInnerClasses() {
        return this.newInnerClasses;
    }

    public Map<String, ClassNode> getAnnotationProxyClasses() {
        return this.annotationProxyClasses;
    }

    static class AnnotationInfo {
        final List<AnnotationNode> visibleAnnotations;
        final List<AnnotationNode> invisibleAnnotations;

        AnnotationInfo(List<AnnotationNode> visibleAnnotations, List<AnnotationNode> invisibleAnnotations) {
            this.visibleAnnotations = visibleAnnotations;
            this.invisibleAnnotations = invisibleAnnotations;
        }
    }
}

