/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent.tracing;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.DistributedTracePayload;
import com.newrelic.agent.bridge.NoOpNewRelicTracer;
import com.newrelic.agent.bridge.TransportType;
import com.newrelic.agent.deps.com.google.common.base.Charsets;
import com.newrelic.agent.deps.org.json.simple.JSONObject;
import com.newrelic.agent.deps.org.json.simple.parser.JSONParser;
import com.newrelic.agent.trace.TransactionGuidFactory;
import com.newrelic.api.agent.Token;
import com.newrelic.api.agent.tracing.NewRelicActiveSpan;
import com.newrelic.api.agent.tracing.NewRelicSpan;
import com.newrelic.api.agent.tracing.NewRelicSpanBuilder;
import com.newrelic.api.agent.tracing.NewRelicSpanContext;
import com.newrelic.org.apache.axis.encoding.Base64;
import io.opentracing.ActiveSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.nio.ByteBuffer;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class NewRelicTracer
implements com.newrelic.api.agent.NewRelicTracer {
    public static final com.newrelic.api.agent.NewRelicTracer INSTANCE = new NewRelicTracer();
    private static final ThreadLocal<NewRelicActiveSpan> activeSpanThreadLocal = new ThreadLocal();

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new NewRelicSpanBuilder(operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        if (spanContext == null || !(spanContext instanceof NewRelicSpanContext)) {
            AgentBridge.getAgent().getLogger().log(Level.FINE, "Ignoring call to inject due to null or incorrect span context type: {0}", (Object)spanContext);
            return;
        }
        NewRelicSpanContext span = (NewRelicSpanContext)spanContext;
        Transaction transaction = span.getTransactionOrNull();
        if (transaction == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINE, "Ignoring call to inject due to missing transaction on NewRelicSpan: {0}", (Object)span);
            return;
        }
        DistributedTracePayload distributedTracePayload = transaction.createDistributedTracePayload(null);
        if (distributedTracePayload == null) {
            return;
        }
        String baggageHeaderValue = this.baggageToJson(span.baggageItems());
        if (format.equals((Object)Format.Builtin.TEXT_MAP)) {
            ((TextMap)carrier).put("X-NewRelic-Trace", distributedTracePayload.text());
            if (baggageHeaderValue != null) {
                ((TextMap)carrier).put("X-NewRelic-Baggage", baggageHeaderValue);
            }
        } else if (format.equals((Object)Format.Builtin.HTTP_HEADERS)) {
            ((TextMap)carrier).put("X-NewRelic-Trace", distributedTracePayload.httpSafe());
            if (baggageHeaderValue != null) {
                ((TextMap)carrier).put("X-NewRelic-Baggage", Base64.encode(baggageHeaderValue.getBytes(Charsets.UTF_8)));
            }
        } else if (format.equals((Object)Format.Builtin.BINARY)) {
            byte[] payloadBytes = distributedTracePayload.text().getBytes(Charsets.UTF_8);
            ((ByteBuffer)carrier).putInt(payloadBytes.length);
            ((ByteBuffer)carrier).put(payloadBytes);
            if (baggageHeaderValue != null) {
                ((ByteBuffer)carrier).put(baggageHeaderValue.getBytes(Charsets.UTF_8));
            }
        } else {
            AgentBridge.getAgent().getLogger().log(Level.FINE, "Invalid or missing inject format: {0}", format);
        }
    }

    private String baggageToJson(Iterable<Map.Entry<String, String>> baggage) {
        if (baggage == null) {
            return null;
        }
        JSONObject baggageJson = new JSONObject();
        for (Map.Entry<String, String> entry : baggage) {
            baggageJson.put(entry.getKey(), entry.getValue());
        }
        return baggageJson.toJSONString();
    }

    private Map<String, String> jsonToBaggage(String json) {
        ConcurrentHashMap<String, String> baggage = new ConcurrentHashMap<String, String>();
        if (json != null) {
            JSONParser parser = new JSONParser();
            try {
                JSONObject baggageJson = (JSONObject)parser.parse(json);
                Iterator iterator = baggageJson.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry object;
                    Map.Entry entry = object = iterator.next();
                    baggage.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (Throwable t) {
                AgentBridge.getAgent().getLogger().log(Level.FINE, "Unable to parse incoming baggage: {0}", (Object)json);
            }
        }
        return baggage;
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        String msg;
        Transaction transaction = Transaction.getTransaction(false);
        if (transaction == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINE, "extract() called outside of a Transaction.");
            return NoOpNewRelicTracer.INSTANCE;
        }
        String payload = null;
        String baggageValue = null;
        if (format.equals((Object)Format.Builtin.TEXT_MAP)) {
            for (Map.Entry entry : (TextMap)carrier) {
                if (((String)entry.getKey()).equalsIgnoreCase("X-NewRelic-Trace")) {
                    payload = (String)entry.getValue();
                    continue;
                }
                if (!((String)entry.getKey()).equalsIgnoreCase("X-NewRelic-Baggage")) continue;
                baggageValue = (String)entry.getValue();
            }
        } else if (format.equals((Object)Format.Builtin.HTTP_HEADERS)) {
            if (((TextMap)carrier).iterator() == null) {
                throw new IllegalArgumentException("Invalid carrier");
            }
            for (Map.Entry entry : (TextMap)carrier) {
                if (((String)entry.getKey()).equalsIgnoreCase("X-NewRelic-Trace")) {
                    payload = new String(Base64.decode((String)entry.getValue()), Charsets.UTF_8);
                    continue;
                }
                if (!((String)entry.getKey()).equalsIgnoreCase("X-NewRelic-Baggage")) continue;
                baggageValue = new String(Base64.decode((String)entry.getValue()), Charsets.UTF_8);
            }
        } else if (format.equals((Object)Format.Builtin.BINARY)) {
            ByteBuffer buffer = (ByteBuffer)carrier;
            if (buffer == null) {
                throw new IllegalArgumentException("Invalid carrier");
            }
            int payloadLength = buffer.getInt();
            byte[] payloadBytes = new byte[payloadLength];
            buffer.get(payloadBytes);
            payload = new String(payloadBytes, Charsets.UTF_8);
            int remaining = buffer.remaining();
            if (remaining > 0) {
                byte[] baggageBytes = new byte[remaining];
                buffer.get(baggageBytes);
                baggageValue = new String(baggageBytes, Charsets.UTF_8);
            }
        } else {
            String msg2 = MessageFormat.format("Invalid or missing extract format: {0}", format);
            AgentBridge.getAgent().getLogger().log(Level.FINE, msg2);
            throw new IllegalArgumentException(msg2);
        }
        if (payload == null) {
            msg = MessageFormat.format("Unable to extract payload from carrier: {0}", carrier);
            AgentBridge.getAgent().getLogger().log(Level.FINE, msg);
            throw new IllegalArgumentException(msg);
        }
        transaction.acceptDistributedTracePayload(TransportType.HTTP, payload);
        if (transaction.getInboundDistributedTracePayload() == null) {
            msg = MessageFormat.format("{0} header value was not accepted", "X-NewRelic-Trace");
            throw new IllegalArgumentException(msg);
        }
        Map<String, String> baggage = this.jsonToBaggage(baggageValue);
        return new NewRelicSpanContext(TransactionGuidFactory.generateGuid(), transaction.getGuid(), transaction.getInboundDistributedTracePayload().tripId, baggage, transaction);
    }

    public ActiveSpan activeSpan() {
        return (ActiveSpan)activeSpanThreadLocal.get();
    }

    public ActiveSpan makeActive(Span span) {
        if (span instanceof NoOpNewRelicTracer) {
            return ((NoOpNewRelicTracer)span).makeActive(span);
        }
        if (span == null || !(span instanceof NewRelicSpan)) {
            AgentBridge.getAgent().getLogger().log(Level.FINE, "Ignoring call to makeActive due to null span or incorrect span type: {0}. Returning null.", (Object)span);
            return null;
        }
        com.newrelic.agent.bridge.Token token = null;
        Transaction transaction = Transaction.getTransaction(false);
        if (transaction != null) {
            token = transaction.getToken();
        }
        return new NewRelicActiveSpan(activeSpanThreadLocal, (NewRelicSpan)span, new AtomicInteger(1), (Token)token);
    }
}

