/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent.tracing;

import com.newrelic.agent.DistributedTracePayloadImpl;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.bridge.NoOpNewRelicTracer;
import com.newrelic.agent.trace.TransactionGuidFactory;
import com.newrelic.api.agent.tracing.NewRelicSpan;
import com.newrelic.api.agent.tracing.NewRelicSpanContext;
import com.newrelic.api.agent.tracing.NewRelicTracer;
import io.opentracing.ActiveSpan;
import io.opentracing.BaseSpan;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class NewRelicSpanBuilder
implements com.newrelic.api.agent.NewRelicSpanBuilder {
    private final String operationName;
    private SpanContext parent;
    private Map<String, Object> tags;
    private long startTimeInMillis;
    private long startTimeInNanos;
    private boolean ignoreActiveSpan = false;

    public NewRelicSpanBuilder(String operationName) {
        this.operationName = operationName;
    }

    public Tracer.SpanBuilder asChildOf(SpanContext parent) {
        return this.addReference("child_of", parent);
    }

    public Tracer.SpanBuilder asChildOf(BaseSpan<?> parent) {
        return this.asChildOf(parent.context());
    }

    public Tracer.SpanBuilder addReference(String referenceType, SpanContext referencedContext) {
        if (this.parent == null && (referenceType.equals("child_of") || referenceType.equals("follows_from"))) {
            this.parent = referencedContext;
        }
        return this;
    }

    public Tracer.SpanBuilder ignoreActiveSpan() {
        this.ignoreActiveSpan = true;
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, String value) {
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, Object>();
        }
        this.tags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, boolean value) {
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, Object>();
        }
        this.tags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withTag(String key, Number value) {
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, Object>();
        }
        this.tags.put(key, value);
        return this;
    }

    public Tracer.SpanBuilder withStartTimestamp(long microseconds) {
        this.startTimeInMillis = TimeUnit.MICROSECONDS.toMillis(microseconds);
        this.startTimeInNanos = TimeUnit.MICROSECONDS.toNanos(microseconds);
        return this;
    }

    public ActiveSpan startActive() {
        return NewRelicTracer.INSTANCE.makeActive(this.startManual());
    }

    public Span startManual() {
        long startTimeInNanos;
        ActiveSpan activeSpan = AgentBridge.getTracer().activeSpan();
        Transaction transaction = Transaction.getTransaction(false);
        if (transaction != null && !transaction.sampled(true) || transaction == null && activeSpan == null) {
            return NoOpNewRelicTracer.INSTANCE;
        }
        long startTimeInMillis = this.startTimeInMillis == 0L ? System.currentTimeMillis() : this.startTimeInMillis;
        long l = startTimeInNanos = this.startTimeInNanos == 0L ? System.nanoTime() : this.startTimeInNanos;
        if (!this.ignoreActiveSpan && this.parent == null && activeSpan != null) {
            this.addReference("child_of", activeSpan.context());
        }
        String id = TransactionGuidFactory.generateGuid();
        String parentId = null;
        if (this.parent != null) {
            parentId = ((NewRelicSpanContext)this.parent).getId();
        } else if (transaction != null) {
            parentId = transaction.getGuid();
        }
        String tripId = null;
        DistributedTracePayloadImpl inboundPayload = null;
        DistributedTracePayloadImpl outboundPayload = null;
        if (transaction != null) {
            inboundPayload = transaction.getInboundDistributedTracePayload();
            outboundPayload = transaction.getOutboundDistributedTracePayload();
        }
        if (inboundPayload != null) {
            tripId = inboundPayload.tripId;
        } else if (outboundPayload != null) {
            tripId = outboundPayload.tripId;
        } else if (this.parent != null) {
            tripId = ((NewRelicSpanContext)this.parent).getTripId();
        } else if (transaction != null && (tripId = transaction.getCrossProcessTransactionState().getTripId()) == null) {
            tripId = transaction.getGuid();
        }
        ConcurrentHashMap<String, String> baggage = new ConcurrentHashMap<String, String>();
        NewRelicSpanContext spanContext = new NewRelicSpanContext(id, parentId, tripId, baggage, transaction);
        return new NewRelicSpan(this.operationName, startTimeInMillis, startTimeInNanos, this.tags, baggage, spanContext);
    }

    public Span start() {
        return this.startManual();
    }
}

