/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent.tracing;

import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.AgentBridge;
import com.newrelic.agent.deps.com.google.common.collect.Maps;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.SegmentEvent;
import com.newrelic.agent.service.analytics.SegmentEventService;
import com.newrelic.api.agent.tracing.BaseNewRelicSpan;
import com.newrelic.api.agent.tracing.NewRelicSpanContext;
import io.opentracing.Span;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class NewRelicSpan
extends BaseNewRelicSpan<Span>
implements com.newrelic.api.agent.NewRelicSpan {
    private static final String defaultAppName = ServiceFactory.getConfigService().getDefaultAgentConfig().getApplicationName();
    private static final SegmentEventService segmentEventService = ServiceFactory.getSegmentEventService();
    private final long startTimeInMicros;
    private final long startTimeInNanos;
    private String operationName;
    private Map<String, Object> tags;
    private Map<String, Object> logs;
    private Map<String, String> baggage;

    NewRelicSpan(String operationName, long startTimeInMillis, long startTimeInNanos, Map<String, Object> tags, Map<String, String> baggage, NewRelicSpanContext context) {
        super(context);
        this.operationName = operationName;
        this.startTimeInMicros = TimeUnit.MILLISECONDS.toMicros(startTimeInMillis);
        this.startTimeInNanos = startTimeInNanos;
        this.tags = tags;
        this.baggage = baggage;
        this.setSpans(this, this);
    }

    @Override
    public Span setTag(String key, String value) {
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, Object>();
        }
        this.tags.put(key, value);
        return this;
    }

    @Override
    public Span setTag(String key, boolean value) {
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, Object>();
        }
        this.tags.put(key, value);
        return this;
    }

    @Override
    public Span setTag(String key, Number value) {
        if (this.tags == null) {
            this.tags = new ConcurrentHashMap<String, Object>();
        }
        this.tags.put(key, value);
        return this;
    }

    @Override
    public Span setOperationName(String operationName) {
        this.operationName = operationName;
        return this;
    }

    @Override
    public Span log(Map<String, ?> fields) {
        return this.log(this.getEpochTimestampMicroseconds(System.nanoTime()), fields);
    }

    @Override
    public Span log(long timestampMicroseconds, Map<String, ?> fields) {
        for (Map.Entry<String, ?> entry : fields.entrySet()) {
            this.log(timestampMicroseconds, entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public Span log(String event) {
        return this.log(this.getEpochTimestampMicroseconds(System.nanoTime()), event);
    }

    @Override
    public Span log(long timestampMicroseconds, String event) {
        return this.log(timestampMicroseconds, "event", event);
    }

    @Override
    public Span log(String eventName, Object payload) {
        return this.log(this.getEpochTimestampMicroseconds(System.nanoTime()), eventName, payload);
    }

    @Override
    public Span log(long timestampMicroseconds, String eventName, Object payload) {
        if (this.logs == null) {
            this.logs = new ConcurrentHashMap<String, Object>();
        }
        this.logs.put(eventName, payload);
        return this;
    }

    private long getEpochTimestampMicroseconds(long nanoTime) {
        long microsSinceStart = TimeUnit.NANOSECONDS.toMicros(nanoTime - this.startTimeInNanos);
        return this.startTimeInMicros + microsSinceStart;
    }

    @Override
    public Span setBaggageItem(String key, String value) {
        if (this.baggage == null) {
            this.baggage = new ConcurrentHashMap<String, String>();
        }
        this.baggage.put(key, value);
        return this;
    }

    @Override
    public String getBaggageItem(String key) {
        return this.baggage == null ? null : this.baggage.get(key);
    }

    public void finish() {
        this.finish(this.getEpochTimestampMicroseconds(System.nanoTime()));
    }

    public void finish(long finishMicros) {
        NewRelicSpanContext context = (NewRelicSpanContext)this.context();
        if (context == null) {
            AgentBridge.getAgent().getLogger().log(Level.FINER, "Unable to finish span: {0} due to missing context", (Object)this);
            return;
        }
        Transaction tx = context.getTransactionOrNull();
        String appName = tx != null ? tx.getApplicationName() : defaultAppName;
        HashMap<String, Object> attributes = this.tags != null ? Maps.newHashMap(this.tags) : Maps.newHashMap();
        long durationInMicros = finishMicros - this.startTimeInMicros;
        SegmentEvent segmentEvent = SegmentEvent.builder().setAppName(appName).setId(context.getId()).setParentId(context.getParentId()).setTripId(context.getTripId()).setName(this.operationName).setStartTime(TimeUnit.MICROSECONDS.toMillis(this.startTimeInMicros)).setDuration((float)durationInMicros / 1000000.0f).setCustomAttributes(attributes).build();
        AgentBridge.getAgent().getLogger().log(Level.FINEST, "Finish span: {0}, event: {1}", (Object)this, (Object)segmentEvent);
        segmentEventService.addSegmentEvent(segmentEvent);
    }

    public String toString() {
        return "NewRelicSpan{startTimeInMicros=" + this.startTimeInMicros + ", operationName='" + this.operationName + '\'' + ", tags=" + this.tags + ", logs=" + this.logs + ", baggage=" + this.baggage + '}';
    }
}

