/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.api.agent.tracing;

import com.newrelic.api.agent.Token;
import com.newrelic.api.agent.Trace;
import com.newrelic.api.agent.tracing.BaseNewRelicSpan;
import com.newrelic.api.agent.tracing.NewRelicSpan;
import com.newrelic.api.agent.tracing.NewRelicSpanContext;
import io.opentracing.ActiveSpan;
import java.util.concurrent.atomic.AtomicInteger;

public class NewRelicActiveSpan
extends BaseNewRelicSpan<ActiveSpan>
implements com.newrelic.api.agent.NewRelicActiveSpan {
    private final ThreadLocal<NewRelicActiveSpan> activeSpanThreadLocal;
    private final AtomicInteger refCount;
    private final NewRelicActiveSpan toRestore;
    private final Token token;

    public NewRelicActiveSpan(ThreadLocal<NewRelicActiveSpan> activeSpanThreadLocal, NewRelicSpan span, AtomicInteger refCount, Token token) {
        super((NewRelicSpanContext)span.context());
        this.setSpans(this, span);
        this.activeSpanThreadLocal = activeSpanThreadLocal;
        this.refCount = refCount;
        this.toRestore = activeSpanThreadLocal.get();
        this.token = token;
        activeSpanThreadLocal.set(this);
    }

    @Trace(async=true, excludeFromTransactionTrace=true)
    public void deactivate() {
        if (this.activeSpanThreadLocal.get() != this) {
            return;
        }
        this.activeSpanThreadLocal.set(this.toRestore);
        if (this.refCount.decrementAndGet() == 0) {
            if (this.token != null) {
                this.token.linkAndExpire();
            }
            this.underlyingSpan.finish();
        }
    }

    public void close() {
        this.deactivate();
    }

    public ActiveSpan.Continuation capture() {
        return new NewRelicContinuation();
    }

    public final class NewRelicContinuation
    implements com.newrelic.api.agent.NewRelicContinuation {
        NewRelicContinuation() {
            NewRelicActiveSpan.this.refCount.incrementAndGet();
        }

        public ActiveSpan activate() {
            return new NewRelicActiveSpan(NewRelicActiveSpan.this.activeSpanThreadLocal, NewRelicActiveSpan.this.underlyingSpan, NewRelicActiveSpan.this.refCount, NewRelicActiveSpan.this.token);
        }
    }
}

