/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Hostname;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import com.newrelic.agent.utilization.AWS;
import com.newrelic.agent.utilization.Azure;
import com.newrelic.agent.utilization.CloudData;
import com.newrelic.agent.utilization.DataFetcher;
import com.newrelic.agent.utilization.DockerData;
import com.newrelic.agent.utilization.GCP;
import com.newrelic.agent.utilization.PCF;
import com.newrelic.agent.utilization.UtilizationConfig;
import com.newrelic.agent.utilization.UtilizationData;
import java.lang.management.ManagementFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class UtilizationService
extends AbstractService {
    public static final String DETECT_AWS_KEY = "utilization.detect_aws";
    public static final String DETECT_DOCKER_KEY = "utilization.detect_docker";
    public static final String DETECT_PIVOTAL_CLOUD_FOUNDRY_KEY = "utilization.detect_pcf";
    public static final String DETECT_GOOGLE_CLOUD_PROVIDER_KEY = "utilization.detect_gcp";
    public static final String DETECT_AZURE_KEY = "utilization.detect_azure";
    protected volatile UtilizationData utilizationData;
    private final String hostName;
    private final String bootId;
    private Future<UtilizationData> future = null;
    private static final String THREAD_NAME = "New Relic Utilization Service";
    private static final ExecutorService executor = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("New Relic Utilization Service", true));
    private final boolean isLinux;
    private final boolean detectAws;
    private final boolean detectDocker;
    private final boolean detectPcf;
    private final boolean detectGcp;
    private final boolean detectAzure;
    private static final AWS aws = new AWS();
    private static final PCF pcf = new PCF();
    private static final GCP gcp = new GCP();
    private static final Azure azure = new Azure();
    private static final String DEFAULT_BOOT_ID = null;

    public UtilizationService() {
        super(UtilizationService.class.getSimpleName());
        AgentConfig agentConfig = ServiceFactory.getConfigService().getDefaultAgentConfig();
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.detectAws = (Boolean)config.getValue(DETECT_AWS_KEY, Boolean.TRUE);
        this.detectDocker = (Boolean)config.getValue(DETECT_DOCKER_KEY, Boolean.TRUE);
        this.detectPcf = (Boolean)config.getValue(DETECT_PIVOTAL_CLOUD_FOUNDRY_KEY, Boolean.TRUE);
        this.detectGcp = (Boolean)config.getValue(DETECT_GOOGLE_CLOUD_PROVIDER_KEY, Boolean.TRUE);
        this.detectAzure = (Boolean)config.getValue(DETECT_AZURE_KEY, Boolean.TRUE);
        this.hostName = Hostname.getHostname(agentConfig);
        this.isLinux = UtilizationService.isLinuxOs();
        this.bootId = DEFAULT_BOOT_ID;
        this.utilizationData = new UtilizationData(this.hostName, null, null, this.bootId, null, null, UtilizationConfig.EMPTY_DATA);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() throws Exception {
        this.scheduleUtilizationTask();
    }

    @Override
    protected void doStop() throws Exception {
        executor.shutdownNow();
    }

    private void scheduleUtilizationTask() {
        this.future = executor.submit(new UtilizationTask());
    }

    public UtilizationData updateUtilizationData() {
        if (this.future == null) {
            this.future = executor.submit(new UtilizationTask());
        }
        try {
            this.utilizationData = this.future.get(2000L, TimeUnit.MILLISECONDS);
            this.future = null;
        }
        catch (TimeoutException e) {
            Agent.LOG.log(Level.FINER, "Utilization task timed out. Returning cached utilization data.");
        }
        catch (Throwable t) {
            Agent.LOG.log(Level.FINEST, "Utilization task exception. Returning cached utilization data. {0}", t);
        }
        return this.utilizationData;
    }

    private static boolean isLinuxOs() {
        String os = ManagementFactory.getOperatingSystemMXBean().getName().toLowerCase();
        return os != null && !os.startsWith("windows") && !os.startsWith("mac");
    }

    protected AWS.AwsData getAwsData() {
        return aws.getData();
    }

    protected PCF.PcfData getPcfData() {
        return pcf.getData();
    }

    protected GCP.GcpData getGcpData() {
        return gcp.getData();
    }

    protected Azure.AzureData getAzureData() {
        return azure.getData();
    }

    protected String getDockerContainerId(String cloudVendor) {
        return DockerData.getDockerContainerId(this.isLinux, cloudVendor);
    }

    class UtilizationTask
    implements Callable<UtilizationData> {
        UtilizationTask() {
        }

        @Override
        public UtilizationData call() throws Exception {
            return this.doUpdateUtilizationData();
        }

        private UtilizationData doUpdateUtilizationData() {
            AWS.AwsData awsData;
            String currentCloudVendor = null;
            CloudData foundData = null;
            AWS.AwsData awsData2 = awsData = UtilizationService.this.detectAws ? UtilizationService.this.getAwsData() : AWS.AwsData.EMPTY_DATA;
            if (awsData != AWS.AwsData.EMPTY_DATA) {
                currentCloudVendor = awsData.getProvider();
                foundData = awsData;
            } else {
                PCF.PcfData pcfData;
                PCF.PcfData pcfData2 = pcfData = UtilizationService.this.detectPcf ? UtilizationService.this.getPcfData() : PCF.PcfData.EMPTY_DATA;
                if (pcfData != PCF.PcfData.EMPTY_DATA) {
                    currentCloudVendor = pcfData.getProvider();
                    foundData = pcfData;
                } else {
                    GCP.GcpData gcpData;
                    GCP.GcpData gcpData2 = gcpData = UtilizationService.this.detectGcp ? UtilizationService.this.getGcpData() : GCP.GcpData.EMPTY_DATA;
                    if (gcpData != GCP.GcpData.EMPTY_DATA) {
                        currentCloudVendor = gcpData.getProvider();
                        foundData = gcpData;
                    } else {
                        Azure.AzureData azureData;
                        Azure.AzureData azureData2 = azureData = UtilizationService.this.detectAzure ? UtilizationService.this.getAzureData() : Azure.AzureData.EMPTY_DATA;
                        if (azureData != Azure.AzureData.EMPTY_DATA) {
                            currentCloudVendor = azureData.getProvider();
                            foundData = azureData;
                        }
                    }
                }
            }
            String dockerContainerId = UtilizationService.this.detectDocker ? UtilizationService.this.getDockerContainerId(currentCloudVendor) : null;
            int processorCount = DataFetcher.getLogicalProcessorCount();
            long totalRamInMib = DataFetcher.getTotalRamInMib();
            String bootId = DataFetcher.getBootId();
            UtilizationConfig configData = UtilizationConfig.createFromConfigService();
            return new UtilizationData(UtilizationService.this.hostName, processorCount, dockerContainerId, bootId, foundData, totalRamInMib, configData);
        }
    }
}

