/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.utilization;

import com.newrelic.agent.utilization.CloudData;
import com.newrelic.agent.utilization.UtilizationConfig;
import java.util.HashMap;
import java.util.Map;

public class UtilizationData {
    private static final String METADATA_VERSION_KEY = "metadata_version";
    private static final String LOGICAL_CORES_KEY = "logical_processors";
    private static final String RAM_KEY = "total_ram_mib";
    private static final String HOSTNAME_KEY = "hostname";
    private static final String VENDORS_KEY = "vendors";
    private static final String BOOT_ID = "boot_id";
    private static final String DOCKER = "docker";
    private static final String DOCKER_ID_KEY = "id";
    private static final String CONFIG_KEY = "config";
    private CloudData cloudData;
    private final String hostname;
    private final Integer logicalProcessorCount;
    private final String dockerContainerId;
    private final String bootId;
    private final Long totalRamMib;
    private final UtilizationConfig dataConfig;

    public UtilizationData(String host, Integer logicalProcessorCt, String dockerId, String bootId, CloudData cloudData, Long ram, UtilizationConfig configData) {
        this.hostname = host;
        this.logicalProcessorCount = Integer.valueOf(0).equals(logicalProcessorCt) ? null : logicalProcessorCt;
        this.dockerContainerId = dockerId;
        this.bootId = bootId;
        this.cloudData = cloudData;
        this.totalRamMib = Long.valueOf(0L).equals(ram) ? null : ram;
        this.dataConfig = configData;
    }

    public Map<String, Object> map() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(METADATA_VERSION_KEY, 3);
        data.put(LOGICAL_CORES_KEY, this.logicalProcessorCount);
        data.put(RAM_KEY, this.totalRamMib);
        data.put(HOSTNAME_KEY, this.hostname);
        if (this.bootId != null) {
            data.put(BOOT_ID, this.bootId);
        }
        HashMap<String, Map<String, String>> vendors = new HashMap<String, Map<String, String>>();
        if (this.cloudData != null && !this.cloudData.isEmpty()) {
            vendors.put(this.cloudData.getProvider(), this.cloudData.getValueMap());
        }
        HashMap<String, Object> utilizationConfig = new HashMap<String, Object>();
        if (this.dataConfig.getHostname() != null) {
            utilizationConfig.put(HOSTNAME_KEY, this.dataConfig.getHostname());
        }
        if (this.dataConfig.getLogicalProcessors() != null) {
            utilizationConfig.put(LOGICAL_CORES_KEY, this.dataConfig.getLogicalProcessors());
        }
        if (this.dataConfig.getTotalRamMib() != null) {
            utilizationConfig.put(RAM_KEY, this.dataConfig.getTotalRamMib());
        }
        if (!utilizationConfig.isEmpty()) {
            data.put(CONFIG_KEY, utilizationConfig);
        }
        if (this.dockerContainerId != null) {
            HashMap<String, String> docker = new HashMap<String, String>();
            docker.put(DOCKER_ID_KEY, this.dockerContainerId);
            vendors.put(DOCKER, docker);
        }
        if (!vendors.isEmpty()) {
            data.put(VENDORS_KEY, vendors);
        }
        return data;
    }
}

