/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transport;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.transport.DataSender;
import com.newrelic.agent.transport.DataSenderImpl;
import com.newrelic.agent.transport.DataSenderListener;
import com.newrelic.agent.transport.IDataSenderFactory;

public class DataSenderFactory {
    private static volatile IDataSenderFactory DATA_SENDER_FACTORY = new DefaultDataSenderFactory();

    private DataSenderFactory() {
    }

    public static void setDataSenderFactory(IDataSenderFactory dataSenderFactory) {
        if (dataSenderFactory == null) {
            return;
        }
        DATA_SENDER_FACTORY = dataSenderFactory;
    }

    public static IDataSenderFactory getDataSenderFactory() {
        return DATA_SENDER_FACTORY;
    }

    public static DataSender create(AgentConfig config) {
        return DATA_SENDER_FACTORY.create(config);
    }

    public static DataSender create(AgentConfig config, DataSenderListener dataSenderListener) {
        return DATA_SENDER_FACTORY.create(config, dataSenderListener);
    }

    private static class DefaultDataSenderFactory
    implements IDataSenderFactory {
        private DefaultDataSenderFactory() {
        }

        @Override
        public DataSender create(AgentConfig config) {
            return this.create(config, null);
        }

        @Override
        public DataSender create(AgentConfig config, DataSenderListener dataSenderListener) {
            return new DataSenderImpl(config, dataSenderListener);
        }
    }
}

