/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.transaction.AbstractTransactionNamer;
import com.newrelic.agent.transaction.TransactionNamer;
import java.text.MessageFormat;
import java.util.logging.Level;

public class WebTransactionNamer
extends AbstractTransactionNamer {
    private WebTransactionNamer(Transaction tx, String requestUri) {
        super(tx, requestUri);
    }

    @Override
    public void setTransactionName() {
        if (!this.canSetTransactionName(TransactionNamePriority.STATUS_CODE)) {
            return;
        }
        Transaction tx = this.getTransaction();
        int responseStatusCode = tx.getStatus();
        if (responseStatusCode >= 400) {
            String normalizedStatus = WebTransactionNamer.normalizeStatus(responseStatusCode);
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" using response status", normalizedStatus);
                Agent.LOG.finer(msg);
            }
            if (this.canSetTransactionName(TransactionNamePriority.STATUS_CODE)) {
                this.setTransactionName(normalizedStatus, "NormalizedUri", TransactionNamePriority.STATUS_CODE);
                tx.freezeStatus();
            }
            return;
        }
        if (!this.canSetTransactionName()) {
            return;
        }
        String requestUri = this.getUri();
        if (requestUri == null) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" because request uri is null", "Unknown");
                Agent.LOG.finer(msg);
            }
            this.setTransactionName("Unknown", "NormalizedUri", TransactionNamePriority.REQUEST_URI);
            return;
        }
        String appName = tx.getPriorityApplicationName().getName();
        String normalizedUri = ServiceFactory.getNormalizationService().getUrlNormalizer(appName).normalize(requestUri);
        if (normalizedUri == null) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = "Ignoring transaction because normalized request uri is null";
                Agent.LOG.finer(msg);
            }
            tx.setIgnore(true);
            return;
        }
        if (normalizedUri == requestUri) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Setting transaction name to \"{0}\" using request uri", requestUri);
                Agent.LOG.finer(msg);
            }
            this.setTransactionName(requestUri, "Uri", TransactionNamePriority.REQUEST_URI);
            return;
        }
        if (Agent.LOG.isLoggable(Level.FINER)) {
            String msg = MessageFormat.format("Setting transaction name to \"{0}\" using normalized request uri", normalizedUri);
            Agent.LOG.finer(msg);
        }
        this.setTransactionName(normalizedUri, "NormalizedUri", TransactionNamePriority.REQUEST_URI);
    }

    private static String normalizeStatus(int responseStatus) {
        return "/" + String.valueOf(responseStatus) + "/*";
    }

    public static TransactionNamer create(Transaction tx, String requestUri) {
        return new WebTransactionNamer(tx, requestUri);
    }
}

