/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.tracing;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.DistributedTracePayloadImpl;
import com.newrelic.agent.ExtendedTransactionListener;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.Transaction;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.bridge.TransportType;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.deps.com.google.common.base.Joiner;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceFactory;
import com.newrelic.agent.service.analytics.DistributedSamplingAwareReservoir;
import com.newrelic.agent.service.analytics.TransactionEvent;
import com.newrelic.agent.service.analytics.TransactionEventsService;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.TransactionStats;
import com.newrelic.agent.tracing.DistributedTraceService;
import com.newrelic.api.agent.NewRelic;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

public class DistributedTraceServiceImpl
extends AbstractService
implements DistributedTraceService,
ConnectionListener,
ExtendedTransactionListener,
HarvestListener {
    private static final Joiner joiner = Joiner.on(',');
    private static final Random random = new Random();
    private static final int MAJOR_CAT_VERSION = 0;
    private static final int MINOR_CAT_VERSION = 0;
    private final boolean enabled;
    private final AtomicReference<String> accountId = new AtomicReference();
    private final AtomicReference<String> applicationId = new AtomicReference();
    private final AtomicBoolean firstHarvest = new AtomicBoolean(true);
    private final TransactionEventsService transactionEventsService;

    public DistributedTraceServiceImpl() {
        super(DistributedTraceServiceImpl.class.getSimpleName());
        AgentConfig config = ServiceFactory.getConfigService().getDefaultAgentConfig();
        this.enabled = config.distributedTracingEnabled();
        this.transactionEventsService = ServiceFactory.getTransactionEventsService();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.enabled) {
            ServiceFactory.getRPMServiceManager().addConnectionListener(this);
            ServiceFactory.getTransactionService().addTransactionListener(this);
            ServiceFactory.getHarvestService().addHarvestListener(this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceFactory.getRPMServiceManager().removeConnectionListener(this);
        ServiceFactory.getTransactionService().removeTransactionListener(this);
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    @Override
    public void connected(IRPMService rpmService, Map<String, Object> connectionInfo) {
        String appId;
        String[] crossProcessIds;
        Object crossProcessId = connectionInfo.get("cross_process_id");
        if (crossProcessId != null && (crossProcessIds = String.valueOf(crossProcessId).split("#")).length == 2) {
            this.accountId.set(crossProcessIds[0]);
            this.applicationId.set(crossProcessIds[1]);
        }
        if ((appId = (String)connectionInfo.get("application_id")) != null) {
            this.applicationId.set(appId);
        }
        this.applicationId.compareAndSet(null, "0");
    }

    @Override
    public void disconnected(IRPMService rpmService) {
        this.accountId.set(null);
    }

    @Override
    public void beforeHarvest(String appName, StatsEngine statsEngine) {
        this.firstHarvest.set(false);
        ServiceFactory.getHarvestService().removeHarvestListener(this);
    }

    @Override
    public void afterHarvest(String appName) {
    }

    @Override
    public int getMajorSupportedCatVersion() {
        return 0;
    }

    @Override
    public int getMinorSupportedCatVersion() {
        return 0;
    }

    @Override
    public String getAccountId() {
        return this.accountId.get();
    }

    @Override
    public String getApplicationId() {
        return this.applicationId.get();
    }

    @Override
    public Boolean shouldSample(String appName, Boolean sampled, boolean isSynthetic) {
        if (sampled == null) {
            boolean shouldSample;
            int target;
            DistributedSamplingAwareReservoir<TransactionEvent> reservoir = isSynthetic ? this.transactionEventsService.getSyntheticDistributedSamplingReservoir(appName) : this.transactionEventsService.getDistributedSamplingReservoir(appName);
            if (reservoir == null || reservoir.full()) {
                return false;
            }
            int seen = reservoir.getNumberOfTries();
            if (this.firstHarvest.get()) {
                if (seen <= 10) {
                    return true;
                }
                return false;
            }
            int seenLast = reservoir.getSeenLast();
            int recorded = reservoir.getRecorded();
            if (recorded < (target = reservoir.getTarget())) {
                shouldSample = random.nextInt(seenLast) < target;
            } else {
                int expTarget = (int)(Math.pow(target, (float)target / (float)recorded) - Math.pow(target, 0.51));
                shouldSample = random.nextInt(seen) < expTarget;
            }
            return shouldSample;
        }
        return sampled;
    }

    @Override
    public Map<String, Object> getIntrinsics(DistributedTracePayloadImpl inboundPayload, TransportType transportType, long callerTransportDurationInMillis, long callerTransportDurationIntermediaryInMillis, long largestTransportDuration, int depth, int order, Collection<String> parentIds, boolean sampled) {
        HashMap<String, Object> intrinsicAttributes = new HashMap<String, Object>();
        try {
            if (inboundPayload != null) {
                intrinsicAttributes.put("caller.type", transportType.name());
                if (inboundPayload.callerApplicationId != null) {
                    intrinsicAttributes.put("caller.app", inboundPayload.callerApplicationId);
                }
                if (inboundPayload.callerAccountId != null) {
                    intrinsicAttributes.put("caller.account", inboundPayload.callerAccountId);
                }
                if (inboundPayload.callerType != null) {
                    intrinsicAttributes.put("caller.transportType", inboundPayload.callerType);
                }
                if (inboundPayload.host != null) {
                    intrinsicAttributes.put("caller.host", inboundPayload.host);
                }
                if (callerTransportDurationInMillis >= 0L) {
                    float transportDurationSec = (float)callerTransportDurationInMillis / 1000.0f;
                    intrinsicAttributes.put("caller.transportDuration", Float.valueOf(transportDurationSec));
                }
                if (callerTransportDurationIntermediaryInMillis >= 0L) {
                    float intermediaryDurationInSec = (float)callerTransportDurationIntermediaryInMillis / 1000.0f;
                    intrinsicAttributes.put("caller.transportDuration.{intermediary}", Float.valueOf(intermediaryDurationInSec));
                }
                if (largestTransportDuration >= 0L) {
                    intrinsicAttributes.put("caller.queueDuration", largestTransportDuration);
                }
                if (inboundPayload.order >= 0) {
                    intrinsicAttributes.put("nr.order", inboundPayload.order);
                }
            }
            if (parentIds != null && !parentIds.isEmpty()) {
                intrinsicAttributes.put("nr.parentIds", joiner.join(parentIds));
            }
            if (depth >= 0) {
                intrinsicAttributes.put("nr.depth", depth);
            }
            intrinsicAttributes.put("nr.sampled", sampled);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e, "Failed to retrieve distributed trace intrinsics.");
            NewRelic.incrementCounter((String)"Supportability/DistributedTrace/Intrinsics/Exception");
        }
        return intrinsicAttributes;
    }

    @Override
    public void dispatcherTransactionStarted(Transaction transaction) {
    }

    @Override
    public void dispatcherTransactionCancelled(Transaction transaction, Throwable cause) {
    }

    @Override
    public void dispatcherTransactionFinished(TransactionData transactionData, TransactionStats transactionStats) {
        Map<String, Object> distributedTracingIntrinsics = this.getIntrinsics(transactionData.getInboundDistributedTracePayload(), transactionData.getTransportType(), transactionData.getTransportDurationInMillis(), transactionData.getTransportDurationIntermediaryInMillis(), transactionData.getLargestTransportDurationInMillis(), transactionData.getDepth(), transactionData.getOrder(), transactionData.getParentIds(), transactionData.getSampled());
        transactionData.getIntrinsicAttributes().putAll(distributedTracingIntrinsics);
        this.recordMetrics(transactionData, transactionStats);
    }

    private void recordMetrics(TransactionData transactionData, TransactionStats transactionStats) {
        DistributedTracePayloadImpl payload = transactionData.getInboundDistributedTracePayload();
        if (payload == null) {
            transactionStats.getUnscopedStats().getResponseTimeStats("DurationByCaller/Unknown/Unknown/Unknown/transport/all").recordResponseTimeInNanos(transactionData.getTransactionTime().getResponseTimeInNanos());
            if (transactionData.hasReportableErrorThatIsNotIgnored()) {
                transactionStats.getUnscopedStats().getStats("ErrorsByCaller/Unknown/Unknown/Unknown/all").incrementCallCount();
            }
        } else {
            String durationByMetric = MessageFormat.format("DurationByCaller/{0}/{1}/{2}/transport/all", payload.callerType, payload.callerAccountId, payload.callerApplicationId, transactionData.getTransportType().name());
            transactionStats.getUnscopedStats().getResponseTimeStats(durationByMetric).recordResponseTimeInNanos(transactionData.getTransactionTime().getResponseTimeInNanos());
            String transportDuration = MessageFormat.format("TransportDuration/{0}/{1}/{2}/all", payload.callerType, payload.callerAccountId, payload.callerApplicationId, transactionData.getTransportType().name());
            transactionStats.getUnscopedStats().getResponseTimeStats(transportDuration).recordResponseTime(transactionData.getTransactionTime().getStartTimeInMilliseconds() - payload.timestamp, TimeUnit.MILLISECONDS);
            if (transactionData.hasReportableErrorThatIsNotIgnored()) {
                String errorsByCaller = MessageFormat.format("ErrorsByCaller{0}/{1}/{2}/all", payload.callerType, payload.callerAccountId, payload.callerApplicationId, transactionData.getTransportType().name());
                transactionStats.getUnscopedStats().getStats(errorsByCaller).incrementCallCount();
            }
        }
    }
}

